{*********************************************************}
{*                    EXFLIST0.PAS                       *}
{*      Copyright (c) TurboPower Software 1996-98        *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit ExFList0;

interface

uses
  SysUtils, Classes, QGraphics, QControls,
  QForms, QDialogs, AxProtcl, AxPStat, AxPort, QStdCtrls, AxExcept,
  AxMisc, AxTerm, Qt, QTypes;

type
  TExampleFList = class(TForm)               
    ApxComPort1: TApxComPort;
    ApxProtocol1: TApxProtocol;
    ApxProtocolStatus1: TApxProtocolStatus;
    ApxProtocolLog1: TApxProtocolLog;
    AddFiles: TButton;
    ApxTerminal1: TApxTerminal;
    procedure ApxTerminal1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ApxProtocol1ProtocolError(CP: TObject; ErrorCode: Integer);
    procedure AddFilesClick(Sender: TObject);
    procedure ApxProtocol1ProtocolNextFile(CP: TObject; var FName: String);
  private
    { Private declarations }
    FileList : TStringList;
    FileIndex : Word;
  public
    { Public declarations }
    constructor Create(AComponent : TComponent); override;
  end;

var
  ExampleFList: TExampleFList;

implementation

{$R *.xfm}

constructor TExampleFList.Create(AComponent : TComponent);
begin
  inherited Create(AComponent);
  FileList := TStringList.Create;
end;

procedure TExampleFList.ApxTerminal1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = Key_PageUp then
    ApxProtocol1.StartTransmit
  else if Key = Key_PageDown then
    ApxProtocol1.StartReceive;
end;

procedure TExampleFList.ApxProtocol1ProtocolError(CP: TObject;
  ErrorCode: Integer);
begin
  ShowMessage('Fatal protocol error: ' + ErrorMsg(ErrorCode));
end;

procedure TExampleFList.AddFilesClick(Sender: TObject);
begin
  FileList.Add('ExFList.dpr');
  FileList.Add('ExFList0.pas');
  FileList.Add('ExFList0.xfm');
  FileIndex := 0;

  ApxTerminal1.WriteString('Files added!');
  ApxTerminal1.SetFocus;
end;
 procedure TExampleFList.ApxProtocol1ProtocolNextFile(CP: TObject;
  var FName: String);
begin
  try
    FName := FileList[FileIndex];
    Inc(FileIndex);
  except
    FName := '';
  end;
end;

 end.
