unit ExModem0;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QComCtrls, QTypes, 
  AxModem, AxMisc, AxPort, AxTerm;

type
  TfrmExModem = class(TForm)
    ApxModem1: TApxModem;
    btnSelectModem: TButton;
    lblModemManufacturer: TLabel;
    lblModemName: TLabel;
    ListBox1: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    edtModemCapFolder: TEdit;
    btnConfigAndOpen: TButton;
    btnDial: TButton;
    btnAnswer: TButton;
    Label3: TLabel;
    edtPhoneNumber: TEdit;
    Label4: TLabel;
    edtAnswerOnRing: TSpinEdit;
    btnShowConfigDialog: TButton;
    btnCancelCall: TButton;
    ApxComPort1: TApxComPort;
    ApxModemStatus1: TApxModemStatus;
    ApxTerminal1: TApxTerminal;
    procedure btnSelectModemClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnShowConfigDialogClick(Sender: TObject);
    procedure btnConfigAndOpenClick(Sender: TObject);
    procedure btnDialClick(Sender: TObject);
    procedure btnAnswerClick(Sender: TObject);
    procedure ApxModem1ModemConnect(Modem: TApxCustomModem);
    procedure ApxModem1ModemDisconnect(Modem: TApxCustomModem);
    procedure ApxModem1ModemFail(Modem: TApxCustomModem);
    procedure ApxModem1ModemLog(Modem: TApxCustomModem;
      LogCode: TApxModemLogCode);
    procedure ApxModem1ModemStatus(Modem: TApxCustomModem;
      ModemState: TApxModemState);
    procedure btnCancelCallClick(Sender: TObject);
    procedure ApxModem1ModemCallerID(Modem: TApxCustomModem;
      CallerID: TApxCallerIDInfo);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Add(const S : string);
  end;

var
  frmExModem: TfrmExModem;

implementation

{$R *.xfm}

procedure TfrmExModem.Add(const S: string);
  { utility method to add a string to our listbox and scroll }
begin
  ListBox1.Items.Add(S);
  ListBox1.ItemIndex := pred(ListBox1.Items.Count);
  ListBox1.ItemIndex := ListBox1.Items.Count;
end;

procedure TfrmExModem.btnSelectModemClick(Sender: TObject);
begin
  Add('Selecting a device');
  ApxModem1.ModemCapFolder := edtModemCapFolder.Text;
  if ApxModem1.SelectDevice then begin
    Add('  selected manufacturer: ' + ApxModem1.SelectedDevice.Manufacturer);
    Add('  selected name: ' + ApxModem1.SelectedDevice.Name);
    lblModemManufacturer.Caption := 'Modem manufacturer: ' + ApxModem1.SelectedDevice.Manufacturer;
    lblModemName.Caption := 'Modem name: ' + ApxModem1.SelectedDevice.Name;
    { enable our buttons }
    btnShowConfigDialog.Enabled := True;
    btnConfigAndOpen.Enabled := True;
    btnCancelCall.Enabled := True;
    btnDial.Enabled := True;
    btnAnswer.Enabled := True;
    edtPhoneNumber.Enabled := True;
    edtAnswerOnRing.Enabled := True;
  end else
    Add(' modem selection cancelled');
end;

procedure TfrmExModem.FormCreate(Sender: TObject);
begin
  edtModemCapFolder.Text := ApxModem1.ModemCapFolder;
  edtAnswerOnRing.Value := ApxModem1.AnswerOnRing;
end;

procedure TfrmExModem.btnShowConfigDialogClick(Sender: TObject);
begin
  if ApxModem1.ShowConfigDialog then
    Add('Modem configuration changed')
  else
    Add('Modem configuration cancelled');
end;

procedure TfrmExModem.btnConfigAndOpenClick(Sender: TObject);
begin
  Add('Beginning ConfigAndOpen');
  ApxModem1.ConfigAndOpen;
end;

procedure TfrmExModem.btnDialClick(Sender: TObject);
begin
  Add('Beginning dial to ' + edtPhoneNumber.Text);
  ApxModem1.Dial(edtPhoneNumber.Text);
  Add('Done with dial');
end;

procedure TfrmExModem.btnAnswerClick(Sender: TObject);
begin
  Add('Beginning autoanswer (waiting for ' + edtAnswerOnRing.Text + ' rings)');
  ApxModem1.AnswerOnRing := edtAnswerOnRing.Value;
  ApxModem1.AutoAnswer;
end;

procedure TfrmExModem.ApxModem1ModemConnect(Modem: TApxCustomModem);
begin
  Add('OnModemConnect');
  { if .Connected is True we've made a connection using the Dial or }
  { AutoAnswer methods, send a greeting to the other side }
  if ApxModem1.Connected then
    ApxComPort1.Output := #13#10'Welcome to the ApxModem example'#13#10;
end;

procedure TfrmExModem.ApxModem1ModemDisconnect(Modem: TApxCustomModem);
begin
  Add('OnModemDisconnect');
end;

procedure TfrmExModem.ApxModem1ModemFail(Modem: TApxCustomModem);
begin
  Add('OnModemFail (' + ApxModem1.FailureCodeMsg(ApxModem1.FailureCode) + ')');
end;

procedure TfrmExModem.ApxModem1ModemLog(Modem: TApxCustomModem;
  LogCode: TApxModemLogCode);
begin
  Add('OnModemLog (' + ApxModem1.ModemLogToString(LogCode) + ')');
end;

procedure TfrmExModem.ApxModem1ModemStatus(Modem: TApxCustomModem;
  ModemState: TApxModemState);
begin
  Add('OnModemStatus (' + ApxModem1.ModemStatusMsg(ModemState) + ')');
end;

procedure TfrmExModem.btnCancelCallClick(Sender: TObject);
begin
  Add('Cancelling the call');
  ApxModem1.CancelCall;
end;

procedure TfrmExModem.ApxModem1ModemCallerID(Modem: TApxCustomModem;
  CallerID: TApxCallerIDInfo);
begin
  Add('OnModemCallerID');
  Add('  Name: ' + CallerID.Name);
  Add('  Nmbr: ' + CallerID.Number);
end;

end.
