{$G+,X+,F+}

{Conditional defines that may affect this unit}
{$I AxDefine.inc}

{*********************************************************}
{*                      TDMAIN.PAS                       *}
{*        Copyright (c) TurboPower Software 1996-98      *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit TdMain;

interface             

uses
  SysUtils, Classes, QGraphics, QControls,
  QForms, QDialogs, AxMisc, AxExcept, AxPort, AxXPort, 
  QMenus, QExtCtrls, QStdCtrls, AxProtcl, AxPStat, AxModem, AxTerm, QTypes,
  Qt, QComCtrls;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    F1: TMenuItem;
    E1: TMenuItem;
    C1: TMenuItem;
    F2: TMenuItem;
    P1: TMenuItem;
    C2: TMenuItem;
    N1: TMenuItem;
    E2: TMenuItem;
    C3: TMenuItem;
    S1: TMenuItem;
    OpenDialog1: TOpenDialog;
    FontDialog1: TFontDialog;
    ApxComPort1: TApxComPort;
    N2: TMenuItem;
    Terminal1: TApxTerminal;
    ApxVT100Emulator1: TApxVT100Emulator;
    StatusLine: TStatusBar;
    procedure Terminal1TerminalStatus(CP: TObject; Row, Col: Byte; BufRow,
      BufCol: Word);
    procedure P1Click(Sender: TObject);
    procedure ApxComPort1PortChange(CP: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure C2Click(Sender: TObject);
    procedure E2Click(Sender: TObject);
    procedure C3Click(Sender: TObject);
    procedure S1Click(Sender: TObject);
    procedure F2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Terminal1KeyPress(Sender: TObject; var Key: Char);
    procedure Terminal1CursorMoved(aSender: TObject; aRow, aCol: Integer);
  private
    { Private declarations }
    ProgramShutDown : Boolean;
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure UpdateComInfo(Term : TApxTerminal);
  public
    { Public declarations }
  end;

const
  ParityName : array [0..4] of char = ('N', 'O', 'E', 'M', 'S');
  
var
  MainForm: TMainForm;

implementation

const
  UseFile : Boolean = False;

var
  AnsiFile : String;
  AF       : File;
  AFBuffer : array[1..4096] of Char;
  AFIndex  : Word;

{$R *.xfm}

function IntToStr(L : Longint) : String;
begin
  Str(L , Result);
end;

procedure OpenFile;
  {-Open file and prepare for playback}
begin
  Assign(AF, AnsiFile);
  Reset(AF,1);
  UseFile := True;
  AFIndex := SizeOf(AFBuffer)+1;
  if IoResult <> 0 then
    Halt;
end;

function ReadNextChar(var C : Char) : Boolean;
  {-Return next character from AF}
const
  BytesRead : Cardinal = 0;
begin
  ReadNextChar := False;
  if AFIndex > BytesRead then begin
    BlockRead(AF, AFBuffer, SizeOf(AFBuffer), BytesRead);
    if (IoResult <> 0) or (BytesRead = 0) then
      Exit;
    AFIndex := 1;
  end;
  C := AFBuffer[AFIndex];
  Inc(AFIndex);
  ReadNextChar := True;
end;

procedure TMainForm.AppIdle(Sender: TObject; var Done: Boolean);
const
  PaintInterval = 200;
  CharCount : Word = 0;
var
  C : Char;
begin
  Done := True;
  if UseFile then
    repeat
      {Get next char from file}
      if ReadNextChar(C) then begin
        Terminal1.WriteChar(C);
        Inc(CharCount);
        if CharCount > PaintInterval then begin
          {Terminal1.ForcePaint;}
          CharCount := 0;
          Exit;
        end else begin
          Done := False;
          Exit;
        end;
      end else begin
        {Terminal1.ForcePaint;}
        CloseFile(AF);
        UseFile := False;
        Exit;
      end;
    until False;
end;

procedure TMainForm.UpdateComInfo(Term : TApxTerminal);
  {-Update the comport information}
var
  S : String;
begin
  if (ApxComPort1 <> nil) then begin
    {Name}
    S := ' ' + ApxComPort1.DeviceName + ' ';

    {Line params}
    S := S + IntToStr (11 - Ord (ApxComPort1.Databits));
    S := S + ParityName[Ord (ApxComPort1.Parity)];
    S := S + IntToStr (1 + Ord (ApxComPort1.Stopbits)) + ' ';

    {Baud}
    S := S + IntToStr(ApxComPort1.Baud);
  end;
  StatusLine.Panel[ppLeft, 0].Text := S;
end;

procedure TMainForm.Terminal1TerminalStatus(CP: TObject; Row, Col: Byte;
                                         BufRow, BufCol: Word);
begin
  {Update rows/columns}
  StatusLine.Panel[ppLeft, 1].Text := Format('%2d %2d', [Row, Col]);
  StatusLine.Panel[ppLeft, 2].Text := Format('%2d %2d', [BufRow, BufCol]);
  StatusLine.Panel[ppLeft, 3].Text := '';

  {Set widths}
  StatusLine.Panel[ppLeft, 0].Width := 155;
  StatusLine.Panel[ppLeft, 1].Width := 45;
  StatusLine.Panel[ppLeft, 2].Width := 55;
end;

procedure TMainForm.P1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    {Open file and prepare to read}
    AnsiFile := OpenDialog1.FileName;
    OpenFile;
  end;
end;


procedure TMainForm.ApxComPort1PortChange(CP: TObject);
begin
  {Update the cominfo portion of the status line}
  UpdateComInfo(Terminal1);
end;


procedure TMainForm.FormActivate(Sender: TObject);
begin
  UpdateComInfo(Terminal1);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnIdle := AppIdle;
  ProgramShutDown := False;
end;

procedure TMainForm.C2Click(Sender: TObject);
begin
  Terminal1.ClearAll;
end;

procedure TMainForm.E2Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.C3Click(Sender: TObject);
begin
  Terminal1.CopyToClipboard;
end;

procedure TMainForm.S1Click(Sender: TObject);
begin

  if (ApxComPort1 <> nil) then
    ComPortOptions.ComPort := ApxComPort1;

  if ComPortOptions.Execute then begin 
    if (ComPortOptions.ComPort <> nil) then begin
      { Close and open com ports }
      ApxComPort1.Open := False;

      {reassign the new com port properties }
      ApxComPort1.Assign(ComPortOptions.ComPort);
      ApxComPort1.DeviceName := ComPortOptions.ComPort.DeviceName;

      { tell the terminal that we want to be active }
      Terminal1.Active := True;

      ApxComPort1.Open := True;
    end;
  end; 

  {Update the cominfo portion of the status line}
  UpdateComInfo(Terminal1);

  {Give focus back to terminal window}
  Terminal1.SetFocus;
end;

procedure TMainForm.F2Click(Sender: TObject);
begin
  FontDialog1.Font := Terminal1.Font;
  if FontDialog1.Execute then
    Terminal1.Font := FontDialog1.Font;
  Terminal1.Width := Terminal1.CharWidth * 80;
  Terminal1.Height := Terminal1.CharHeight * 25;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
                                Shift: TShiftState);
begin
  if Key = Key_Insert then
    Terminal1.Scrollback := not Terminal1.Scrollback;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  ProgramShutDown := True;
end;

procedure TMainForm.Terminal1KeyPress(Sender: TObject; var Key: Char);
begin
  { select the port if it isn't already selected }
  if ApxComPort1.DeviceName = '' then
    S1.Click;
end;
 procedure TMainForm.Terminal1CursorMoved(aSender: TObject; aRow,
  aCol: Integer);
begin
  StatusLine.Panel[ppLeft, 1].Text := Format('%2d %2d', [aRow, aCol]);
  StatusLine.Panel[ppLeft, 3].Text := '';

  {Set widths}
  StatusLine.Panel[ppLeft, 0].Width := 155;
  StatusLine.Panel[ppLeft, 1].Width := 45;
  StatusLine.Panel[ppLeft, 2].Width := 55;
end;


end.


