(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)

{*********************************************************}
{*                   AxAbout.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F-,V-,P-,T-,B-}

unit AxAbout;
{- component about box}
interface

uses
  SysUtils, Classes, QForms, QDialogs, AxSystem,
  AxMisc, QStdCtrls, QExtCtrls, QControls, Libc, QGraphics;

const
  MaxBrowsers = 25;
  MaxNewsreaders = 18;

type
  TBrowserStartCmd = record
    Command    : string[64];
    Parameters : string [255];
    XTerm      : Boolean; // Start browser in an XTerm
  end;

const
  // A reasonably comprehensive list of browsers to try.  I haven't tested
  // most of the lesser known ones.
  BrowserList : array [1..MaxBrowsers] of TBrowserStartCmd =
    ((Command : 'mozilla';            Parameters : '<site>'; Xterm : False),
     (Command : 'netscape';           Parameters : '<site>'; Xterm : False),
     (Command : 'konquerer';          Parameters : '<site>'; Xterm : False),
     (Command : 'gnome-help-browser'; Parameters : '<site>'; Xterm : False),
     (Command : 'mosaic';             Parameters : '<site>'; Xterm : False),
     (Command : 'mmosaic';            Parameters : '<site>'; Xterm : False),
     (Command : 'opera';              Parameters : '<site>'; Xterm : False),
     (Command : 'arena';              Parameters : '<site>'; Xterm : False),
     (Command : 'amaya';              Parameters : '<site>'; Xterm : False),
     (Command : 'lynx';               Parameters : '<site>'; Xterm : True),
     (Command : 'kdehelp';            Parameters : '<site>'; Xterm : False), // Requires kfm running
     (Command : 'qtmozilla';          Parameters : '<site>'; Xterm : False),
     (Command : 'cineast';            Parameters : '<site>'; Xterm : False),
     (Command : 'qweb';               Parameters : '<site>'; Xterm : False),
     (Command : 'plume';              Parameters : '<site>'; Xterm : False),
     (Command : 'surfit';             Parameters : '<site>'; Xterm : False), // Now known as plume
     (Command : 'armadillo';          Parameters : '<site>'; Xterm : False),
     (Command : 'w3m';                Parameters : '<site>'; Xterm : True),
     (Command : 'grail';              Parameters : '<site>'; Xterm : False),
     (Command : 'mmm';                Parameters : '<site>'; Xterm : False),
     (Command : 'mneumonic';          Parameters : '<site>'; Xterm : False),
     (Command : 'gzilla';             Parameters : '<site>'; Xterm : False), // Now known as Armadillo
     (Command : 'chimera';            Parameters : '<site>'; Xterm : False), // Chimera 2
     (Command : 'express';            Parameters : '<site>'; Xterm : False), // Verge Express
     (Command : 'jozilla';            Parameters : '<site>'; Xterm : False)); // JoZilla

  NewsreaderList : array [1..MaxNewsreaders] of TBrowserStartCmd =
    ((Command : 'mozilla';  Parameters : '-news <site>'; XTerm : False),
     (Command : 'netscape'; Parameters : '-news <site>'; XTerm : False),
     (Command : 'pan';      Parameters : '<site>';       XTerm : False),
     (Command : 'kexpress'; Parameters : '<site>';       XTerm : False),
     (Command : 'gnews';    Parameters : '<site>';       XTerm : False),
     (Command : 'knews';    Parameters : '<site>';       XTerm : False),
     (Command : 'gnus';     Parameters : '<site>';       XTerm : False),
     (Command : 'knode';    Parameters : '<site>';       XTerm : False),
     (Command : 'krn';      Parameters : '<site>';       XTerm : False),
     (Command : 'grin';     Parameters : '<site>';       XTerm : False),
     (Command : 'newsflex'; Parameters : '<site>';       XTerm : False),
     (Command : 'xvnews';   Parameters : '<site>';       XTerm : False),
     (Command : 'xrn';      Parameters : '<site>';       XTerm : False),
     (Command : 'tin';      Parameters : '<site>';       Xterm : True),
     (Command : 'slrn';     Parameters : '<site>';       XTerm : True),
     (Command : 'inn';      Parameters : '<site>';       Xterm : True),
     (Command : 'trn';      Parameters : '<site>';       XTerm : True),
     (Command : 'rn';       Parameters : '<site>';       XTerm : True));

type
  EAxAboutExecError = class (Exception);
  
type
  TAxAboutForm = class(TForm)
    Panel1: TPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Button1: TButton;
    Label15: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label5MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label5MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label15Click(Sender: TObject);
    procedure Label16Click(Sender: TObject);
    procedure StartBrowser (Website : String);
    procedure StartNewsreader (Website : string);
    procedure GetCurrentPath (PathList : TList);
    procedure FreePaths (PathList : TList);
    function IsBrowserPresent (PathList : TList;
                               Browser : string) : Boolean;
    procedure CallBrowser (Browser    : string;
                           Parameters : string;
                           Website    : string;
                           XTerm      : Boolean);
  end;


var
  AxAboutForm: TAxAboutForm;

implementation

{$R *.xfm}

procedure TAxAboutForm.GetCurrentPath (PathList : TList);
var
  WorkPath : PChar;
  StartPos : PChar;
  CurrentPath : PChar;
  State : (Scanning, GotColon);
begin
  WorkPath := getenv ('PATH');

  PathList.Clear;

  StartPos := WorkPath;
  State := Scanning;
  while (WorkPath^ <> #0) do begin
    case State of
      Scanning :
        begin
          if (WorkPath^ = ':') then begin
            State := GotColon;
            if (WorkPath <> StartPos) then begin
              CurrentPath := StrAlloc(WorkPath - StartPos + 1);
              StrLCopy(CurrentPath, StartPos, WorkPath-StartPos);
              PathList.Add (CurrentPath);
              StrDispose(CurrentPath);
            end;
          end;
        end;
      GotColon :
        begin
          if (WorkPath^ <> ':') then begin
            StartPos := WorkPath;
            State := Scanning;
          end;
        end;
    end;{case}
    inc(WorkPath);
  end;
  if (State = Scanning) and (WorkPath <> StartPos) then begin
    CurrentPath := StrAlloc(WorkPath - StartPos + 1);
    StrLCopy(CurrentPath, StartPos, WorkPath-StartPos);
    PathList.Add (CurrentPath);
    StrDispose(CurrentPath);
  end;
end;

procedure TAxAboutForm.FreePaths (PathList : TList);
var
  i : Integer;
begin
  for i := 0 to PathList.Count - 1 do begin
    if Assigned (PathList[i]) then
      StrDispose (PathList[i]);
  end;
end;

function TAxAboutForm.IsBrowserPresent (PathList : TList;
                                        Browser : string) : Boolean;
var
  i : integer;
begin
  Result := False;
  for i := 0 to PathList.Count - 1 do begin
    if FileExists (PChar (PathList[i]) + '/' + Browser) then begin
      Result := True;
      exit;
    end;
  end;
end;

procedure TAxAboutForm.CallBrowser (Browser    : string;
                                    Parameters : string;
                                    Website    : string;
                                    XTerm      : Boolean);
begin
  if Pos ('<site>', Parameters) > 0 then begin
    Parameters := Copy (Parameters, 1, Pos ('<site>', Parameters) - 1) +
                        Website +
                        Copy (Parameters, Pos ('<site>', Parameters) + 6, 255);
  end else
    Parameters := Parameters + ' ' + Website;
  if XTerm then begin
    Parameters := '-e ' + Browser + ' ' + Parameters;
    Browser := 'xterm';
  end;
  AxExecAndWait(PChar(Browser), PChar(Parameters), 0, False);
end;

procedure TAxAboutForm.StartBrowser (Website : string);

var
  PathList : TList;     
  i : integer;
       
begin
  Cursor := crHourglass;
  try
    PathList := TList.Create;
    try
      GetCurrentPath (PathList);
      try
        for i := 1 to MaxBrowsers do begin
          if IsBrowserPresent (PathList, BrowserList[i].Command) then begin
            CallBrowser (BrowserList[i].Command, BrowserList[i].Parameters,
                         Website, BrowserList[i].XTerm);
            exit;
          end;
        end;
        ShowMessage ('Unable to start web browser. Make sure you have it properly set-up on your system.');
      finally
        FreePaths (PathList);
      end;
    finally
      PathList.Free;
    end;
  finally
    Cursor := crDefault;
  end;
end;

procedure TAxAboutForm.StartNewsreader (Website : string);

var
  PathList : TList;     
  i : integer;
       
begin
  Cursor := crHourglass;
  try
    PathList := TList.Create;
    try
      GetCurrentPath (PathList);
      try
        for i := 1 to MaxBrowsers do begin
          if IsBrowserPresent (PathList, NewsreaderList[i].Command) then begin
            CallBrowser (NewsreaderList[i].Command, NewsreaderList[i].Parameters,
                         Website, NewsreaderList[i].XTerm);
            exit;
          end;
        end;
        ShowMessage ('Unable to start web browser. Make sure you have it properly set-up on your system.');
      finally
        FreePaths (PathList);
      end;
    finally
      PathList.Free;
    end;
  finally
    Cursor := crDefault;
  end;
end;

procedure TAxAboutForm.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TAxAboutForm.FormCreate(Sender: TObject);
begin
  Label2.Caption := ApxVersionStr;
end;

procedure TAxAboutForm.Label5Click(Sender: TObject);
begin
  StartBrowser ('http://sourceforge.net/projects/tpaproclx');
end;

procedure TAxAboutForm.Label6Click(Sender: TObject);
begin
  StartBrowser ('http://sourceforge.net/forum?group_id=71022');
end;

procedure TAxAboutForm.Label5MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  (Sender as TLabel).Left := (Sender as TLabel).Left + 1;
  (Sender as TLabel).Top := (Sender as TLabel).Top + 1;
end;

procedure TAxAboutForm.Label5MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  (Sender as TLabel).Left := (Sender as TLabel).Left - 1;
  (Sender as TLabel).Top := (Sender as TLabel).Top - 1;
end;

procedure TAxAboutForm.Label15Click(Sender: TObject);
begin
  StartBrowser ('http://www.aprozilla.com');
end;

procedure TAxAboutForm.Label16Click(Sender: TObject);
begin
  StartBrowser ('http://www.turbopower.com/tpslive/');
end;

end.
