(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxDesign.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F+}

{$R AxDesign.dcr}

unit AxDesign;

interface

uses
  Classes,
  DesignIntf,
  DesignEditors,
  AxAbout;

{ Constant declarations for IDE palette tab names }

const
  APROXTabName    = 'APRO';

type

  TApxBaudProperty = class(TIntegerProperty)
  public
    procedure Edit; override;
    function GetAttributes : TPropertyAttributes; override;
    function GetEditLimit : Integer; override;
    procedure GetValues(Proc : TGetStrProc); override;
  end;

  TApxDataBitsProperty = class(TEnumProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
  end;

  TApxDeviceProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc); override;
  end;

  TApxPacketEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TApxPacketStringProperty = class(TStringProperty)
  public
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

  TApxParityProperty = class(TEnumProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
  end;

  TApxSWFlowControlProperty = class(TEnumProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
  end;

  TApxVersionProperty = class(TStringProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses
  { RTL/CLX Units }
  QForms, SysUtils,

  { Standard Units }
  AxMisc, AxPort, AxModem, AxProtcl, AxPStat, AxStatLt, AxPacket, AxPackEd,
  AxPBook, AxScript, AxTerm;

{ TApxBaudProperty }

procedure TApxBaudProperty.Edit;
begin
  { Intentionally empty }
end;

function TApxBaudProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paMultiSelect, paValueList, paRevertable];
end;

function TApxBaudProperty.GetEditLimit : Integer;
begin
  Result := 6;
end;

procedure TApxBaudProperty.GetValues(Proc : TGetStrProc);
var
  Cb : TAxCommonBauds;
begin
  for Cb := Low(TAxCommonBauds) to High(TAxCommonBauds) do
    Proc(CommonBauds[Cb]);
end;

{ TApxDataBitsProperty }

function TApxDataBitsProperty.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes - [paSortList];
end;

{ TApxDeviceProperty }

procedure TApxDeviceProperty.Edit;
begin
  { Intentionally empty }
end;

function TApxDeviceProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paMultiSelect, paValueList, paRevertable];
end;

procedure TApxDeviceProperty.GetValues(Proc : TGetStrProc);
var
  Devs : TStringList;
  I : Integer;
begin
  Devs := TStringList.Create;
  try
    TApxCustomComPort(GetComponent(0)).GetDeviceLayerList(Devs);
    for I := 0 to Devs.Count-1 do
      Proc(Devs[I]);
  finally
    Devs.Free;
  end;
end;

{ TApxPacketEditor }

procedure TApxPacketEditor.ExecuteVerb(Index : Integer);
begin
  if EditPacket(Component as TApxDataPacket, Component.Name) then
    Designer.Modified;
end;

function TApxPacketEditor.GetVerb(Index : Integer) : string;
begin
  Result := 'Edit properties...';
end;

function TApxPacketEditor.GetVerbCount : Integer;
begin
  Result := 1;
end;

{ TApxPacketStringProperty }

function TApxPacketStringProperty.GetValue: string;
begin
  Result := StrToCtrlStr(inherited GetValue);
end;

procedure TApxPacketStringProperty.SetValue(const Value: string);
begin
  inherited SetValue(CtrlStrToStr(Value));
end;

{ TApxParityProperty }

function TApxParityProperty.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes - [paSortList];
end;

{ TApxSWFlowControlProperty }

function TApxSWFlowControlProperty.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes - [paSortList];
end;

{ TApdVersionProperty }

function TApxVersionProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paDialog, paReadOnly];
end;

procedure TApxVersionProperty.Edit;
begin
  with TAxAboutForm.Create(Application) do begin
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure Register;
begin

  { Register property editors }
  RegisterPropertyEditor(TypeInfo(LongInt), TApxCustomComPort, 'Baud',
    TApxBaudProperty);
  RegisterPropertyEditor(TypeInfo(TAxDatabits), TApxCustomComPort, 'DataBits',
    TApxDataBitsProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxCustomComPort, 'DeviceLayer',
    TApxDeviceProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxDataPacket, 'StartString',
    TApxPacketStringProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxDataPacket, 'EndString',
    TApxPacketStringProperty);
  RegisterPropertyEditor(TypeInfo(TAxParity), TApxCustomComPort, 'Parity',
    TApxParityProperty);
  RegisterPropertyEditor(TypeInfo(TAxSWFlowControl), TApxCustomComPort,
    'SWFlowControl', TApxSWFlowControlProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxBaseComponent,
    'Version', TApxVersionProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxBaseHandleComponent,
    'Version', TApxVersionProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxBaseCustomControl,
    'Version', TApxVersionProperty);
  RegisterPropertyEditor(TypeInfo(string), TApxCustomStatusLight,
    'Version', TApxVersionProperty);

  RegisterComponentEditor(TApxDataPacket, TApxPacketEditor);

  { Register standard components }
  RegisterComponents(APROXTabName,
    [TApxComPort, TApxDataPacket, TApxModem, TApxModemStatus, TApxPhoneBook,
     TApxSLController, TApxStatusLight, TApxProtocol, TApxProtocolLog,
     TApxProtocolStatus, TApxTerminal, TApxTTYEmulator, TApxVT100Emulator,
     TApxScript]);

end;

end.
