(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxExcept.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F-,V-,P-,T-,B-}

unit AxExcept;
  {-Apro exceptions}

interface

uses
  SysUtils,
  Classes,
  AxString,
  AxMisc;

type
  {General Apro exception class}
  EAPDException = class(Exception)
  private
    FErrorCode : Integer;

  public
    constructor Create(const EC : Integer; PassThru : Boolean);
    constructor CreateUnknown(const Msg : String; Dummy : Byte);
    constructor CreateFormatted (const EC : Integer;
      const Arguments : array of const; PassThru  : Boolean);

    class function MapCodeToStringID(const Code : Integer) : Word;
      {-Return a string table index for Code}

    property ErrorCode : Integer
      read FErrorCode write FErrorCode;
  end;

  { Apro exception groups }
  EGeneral      = class(EAPDException);
  EOpenComm     = class(EAPDException);
  ESerialIO     = class(EAPDException);
  EModem        = class(EAPDException);
  ETrigger      = class(EAPDException);
  EPacket       = class(EAPDException);
  EProtocol     = class(EAPDException);
  EINI          = class(EAPDException);
  EApxTerminal  = class(EAPDException);
  EPortError    = class(EAPDException);
  EPagerError   = class(EAPDException);

  {Specific general exceptions}
  EPortNotAssigned      = class(EGeneral);
  EInternal             = class(EGeneral);

  {Specific OpenComm exceptions}
  ECommNotOpen          = class(EOpenComm);
  ENoHandles            = class(EOpenComm);
  ENoPortSelected       = class(EOpenComm);

  {Specific serial I/O exceptions}
  ENullApi              = class(ESerialIO);

  {Specific modem exceptions}
  EDeviceNotSelected    = class(EModem);
  EModemRejectedCommand = class(EModem);
  EModemBusy            = class(EModem);
  EModemNotResponding   = class(EModem);
  EModemDetectedBusy    = class(EModem);
  ENoDialtone           = class(EModem);
  ENoCarrier            = class(EModem);
  ENoAnswer             = class(EModem);

  {Specific trigger exceptions}
  EBadTriggerHandle     = class(ETrigger);

  {Specific packet exceptions}
  EInvalidProperty      = class(EPacket);
  EStringSizeError      = class(EPacket);

  {Specific protocol exceptions}
  ETimeout              = class(EProtocol);

  {Terminal exceptions}
  EApxTerminalClass             = class of EApxTerminal;

  function XlatException(const E : Exception) : Integer;
    {-Translate an exception into an error code}

  function AproLoadStr(const ErrorCode : SmallInt) : ShortString;

  function ErrorMsg(const ErrorCode : SmallInt) : ShortString;

implementation

function AproLoadStr(const ErrorCode : SmallInt) : ShortString;
{-Return an error message for ErrorCode}
begin
  Result := SysErrorMessage(Abs(ErrorCode));
end;

{Alias for function above}
function ErrorMsg(const ErrorCode : SmallInt) : ShortString;
  {-Return an error message for ErrorCode}
begin
  Result := MessageNumberToString(Abs(ErrorCode));
end;

constructor EAPDException.Create(const EC : Integer; PassThru : Boolean);
begin
  FErrorCode := EC;
  inherited Create(MessageNumberToString(Abs(EC)));
end;

constructor EAPDException.CreateUnknown(const Msg : String; Dummy : Byte);
begin
  ErrorCode := 0;
  inherited Create(Msg);
end;

constructor EAPDException.CreateFormatted (const EC : Integer;
  const Arguments : array of const; PassThru  : Boolean);
begin
  FErrorCode := EC;
  inherited Create ( Format ( MessageNumberToString (Abs (EC)), Arguments));
end;

class function EAPDException.MapCodeToStringID(const Code : Integer) : Word;
begin
  Result := Abs(Code);
end;

function XlatException(const E : Exception) : Integer;
  {-Translate an exception into an error code}
begin
  if (E is EApdException) then
    Result := EApdException(E).ErrorCode
  else if (E is EInOutError) then
    Result := -EInOutError(E).ErrorCode
  else if (E is EOutOfMemory) then
    Result := ecOutOfMemory
  else
    Result := -9999;
end;

end.
