(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxMdmDlg.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

unit AxMdmDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  AxMisc, AxModem, QStdCtrls, QButtons, QExtCtrls, QImgList;

type
  TApxModemStatusDialog = class(TForm)
    gbxStatus: TGroupBox;
    btnCancel: TButton;
    btnDetail: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    lblStatus: TLabel;
    lblUsingDevice: TLabel;
    lblUsingPort: TLabel;
    lblElapsedTime: TLabel;
    gbxDetail: TGroupBox;
    memDetail: TMemo;
    ImageList1: TImageList;
    procedure btnDetailClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    FModem: TApxCustomModem;
    { used for alt-click moves }
    InMove : Boolean;
    OldX : Integer;
    OldY : Integer;
    procedure SetModem(const NewModem : TApxCustomModem);
  public
    { Public declarations }
    property Modem : TApxCustomModem
      read FModem write SetModem;
    procedure UpdateDisplay(
      const StatusStr, TimeStr, DetailStr : string;
      Action : TApxModemStatusAction);

  end;

var
  ApxModemStatusDialog: TApxModemStatusDialog;

implementation

{$R *.xfm}

procedure TApxModemStatusDialog.btnDetailClick(Sender: TObject);
begin
  if btnDetail.Tag = 0 then begin
    { show the whole dialog (include detail) }
    btnDetail.Tag := 1;
    gbxDetail.Visible := True;
    ClientHeight := gbxDetail.Top + gbxDetail.Height + 8 + btnCancel.Height;
  end else begin
    { show the small dialog (no detail) }
    btnDetail.Tag := 0;
    gbxDetail.Visible := False;
    ClientHeight := gbxStatus.Top + gbxStatus.Height + 8 + btnCancel.Height;
  end;
  btnDetail.Glyph := nil;
  ImageList1.GetBitmap(btnDetail.Tag, btnDetail.Glyph);
end;

procedure TApxModemStatusDialog.UpdateDisplay(
  const StatusStr, TimeStr, DetailStr : string;
  Action : TApxModemStatusAction);
  { this method is called periodically by the TApxModem component }
  { when the OnModemStatus, OnModemLog and a few other events are }
  { generated, or at other various places. }
begin
  case Action of
    msaStart : begin         { first time status display (clears everything) }
                 memDetail.Lines.Clear;
                 Show;
               end;
    msaClose : begin         { last time, cleans up }
                 Close;
               end;
    msaUpdate : begin        { normal updating }
                  lblStatus.Caption := StatusStr;
                  lblElapsedTime.Caption := 'Elapsed time: ' + TimeStr;
                  if DetailStr <> '' then
                    memDetail.Lines.Add(DetailStr);
                end;
    msaDetailReplace : begin { replaces last line of details }
                         lblStatus.Caption := StatusStr;
                         lblElapsedTime.Caption := 'Elapsed time: ' + TimeStr;
                         if DetailStr <> '' then
                           if memDetail.Lines.Count = 0 then
                             memDetail.Lines.Add(DetailStr)
                           else
                             memDetail.Lines[pred(memDetail.Lines.Count)] := DetailStr;
                      end;
    msaClear : begin         { clears all details and adds DetailStr }
                 memDetail.Lines.Clear;
                 if DetailStr <> '' then
                   memDetail.Lines.Add(DetailStr);
               end;
  end;
end;

procedure TApxModemStatusDialog.FormCreate(Sender: TObject);
begin
  { initialize the captions }
  btnDetail.Tag := 1;
  btnDetail.Click;
end;

procedure TApxModemStatusDialog.btnCancelClick(Sender: TObject);
begin
  AxPostmessage(FModem.Handle, apx_CommandProcessed, nil, ApxMessage_CancelCall, 0);
end;

procedure TApxModemStatusDialog.FormMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  P : TPoint;
begin
  if (InMove) then begin
    GetCursorPos (P);
    Left := P.X - OldX;
    Top := P.Y - OldY;
  end;
end;

procedure TApxModemStatusDialog.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  P : TPoint;
begin
  BringToFront;
  if (Button = mbLeft) and (ssAlt in Shift)then begin
    GetCursorPos (P);
    OldX := P.X - Left;
    OldY := P.Y - Top;
    InMove := True;
  end;
end;

procedure TApxModemStatusDialog.FormMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if InMove then
    InMove := False;
end;

procedure TApxModemStatusDialog.FormPaint(Sender: TObject);
begin
  { since we have to have a BorderStyle of fbsNone or fbsSizeable we }
  { have to draw our border explicitly }
  DrawEdge(Canvas, Rect(0, 0, Width, Height), esRaised, esRaised, ebRect);
end;

procedure TApxModemStatusDialog.SetModem(const NewModem : TApxCustomModem);
begin
  FModem := NewModem;
  lblUsingDevice.Caption := FModem.SelectedDevice.Name;
  lblUsingPort.Caption := FModem.ComPort.DeviceName;
end;

end.
