(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                   AxMisc.pas 1.02                     *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$V-,I-,X+}

unit AxMisc;
  {-Unit for miscellaneous routines}

interface

uses
  Libc,
  Qt,
  Types,
  QTypes,
  SysUtils,
  SyncObjs,
  Classes,
  QControls,
  QForms,
  AxSystem;

const
{$IFDEF TRIALRUN}
  ApxVersionStr = 'v1.00 Trial';
{$ELSE}
  ApxVersionStr = 'v1.00';
{$ENDIF}
  fsPathName  = 255;
  fsDirectory = 255;
  fsFileName  = 255;
  fsExtension = 255;
  fsName      = 255;

  { shareable reading file mode }
  ShareFileRead = $40;

const
  { Event codes: (inbound) }
  eNull        = 0;
  eStartDoc    = 1;
  eEndDoc      = 2;

  { Event codes: (outbound) }
  eSetFileName = 3;

  {$IFDEF Linux}
  AxLineTerm = string(#10);
  {$ENDIF}

  {$IFDEF MSWindows}
  AxLineTerm = #13#10;
  {$ENDIF}

type
  { Define commonly used baudrates for use in property editor }
  { Tied to CommonBauds below, don't change one without the other }
  TAxCommonBauds = (cb300, cb600, cb1200, cb2400, cb4800, cb9600, cb19200,
    cb38400, cb57600, cb115200, cb230400, cb460800);

const
  CommonBauds : array[cb300..cb460800] of string[7] = ('300', '600', '1200',
    '2400', '4800', '9600', '19200', '38400', '57600', '115200', '230400',
    '460800');

type
  TApxCharArray = array[0..Pred(High(LongInt))] of AnsiChar;

  TPipeEvent = record
    Event : Byte;
    Data : ShortString;
  end;

type
  CharSet = set of AnsiChar;

  { Standard event timer record structure used by all timing routines }
  EventTimer = record
    StartMS : DWORD;    { mSec count when timer was initialized }
    ExpireMS : DWORD;   { mSec count when timer will expire }
  end;

  { Message record for custom Qt events }
  PAxMessage = ^TAxMessage;
  TAxMessage = packed record
    Msg : Cardinal;
    {$IFDEF Linux}
    Event : TEvent;
    {$ENDIF}
    case Integer of
      0 : (
        WParam : Longint;
        LParam : Longint;
        Result : Longint);
      1 : (
        WParamLo : Word;
        WParamHi : Word;
        LParamLo : Word;
        LParamHi : Word;
        ResultLo : Word;
        ResultHi : Word);
  end;

const
  { Compile-time configurations }
  MaxComHandles      = 50;       { Max comm ports open at once }
  MaxDebugLog        = 16000000; { Max size of debug log buffer }
  MaxMessageLen      = 80;       { All error and status strings less than 80 }

  { Next file method }
  nfNone               = 0;  { No next file method specified }
  nfMask               = 1;  { Use built-in next file mask method }
  nfList               = 2;  { Use built-in next file list method }

  { Action to take if incoming file exists }
  wfcWriteNone         = 0;  { No option set yet }
  wfcWriteFail         = 1;  { Fail the open attempt }
  wfcWriteRename       = 2;  { Rename the incoming file }
  wfcWriteAnyway       = 3;  { Overwrite the existing file }
  wfcWriteResume       = 4;  { Resume an interrupted receive }

  { Ascii CR/LF translation options }
  atNone               = 0;  { No CR/LF translations }
  atStrip              = 1;  { Strip CRs or LFs }
  atAddCRBefore        = 2;  { Add CR before each LF }
  atAddLFAfter         = 3;  { Add LF after each CR }
  atEOFMarker          : AnsiChar = ^Z; { Add constant for standard EOF }

  { Protocol status start/end flags }
  apFirstCall          = $01; { Indicates the first call to status }
  apLastCall           = $02; { Indicates the last call to status }

  { For specifying log file calls }
  lfReceiveStart       = 0;  { Receive starting }
  lfReceiveOk          = 1;  { File received ok }
  lfReceiveFail        = 2;  { File receive failed }
  lfReceiveSkip        = 3;  { File was rejected by receiver }
  lfTransmitStart      = 4;  { Transmit starting }
  lfTransmitOk         = 5;  { File was transmitted ok }
  lfTransmitFail       = 6;  { File transmit failed }
  lfTransmitSkip       = 7;  { File was skipped, rejected by receiver }

type
  { Convenient types used by protocols }
  TNameCharArray = array[0..fsFileName ] of AnsiChar;
  TExtCharArray  = array[0..fsExtension] of AnsiChar;
  TPathCharArray = array[0..fsPathName ] of AnsiChar;
  TDirCharArray  = array[0..fsDirectory] of AnsiChar;
  TChar20Array   = array[0..20] of AnsiChar;
  TCharArray = array[0..255] of AnsiChar;

  { For generic buffer typecasts }
  PByteBuffer = ^TByteBuffer;
  TByteBuffer = array[1..65535] of Byte;

  { NotifyProc type, same as a window procedure }
  TApxNotifyProc = procedure(Msg, wParam : Cardinal; lParam : Longint);
  TApxNotifyEvent = procedure(Msg, wParam : Cardinal; lParam : Longint) of object;

const
  { MSRShadow register from COMM.DRV }
  MsrShadowOfs = 35;           { Offset of MSRShadow from EventWord }

const
  { Modem status bit masks }
  DeltaCTSMask = $01;   { CTS changed since last read }
  DeltaDSRMask = $02;   { DSR changed since last read }
  DeltaRIMask  = $04;   { RI changed since last read }
  DeltaDCDMask = $08;   { DCD changed since last read }
  CTSMask      = $10;   { Clear to send }
  DSRMask      = $20;   { Data set ready }
  RIMask       = $40;   { Ring indicator }
  DCDMask      = $80;   { Data carrier detect }

{$IFDEF Linux}
const
  { Event bit masks }
  EV_RXCHAR   = $01;    { Any Character received }
  EV_RXFLAG   = $02;    { Received certain character }
  EV_TXEMPTY  = $04;    { Transmitt Queue Empty }
  EV_CTS      = $08;    { CTS changed state }
  EV_DSR      = $10;    { DSR changed state }
  EV_RLSD     = $20;    { RLSD changed state }
  EV_BREAK    = $40;    { BREAK received }
  EV_ERR      = $80;    { Line status error occurred }
  EV_RING     = $100;   { Ring signal detected }
  EV_PERR     = $200;   { Printer error occured }
  EV_RX80FULL = $400;   { Receive buffer is 80 percent full }
  EV_EVENT1   = $800;   { Provider specific event 1 }
  EV_EVENT2   = $1000;  { Provider specific event 2 }
  EV_RINGTE   = $2000;  { Ring trailing edge indicator }

const
  { Error Flags }
  CE_RXOVER   = 1;      { Receive Queue overflow }
  CE_OVERRUN  = 2;      { Receive Overrun Error }
  CE_RXPARITY = 4;      { Receive Parity Error }
  CE_FRAME    = 8;      { Receive Framing error }
  CE_BREAK    = $10;    { Break Detected }
  CE_TXFULL   = $100;   { TX Queue is full }
  CE_PTO      = $200;   { LPTx Timeout }
  CE_IOE      = $400;   { LPTx I/O Error }
  CE_DNS      = $800;   { LPTx Device not selected }
  CE_OOP      = $1000;  { LPTx Out-Of-Paper }
  CE_MODE     = $8000;  { Requested mode unsupported }
{$ENDIF}

{$IFDEF Linux}
const
  QEventType_AxSendDispatchMessage = QEventType(Integer(QEventType_User) + $760);
  QEventType_AxPostDispatchMessage = QEventType(Integer(QEventType_User) + $761);

{$ENDIF}

const
  { Message base }
  apx_First              = $7E00;         { Sets base for all APX messages }

const
  { Custom message types }
  apx_TriggerAvail       = apx_First+1;   { Trigger for any data avail }
  apx_TriggerData        = apx_First+2;   { Trigger data }
  apx_TriggerTimer       = apx_First+3;   { Trigger timer }
  apx_TriggerStatus      = apx_First+4;   { Status change (modem, line, buffer) }
  apx_FromYmodem         = apx_First+5;   { Tells Xmodem it was called from Ymodem }
  apx_PortOpen           = apx_First+8;   { Apro, tell users port open }
  apx_PortClose          = apx_First+9;   { Apro, tell users port closed }
  apx_ClosePending       = apx_First+10;  { Apro, tell ourself that the port was closed }

const
  { Protocol message types }
  apx_ProtocolCancel      = apx_First+20;  { To protocol - chk for protcl abort }
  apx_ProtocolStatus      = apx_First+21;  { From protocol - update status display }
  apx_ProtocolLog         = apx_First+22;  { From protocol - LogFile message }
  apx_ProtocolNextFile    = apx_First+23;  { From protocol - return next file }
  apx_ProtocolAcceptFile  = apx_First+24;  { From protocol - accept file }
  apx_ProtocolFinish      = apx_First+25;  { From protocol - protocol is finished }
  apx_ProtocolResume      = apx_First+26;  { From protocol - resume request }
  apx_ProtocolError       = apx_First+27;  { From protocol - error during protocol }
  apx_ProtocolOpenStream  = apx_First+28;  { From protocol - stream open }
  apx_ProtocolCloseStream = apx_First+29;  { From protocol - stream close }

const
  { Modem message types }
  ApxMessage_AutoAnswer = apx_First+40;
  ApxMessage_CancelCall = apx_First+41;
  ApxMessage_StartDial  = apx_First+42;

  apx_CommandProcessed  = apx_First+43;   { From modem - finished command }

const
  { Terminal message types }
  apx_TermStart          = apx_First+60;  { To terminal - start }
  apx_TermStop           = apx_First+61;  { To terminal - stop }
  apx_TermSetCom         = apx_First+62;  { To terminal - set com handle }
  apx_TermRelCom         = apx_First+63;  { To terminal - release com handle }
  apx_TermSetEmuPtr      = apx_First+64;  { To terminal - set emulator pointer }
  apx_TermSetEmuProc     = apx_First+65;  { To terminal - set emulator proc }
  apx_TermClear          = apx_First+66;  { To terminal - clear window }
  apx_TermBuffer         = apx_First+67;  { To terminal - alloc new buffers }
  apx_TermColors         = apx_First+68;  { To terminal - set new colors }
  apx_TermToggleScroll   = apx_First+69;  { To terminal - toggle scrollback }
  apx_TermCapture        = apx_First+70;  { To terminal - set capture mode }
  apx_TermStuff          = apx_First+71;  { To terminal - stuff data }
  apx_TermPaint          = apx_First+72;  { To terminal - update screen }
  apx_TermSetWndProc     = apx_First+73;  { To terminal - set window proc }
  apx_TermColorsH        = apx_First+74;  { To terminal - set highlight colors }
  apx_TermSave           = apx_First+75;  { To terminal - save/restore }
  apx_TermColorMap       = apx_First+76;  { To terminal - get/set color map }
  apx_TermForceSize      = apx_First+77;  { To terminal - force new size }
  apx_TermFontSize       = apx_First+78;  { To terminal - get font size }

const
  apx_TermStatus         = apx_First+80;  { From terminal - show status }
  apx_TermBPlusStart     = apx_First+81;  { From terminal - B+ is starting }
  apx_TermError          = apx_First+82;  { From terminal - error }
  apx_CursorPosReport    = apx_First+83;  { From terminal - Cursor Pos Report }

const
  apx_TermBlinkTimeChange      = apx_First+130; { set new blink time }
  apx_TermPersistentMarkChange = apx_First+131; { set persistent blocks }
  apx_TermSetKeyEmuPtr         = apx_First+132; { set Key Emulator pointer }
  apx_TermSetKeyEmuProc        = apx_First+133; { set Key Emulator proc }
  apx_TermSetHalfDuplex        = apx_First+134; { set Duplex mode }
  apx_TermGetBuffPtr           = apx_First+135; { get a pointer to term buffer }
  apx_TermGetClientLine        = apx_First+136; { get the first client line in buffer }

const
  { Below are all error codes used by APRO -- resource IDs are Abs(ErrorCode) }
  { The corresponding strings can be found in APW.STR.  If you are adding     }
  { strings, it's best to go there first to 'stake a claim' on an appropriate }
  { range of IDs -- since constants for some status strings are found in the  }
  { applicable component's unit instead of here...                            }

  { No error }
  ecOK                     = 0;        { Okay }

const
  { egDOS }
  ecFileNotFound           = -2;       { File not found }
  ecPathNotFound           = -2;       { Path not found }
  ecTooManyFiles           = -4;       { Too many open files }
  ecInvalidHandle          = -6;       { Invalid file handle }
  ecOutOfMemory            = -8;       { Insufficient memory }
  ecAccessDenied           = -13;       { File access denied }
  ecInvalidDrive           = -15;      { Invalid drive }
  ecNoMoreFiles            = -18;      { No more files }
  ecDiskRead               = -100;     { Attempt to read beyond end of file }
  ecDiskFull               = -101;     { Disk is full }
  ecNotAssigned            = -102;     { File not Assign-ed }
  ecNotOpen                = -103;     { File not open }
  ecNotOpenInput           = -104;     { File not open for input }
  ecNotOpenOutput          = -105;     { File not open for output }
  ecWriteProtected         = -150;     { Disk is write-protected }
  ecUnknownUnit            = -151;     { Unknown disk unit }
  ecDriveNotReady          = -152;     { Drive is not ready }
  ecUnknownCommand         = -153;     { Unknown command }
  ecCrcError               = -154;     { Data error }
  ecBadStructLen           = -155;     { Bad request structure length }
  ecSeekError              = -156;     { Seek error }
  ecUnknownMedia           = -157;     { Unknown media type }
  ecSectorNotFound         = -158;     { Disk sector not found }
  ecOutOfPaper             = -159;     { Printer is out of paper }
  ecDeviceWrite            = -160;     { Device write error }
  ecDeviceRead             = -161;     { Device read error }
  ecHardwareFailure        = -162;     { General failure }

const
  { egGeneral }
  ecBadHandle              = -1001;    { Bad handle passed to com function }
  ecBadArgument            = -1002;    { Bad argument passed to function }
  ecGotQuitMsg             = -1003;    { Yielding routine got WM_QUIT message }
  ecBufferTooBig           = -1004;    { Terminal buffer size too big }
  ecPortNotAssigned        = -1005;    { ComPort component not assigned }
  ecInternal               = -1006;    { Internal INIDB errors }
  ecModemNotAssigned       = -1007;    { Modem component not assigned }
  ecPhonebookNotAssigned   = -1008;    { Phonebook component not assgnd }

const
  { egOpenComm }
  ecBadId                  = -2001;    { ie_BadId - bad or unsupported ID }
  ecBaudRate               = -2002;    { ie_Baudrate - unsupported baud rate }
  ecByteSize               = -2003;    { ie_Bytesize - invalid byte size }
  ecDefault                = -2004;    { ie_Default - error in default parameters }
  ecHardware               = -2005;    { ie_Hardware - hardware not present }
  ecMemory                 = -2006;    { ie_Memory - unable to allocate queues }
  ecCommNotOpen            = -2007;    { ie_NOpen - device not open }
  ecAlreadyOpen            = -2008;    { ie_Open - device already open }
  ecNoHandles              = -2009;    { No more handles, can't open port }
  ecNoTimers               = -2010;    { No timers available }
  ecNoPortSelected         = -2011;    { No port selected (attempt to open com0) }

const
  { egSerialIO }
  ecNullApi                = -3001;    { No device layer specified }
  ecNotSupported           = -3002;    { Function not supported by driver }
  ecRegisterHandlerFailed  = -3003;    { EnableCommNotification failed }
  ecPutBlockFail           = -3004;    { Failed to put entire block }
  ecGetBlockFail           = -3005;    { Failed to get entire block }
  ecOutputBufferTooSmall   = -3006;    { Output buffer too small for block }
  ecBufferIsEmpty          = -3007;    { Buffer is empty }
  ecLoggingNotEnabled      = -3009;    { Logging not enabled }
  ecBaseAddressNotSet      = -3010;    { Base addr not found, RS485 mode }

const
  { Modem }
  ecDeviceNotSelected      = -4001;    { Um, the modem wan't selected }
  ecModemRejectedCommand   = -4002;    { Bad command sent to modem }
  ecModemBusy              = -4003;    { Modem is busy elsewhere }
  ecModemNotResponding     = -4004;    { No response from modem }
  ecModemDetectedBusy      = -4005;    { Modem detected busy signal }
  ecNoDialtone             = -4006;    { No dialtone detected }
  ecNoCarrier              = -4007;    { No carrier from modem }
  ecNoAnswer               = -4008;    { Modem returned No Answer response }

  ecModemNotFound          = -4020;
  ecInvalidFile            = -4021;

const
  { Protocols }
  psOK                 = 4700;   { Protocol is ok }
  psProtocolHandshake  = 4701;   { Protocol handshaking in progress }
  psInvalidDate        = 4702;   { Bad date/time stamp received and ignored }
  psFileRejected       = 4703;   { Incoming file was rejected }
  psFileRenamed        = 4704;   { Incoming file was renamed }
  psSkipFile           = 4705;   { Incoming file was skipped }
  psFileDoesntExist    = 4706;   { Incoming file doesn't exist locally, skipped }
  psCantWriteFile      = 4707;   { Incoming file skipped due to Zmodem options }
  psTimeout            = 4708;   { Timed out waiting for something }
  psBlockCheckError    = 4709;   { Bad checksum or CRC }
  psLongPacket         = 4710;   { Block too long }
  psDuplicateBlock     = 4711;   { Duplicate block received and ignored }
  psProtocolError      = 4712;   { Error in protocol }
  psCancelRequested    = 4713;   { Cancel requested }
  psEndFile            = 4714;   { At end of file }
  psResumeBad          = 4715;   { B+ host refused resume request }
  psSequenceError      = 4716;   { Block was out of sequence }
  psAbortNoCarrier     = 4717;   { Aborting on carrier loss }

const
  { Specific to certain protocols }
  psGotCrcE            = 4718;   { Got CrcE packet (Zmodem) }
  psGotCrcG            = 4719;   { Got CrcG packet (Zmodem) }
  psGotCrcW            = 4720;   { Got CrcW packet (Zmodem) }
  psGotCrcQ            = 4721;   { Got CrcQ packet (Zmodem) }
  psTryResume          = 4722;   { B+ is trying to resume a download }
  psHostResume         = 4723;   { B+ host is resuming }
  psWaitAck            = 4724;   { Waiting for B+ ack (internal) }

const
  { Internal }
  psNoHeader           = 4725;   { Protocol is waiting for header (internal) }
  psGotHeader          = 4726;   { Protocol has header (internal) }
  psGotData            = 4727;   { Protocol has data packet (internal) }
  psNoData             = 4728;   { Protocol doesn't have data packet yet (internal) }

const
  { Trigger errors }
  ecNoMoreTriggers         = -5001;    { No more trigger slots }
  ecTriggerTooLong         = -5002;    { Data trigger too long }
  ecBadTriggerHandle       = -5003;    { Bad trigger handle }

const
  { Packet errors }
  ecStartStringEmpty       = -5501;    { Start string is empty }
  ecPacketTooSmall         = -5502;    { Packet size cannot be smaller than start string }
  ecNoEndCharCount         = -5503;    { CharCount packets must have an end-condition }
  ecEmptyEndString         = -5504;    { End string is empty }
  ecZeroSizePacket         = -5505;    { Packet size cannot be zero }
  ecPacketTooLong          = -5506;    { Packet too long }

const
  { Protocol errors }
  ecBadFileList            = -6001;    { Bad format in file list }
  ecNoSearchMask           = -6002;    { No search mask specified during transmit }
  ecNoMatchingFiles        = -6003;    { No files matched search mask }
  ecDirNotFound            = -6004;    { Directory in search mask doesn't exist }
  ecCancelRequested        = -6005;    { Cancel requested }
  ecTimeout                = -6006;    { Fatal time out }
  ecProtocolError          = -6007;    { Unrecoverable event during protocol }
  ecTooManyErrors          = -6008;    { Too many errors during protocol }
  ecSequenceError          = -6009;    { Block sequence error in Xmodem }
  ecNoFilename             = -6010;    { No filename specified in protocol receive }
  ecFileRejected           = -6011;    { File was rejected }
  ecCantWriteFile          = -6012;    { Cant write file }
  ecTableFull              = -6013;    { Kermit window table is full, fatal error }
  ecAbortNoCarrier         = -6014;    { Aborting due to carrier loss }
  ecBadProtocolFunction    = -6015;    { Function not support by protocol }

const
  { INI database }
  ecKeyTooLong             = -7001;    { Key string too long }
  ecDataTooLarge           = -7002;    { Data string too long }
  ecNoFieldsDefined        = -7003;    { No fields defined in database }
  ecIniWrite               = -7004;    { Generic INI file write error }
  ecIniRead                = -7005;    { Generic INI file read error }
  ecNoIndexKey             = -7006;    { No index defined for database }
  ecRecordExists           = -7007;    { Record already exists }
  ecRecordNotFound         = -7008;    { Record not found in database }
  ecMustHaveIdxVal         = -7009;    { Invalid index key name }
  ecDatabaseFull           = -7010;    { Maximum database records (999) reached }
  ecDatabaseEmpty          = -7011;    { No records in database }
  ecDatabaseNotPrepared    = -7012;    { iPrepareIniDatabase not called }
  ecBadFieldList           = -7013;    { Bad field list in INIDB }
  ecBadFieldForIndex       = -7014;    { Bad field for index in INIDB }

const
  { Convenient character constants (and aliases) }
  cNul = #0;
  cSoh = #1;
  cStx = #2;
  cEtx = #3;
  cEot = #4;
  cEnq = #5;
  cAck = #6;
  cBel = #7;
  cBS  = #8;
  cTab = #9;
  cLF  = #10;
  cVT  = #11;
  cFF  = #12;
  cCR  = #13;
  cSO  = #14;
  cSI  = #15;
  cDle = #16;
  cDC1 = #17;       cXon  = #17;
  cDC2 = #18;
  cDC3 = #19;       cXoff = #19;
  cDC4 = #20;
  cNak = #21;
  cSyn = #22;
  cEtb = #23;
  cCan = #24;
  cEM  = #25;
  cSub = #26;
  cEsc = #27;
  cFS  = #28;
  cGS  = #29;
  cRS  = #30;
  cUS  = #31;

type
  { Protocol status information record }
  TProtocolInfo = record
    piProtocolType     : Cardinal;
    piBlockErrors      : Cardinal;
    piTotalErrors      : Cardinal;
    piBlockSize        : Cardinal;
    piBlockNum         : Cardinal;
    piFileSize         : LongInt;
    piBytesTransferred : LongInt;
    piBytesRemaining   : LongInt;
    piInitFilePos      : LongInt;
    piElapsedXfrTime   : LongInt; 
    piFlags            : LongInt;
    piBlockCheck       : Cardinal;
    piFileName         : TPathCharArray;
    piError            : Integer;
    piStatus           : Cardinal;
  end;

const
  { Port options }
  poUseEventWord   = $04;   { Set to use the event word }

  { APRO-specific flags used in InitPort }
  ipAssertDTR      = $00000001;
  ipAssertRTS      = $00000002;
  ipAutoDTR        = $00000010;
  ipAutoRTS        = $00000020;

  { Hardware flow control options }
  hfUseDTR         = $01;   { Use DTR for receive flow control }
  hfUseRTS         = $02;   { Use RTS for receive flow control }
  hfRequireDSR     = $04;   { Require DSR before transmitting }
  hfRequireCTS     = $08;   { Require CTS before transmitting }

  { Software flow control options }
  sfTransmitFlow   = $01;   { Honor received Xon/Xoffs }
  sfReceiveFlow    = $02;   { Send Xon/Xoff as required }

  { Define bits for TDCB Flags field }
  dcb_Binary                = $0001;
  dcb_Parity                = $0002;
  dcb_OutxCTSFlow           = $0004;
  dcb_OutxDSRFlow           = $0008;
  dcb_DTRBit1               = $0010;
  dcb_DTRBit2               = $0020;
  dcb_DsrSensitivity        = $0040;
  dcb_TxContinueOnXoff      = $0080;
  dcb_OutX                  = $0100;
  dcb_InX                   = $0200;
  dcb_ErrorChar             = $0400;
  dcb_Null                  = $0800;
  dcb_RTSBit1               = $1000;
  dcb_RTSBit2               = $2000;
  dcb_AbortOnError          = $4000;

  dcb_DTR_CONTROL_ENABLE    = dcb_DTRBit1;
  dcb_DTR_CONTROL_HANDSHAKE = dcb_DTRBit2;
  dcb_RTS_CONTROL_ENABLE    = dcb_RTSBit1;
  dcb_RTS_CONTROL_HANDSHAKE = dcb_RTSBit2;
  dcb_RTS_CONTROL_TOGGLE    = (dcb_RTSBit1 + dcb_RTSBit2);

  { For reporting flow states, note: no receive hardware flow status is provided }
  fsOff      = 1;  { No flow control is in use }
  fsOn       = 2;  { Flow control is but not transmit blocked }
  fsDsrHold  = 3;  { Flow control is on and transmit blocked by low DSR }
  fsCtsHold  = 4;  { Flow control is on and transmit blocked by low CTS }
  fsDcdHold  = 5;  { Flow control is on and transmit blocked by low DCD }
  fsXOutHold = 6;  { Flow control is on and transmit blocked by Xoff }
  fsXInHold  = 7;  { Flow control is on and receive blocked by Xoff }
  fsXBothHold= 8;  { Flow control is on and both are blocked by Xoff }

const
  { Emulator commands }
  eNone               = 0;     { No command, ignore this char }
  eChar               = 1;     { No command, process the char }
  eGotoXY             = 2; {X} { Absolute goto cursor position call }
  eUp                 = 3; {X} { Cursor up }
  eDown               = 4; {X} { Cursor down }
  eRight              = 5; {X} { Cursor right }
  eLeft               = 6; {X} { Cursor left }
  eClearBelow         = 7; {R} { Clear screen below cursor }
  eClearAbove         = 8; {R} { Clear screen above cursor }
  eClearScreen        = 9; {R} { Clear entire screen }
  eClearEndofLine     = 10;{R} { Clear from cursor to end of line }
  eClearStartOfLine   = 11;{R} { Clear from cursor to the start of line }
  eClearLine          = 12;{R} { Clear entire line that cursor is on }
  eSetMode            = 13;{X} { Set video mode }
  eSetBackground      = 14;    { Set background attribute }
  eSetForeground      = 15;    { Set foreground attribute }
  eSetAttribute       = 16;{X} { Set video attribute (foreground and background) }
  eSaveCursorPos      = 17;    { Save cursor position }
  eRestoreCursorPos   = 18;    { Restore cursor position }
  eDeviceStatusReport = 19;{X} { Report device status or cursor position }
  eString             = 20;    { Pascal style string }
  eHT                 = 21;    { Horizontal Tab Character }
  eError              = 255;   { indicates a parser error }

  eAPC  { } = 30;      {Application programming command}
  eCBT  {X} = 31;      {Cursor backward tabulation}
  eCCH  { } = 32;      {Cancel character}
  eCHA  {X} = 33;      {Cursor horizontal absolute}
  eCHT  {X} = 34;      {Cursor horizontal tabulation}
  eCNL  {X} = 35;      {Cursor next line}
  eCPL  {X} = 36;      {Cursor preceding line}
  eCPR  {X} = 37;      {Cursor position report}
  eCRM  {.} = 38;      {Control representation mode}
  eCTC  {X} = 39;      {Cursor tabulation control}
  eCUB  {X} = eLeft;   {Cursor backward}
  eCUD  {X} = eDown;   {Cursor down}
  eCUF  {X} = eRight;  {Cursor forward}
  eCUP  {X} = eGotoXY; {Cursor position}
  eCUU  {X} = eUp;     {Cursor up}
  eCVT  {X} = 40;      {Cursor vertical tabulation}
  eDA   {X} = 41;      {Device attributes}
  eDAQ  { } = 42;      {Define area qualification}
  eDCH  {X} = 43;      {Delete character}
  eDCS  { } = 44;      {Device control string}
  eDL   {X} = 45;      {Delete line}
  eDMI  { } = 46;      {Disable manual input}
  eDSR  {X} = eDeviceStatusReport;{Device status report}
  eEA   { } = 47;      {Erase in area}
  eEBM  { } = 48;      {Editing boundry mode}
  eECH  {X} = 49;      {Erase character}
  eED   {X} = 50;      {Erase in Display}
  eEF   { } = 51;      {Erase in field}
  eEL   {X} = 52;      {Erase in line}
  eEMI  { } = 53;      {Enable manual input}
  eEPA  { } = 54;      {End of protected mode}
  eERM  { } = 55;      {Erasure mode}
  eESA  { } = 56;      {End of selected area}
  eFEAM { } = 57;      {Format effector action mode}
  eFETM { } = 58;      {Format effector transfer mode}
  eFNT  { } = 59;      {Font selection}
  eGATM { } = 60;      {Guarded area transfer mode}
  eGSM  { } = 61;      {Graphics size modification}
  eGSS  { } = 62;      {Graphics size selection}
  eHEM  { } = 63;      {Horizontal editing mode}
  eHPA  {X} = eCHA;    {Horizontal position absolute}
  eHPR  {X} = eCUF;    {Horizontal position relative}
  eHTJ  {X} = 64;      {Horizontal tab with justification}
  eHTS  {X} = 65;      {Horizontal tabulation set}
  eHVP  {X} = eCUP;    {Horizontal and vertical position}
  eICH  {X} = 66;      {Insert character}
  eIL   {X} = 67;      {Insert line}
  eIND  {X} = eCUD;    {Index}
  eINT  { } = 68;      {Interrupt}
  eIRM  {.} = 69;      {Inseration-Replacement mode}
  eJFY  { } = 70;      {Justify}
  eKAM  {.} = 71;      {Keyboard action mode}
  eLNM  {.} = 72;      {Line feed new line mode}
  eMATM { } = 73;      {Multiple area transfer mode}
  eMC   {.} = 74;      {Media copy}
  eMW   {.} = 75;      {Message waiting}
  eNEL  {X} = 76;      {Next line}
  eNP   {.} = 77;      {Next page}
  eOSC  { } = 78;      {Operating system command}
  ePLD  { } = 79;      {Partial line down}
  ePLU  { } = 80;      {Partial line up}
  ePM   { } = 81;      {Privacy message}
  ePP   {.} = 82;      {Preceding page}
  ePU1  { } = 83;      {Private use 1}
  ePU2  { } = 84;      {Private use 2}
  ePUM  { } = 85;      {Positioning unit mode}
  eQUAD { } = 86;      {Quad}
  eREP  { } = 87;      {Repeat}
  eRI   {X} = 88;      {Reverse index}
  eRIS  {.} = 89;      {Reset to initial state}
  eRM   {.} = 90;      {Reset mode}
  eSATM { } = 91;      {Selected area transfer mode}
  eSD   { } = 92;      {Scroll down}
  eSEM  { } = 93;      {selected editing extent mode}
  eSGR  {X} = eSetAttribute;{Select graphics rendition}
  eSL   { } = 94;      {Scroll left}
  eSM   {.} = eSetMode;{Set Mode}
  eSPA  { } = 95;      {Start of protected area}
  eSPI  { } = 96;      {Spacing increment}
  eSR   { } = 97;      {Scroll right}
  eSRM  { } = 98;      {Send-Receive mode}
  eSRTM { } = 99;      {Status report transfer mode}
  eSS2  { } = 100;     {Single shift 2}
  eSS3  { } = 101;     {Single shift 3}
  eSSA  { } = 102;     {Start of selected area}
  eST   { } = 103;     {String terminator}
  eSTS  { } = 104;     {Set transmit state}
  eSU   { } = 105;     {Scroll up}
  eTBC  {X} = 106;     {Tabulation clear}
  eTSM  { } = 107;     {Tabulation stop mode}
  eTSS  { } = 108;     {Thin space specification}
  eTTM  { } = 109;     {Transfer termination mode}
  eVEM  { } = 110;     {Vertical editing mode}
  eVPA  {X} = 111;     {Vertical position absolute}
  eVPR  {X} = eCUD;    {Vertical position relative}
  eVTS  {X} = 112;     {vertical tabulation set}
  eDECSTBM  = 113;     {dec private-set Top/Bottom margin}

                       {New for version 3.0}
  eENQ  {X} = 114;     {enquiry request}
  eBEL  {X} = 115;     {sound bell}
  eBS   {X} = 116;     {backspace}
  eLF   {X} = 117;     {line feed command}
  eCR   {X} = 118;     {carriage return}
  eSO   {X} = 119;     {invoke G1 charset}
  eSI   {X} = 120;     {invoke G0 charset}
  eIND2 {X} = 121;     {corrected eIND (<> eCUD, eDown) new term only}
  eDECALN   = 122;     {DEC PRIVATE-screen alignment display}
  eDECDHL   = 123;     {DEC PRIVATE-Double height line}
  eDECDWL   = 124;     {DEC PRIVATE-Double width line}
  eDECLL    = 125;     {DEC PRIVATE-load LEDs}
  eDECREQTPARM = 126;  {DEC PRIVATE-request terminal parameters}
  eDECSWL   = 127;     {DEC PRIVATE-single width line}
  eDECTST   = 128;     {DEC PRIVATE-Invoke confidence test}
  eDECSCS   = 129;     {DEC PRIVATE-select charset}

  { Extended attributes }
  eattrBlink      = $01;
  eattrInverse    = $02;
  eattrIntense    = $04;
  eattrInvisible  = $08;
  eattrUnderline  = $10;

  { ANSI color constants }
  emBlack       = 0;
  emRed         = 1;
  emGreen       = 2;
  emYellow      = 3;
  emBlue        = 4;
  emMagenta     = 5;
  emCyan        = 6;
  emWhite       = 7;
  emBlackBold   = 8;
  emRedBold     = 9;
  emGreenBold   = 10;
  emYellowBold  = 11;
  emBlueBold    = 12;
  emMagentaBold = 13;
  emCyanBold    = 14;
  emWhiteBold   = 15;

  { AnsiEmulator option flags }
  teMapVT100           = $0001;

  { Misc }
  MaxParams      = 5;   { Maximum parameters for our interpreter }
  MaxQueue       = 20;  { Maximum characters in queue }
  MaxOther       = 11;  { Maximum other data }
  MaxParamLength = 5;   { Maximum parameter length for interpreter }
  KeyMappingLen  = 20;  { Maximum length of a keymapping }

type
  {AnsiEmulator's parser states}
  TAnsiParser = (GotNone, GotEscape, GotBracket, GotSemiColon, GotParam,
                 GotCommand, GotControlSeqIntro, GotLeftBrace, GotRightBrace,
                 GotSpace, GotQuestionMark, GotQuestionParam);

  {Array used for internal queue}
  TQueue = Array[1..MaxQueue] of AnsiChar;

  {Emulator for PC ANSI codes}
  PAnsiEmulator = ^TAnsiEmulator;
  TAnsiEmulator = record
    emuType        : Cardinal;       { Emulator Type }
    emuFlags       : Cardinal;
    emuFirst       : Boolean;        {True if first time thru}
    emuAttr        : Byte;
    emuIndex       : Cardinal;       {Index into rcvd byte array}
    emuParamIndex  : Cardinal;       {Parameter index}
    emuQueue       : TQueue;         {Queue of recvd bytes}
    emuParamStr    : array[1..MaxParams] of string[MaxParamLength];
    emuParamInt    : array[1..MaxParams] of Integer;
    emuParserState : TAnsiParser;    {Current state}
    emuOther       : Pointer;
  end;

const
  {Terminal window Cardinal}
  gwl_Terminal = 0;

  {Terminal options}
  tws_WantTab        = $0001; {Process tabs internally}
  tws_IntHeight      = $0002; {Integral height}
  tws_IntWidth       = $0004; {Integral width}
  tws_AutoHScroll    = $0008; {Add/remove horiz scroll automatically}
  tws_AutoVScroll    = $0010; {Add/remove vert scroll automatically}

type
  {For general typecasting}
  LH = record
    L,H : Word;
  end;

const
  MaxDBRecs    = 999;         {Maximum number of database records}
  MaxNameLen   = 21;          {Maximum length of a profile string key}
  MaxIndexLen  = 31;          {Maximum length of an index string}
  NonValue     = '#';         {Value of DB fields SPECIFICALLY left blank}
  dbIndex      = 'Index';     {Item index section heading}
  dbDefaults   = 'Defaults';  {Default value section heading}
  dbNumEntries = '_Entries';  {Number of entries key name}
  dbBogus      = 'None';      {Bogus key name for creating sections}

type
  PIniDatabaseKey = ^TIniDatabaseKey;
  TIniDatabaseKey = record
    KeyName  : PAnsiChar;
    DataSize : Cardinal;
    StrType  : Boolean;
    Index    : Boolean;
    Next     : PIniDatabaseKey;
  end;

  PIniDatabase = ^TIniDatabase;
  TIniDatabase = record
    FName          : PAnsiChar;
    DictionaryHead : PIniDatabaseKey;
    DictionaryTail : PIniDatabaseKey;
    NumRecords     : Integer;
    RecordSize     : Cardinal;
    DefaultRecord  : Pointer;
    Prepared       : Boolean;
  end;

const
  MaxTags      = 5;     {Maximum number of err corr or data comp tags}
  TagSepChar   = ',';   {Character that separates tags in a profile string}

const
  ModemNameLen = 31;    {Length of a modem name string}
  CmdLen       = 41;    {Maximum length of a modem command}
  RspLen       = 21;    {Maximum length of a modem response}
  TagLen       = 21;    {Maximum length of a tag string}
  TagProfLen   = 105;   {Maximum length of a tag profile string}
  BoolLen      = 5;     {Maximum length of a boolean string}
  BaudLen      = 7;     {Maximum length of a baud rate string}
  ConfigLen    = 255;   {Maximum length of a configuration string}

type
  {where these same variables are declared as Strings.}
  TModemNameZ     = array[0..ModemNameLen] of AnsiChar;
  TCmdStringZ     = array[0..CmdLen] of AnsiChar;
  TRspStringZ     = array[0..RspLen] of AnsiChar;
  TTagStringZ     = array[0..TagLen] of AnsiChar;
  TTagProfStringZ = array[0..TagProfLen] of AnsiChar;
  TConfigStringZ  = array[0..ConfigLen] of AnsiChar;
  TBoolStrZ       = array[0..BoolLen] of AnsiChar;
  TBaudStrZ       = array[0..BaudLen] of AnsiChar;

  TTagArrayZ = array[1..MaxTags] of TTagStringZ;

  PModemBaseData = ^TModemBaseData;
  TModemBaseData = record
    Name          : TModemNameZ;
    InitCmd       : TCmdStringZ;
    DialCmd       : TCmdStringZ;
    DialTerm      : TCmdStringZ;
    DialCancel    : TCmdStringZ;
    HangupCmd     : TCmdStringZ;
    ConfigCmd     : TConfigStringZ;
    AnswerCmd     : TCmdStringZ;
    OkMsg         : TRspStringZ;
    ConnectMsg    : TRspStringZ;
    BusyMsg       : TRspStringZ;
    VoiceMsg      : TRspStringZ;
    NoCarrierMsg  : TRspStringZ;
    NoDialToneMsg : TRspStringZ;
    ErrorMsg      : TRspStringZ;
    RingMsg       : TRspStringZ;
  end;

  PModemData = ^TModemData;
  TModemData = record
    Data        : TModemBaseData;
    NumErrors   : Cardinal;
    Errors      : TTagArrayZ;
    NumComps    : Cardinal;
    Compression : TTagArrayZ;
    LockDTE     : Boolean;
    DefBaud     : LongInt;
  end;

  PModemXFer = ^TModemXFer;
  TModemXFer = record
    Data     : TModemBaseData;
    Errors   : TTagProfStringZ;
    Compress : TTagProfStringZ;
    LockDTE  : TBoolStrZ;
    DefBaud  : TBaudStrZ;
  end;

  PModemDatabase = ^TModemDatabase;
  TModemDatabase = record
    DB : PIniDatabase;
  end;


const
  {keyboard shift state masks}
  ksControl = $02;
  ksAlt     = $04;
  ksShift   = $08;

  {keyboard toggle state masks}
  tsCapital = $02;
  tsNumlock = $04;
  tsScroll  = $08;

  {keybard INI file constants}
  KeyMapNameLen  = 30;    {Length of a KeyMap name string}
  MaxKeyMaps     = 100;   {Maximum possible key mapping per type}

  KeyIndexName    = 'EMULATOR';
  KeyIndexMaxLen  = 120;

type
  TKeyMapName    = array[0..KeyMapNameLen] of AnsiChar;
  TKeyMapping    = array[0..KeyMappingLen] of AnsiChar;
  TKeyMappingStr = string[KeyMappingLen];


  PKeyMapXFerRec = ^TKeyMapXFerRec;
  TKeyMapXFerRec = record
    Name : TKeyMapName;
    Keys : array[1..MaxKeyMaps] of TKeyMapping;
  end;

  PVKeyMapRec = ^TVKeyMapRec;
  TVKEyMapRec = record
    KeyCode   : Cardinal;
    ShiftState: Cardinal;
    Mapping   : TKeyMappingStr;
  end;

  PKeyEmulator = ^TKeyEmulator;
  TKeyEmulator = record
    kbKeyFileName : PAnsiChar;                            { current file name }
    kbKeyName     : TKeyMapName;                      { current key index name }
    kbProcessAll  : Boolean;
    kbProcessExt  : Boolean;
    kbKeyNameList : array[0..KeyIndexMaxLen] of AnsiChar;
    kbKeyMap      : array[1..MaxKeyMaps] of TVKeyMapRec;
    kbKeyDataBase : PIniDataBase;          { pointer to the INI data base file }
  end;

const
  {---- Option codes for protocols ----}
  apIncludeDirectory   = $0001;   {Set to include directory in file names}
  apHonorDirectory     = $0002;   {Set to honor directory in file names}
  apRTSLowForWrite     = $0004;   {Set to lower RTS during disk writes}
  apAbortNoCarrier     = $0008;   {Set to abort protocol on DCD loss}
  apKermitLongPackets  = $0010;   {Set to support long packets}
  apKermitSWC          = $0020;   {Set to support SWC}
  apZmodem8K           = $0040;   {Set to support 8K blocks}
  apBP2KTransmit       = $0080;   {Set to support 2K transmit blocks}
  apAsciiSuppressCtrlZ = $0100;   {Set to stop transmitting on ^Z}

  {---- Default options for protocols ----}
  DefProtocolOptions = 0;
  BadProtocolOptions = apKermitLongPackets+apKermitSWC+apZmodem8K;

  {Block check codes}
  bcNone      = 0;        {No block checking}
  bcChecksum1 = 1;        {Basic checksum}
  bcChecksum2 = 2;        {Two byte checksum}
  bcCrc16     = 3;        {16 bit Crc}
  bcCrc32     = 4;        {32 bit Crc}
  bcCrcK      = 5;        {Kermit style Crc}

  {Convenient blockcheck string constants}
  bcsNone      = 'No check';
  bcsChecksum1 = 'Checksum';
  bcsChecksum2 = 'Checksum2';
  bcsCrc16     = 'Crc16';
  bcsCrc32     = 'Crc32';
  bcsCrck      = 'CrcKermit';

  {Constants for supported protocol types}
  NoProtocol  = 0;
  Xmodem      = 1;
  XmodemCRC   = 2;
  Xmodem1K    = 3;
  Xmodem1KG   = 4;
  Ymodem      = 5;
  YmodemG     = 6;
  Zmodem      = 7;
  Kermit      = 8;
  Ascii       = 9;

  {Zmodem attention string length}
  MaxAttentionLen = 32;

  {Zmodem file management options}
  zfWriteNewerLonger = 1;          {Transfer if new, newer or longer}
  zfWriteCrc         = 2;          {Not supported, same as WriteNewer}
  zfWriteAppend      = 3;          {Transfer if new, append if exists}
  zfWriteClobber     = 4;          {Transfer regardless}
  zfWriteNewer       = 5;          {Transfer if new or newer}
  zfWriteDifferent   = 6;          {Transfer if new or diff dates/lens}
  zfWriteProtect     = 7;          {Transfer only if new}

  {Convenient protocol string constants}
  ProtocolString : array[NoProtocol..Ascii] of array[0..9] of AnsiChar= (
    'None', 'Xmodem', 'XmodemCRC', 'Xmodem1K', 'Xmodem1KG',
    'Ymodem', 'YmodemG', 'Zmodem', 'Kermit', 'Ascii');

type
  {For holding lists of files to transmit}
  PFileList = ^TFileList;
  TFileList = array[0..65535-1] of AnsiChar;

const
  {Flags passed to status function}
  csStarting    = $0001;
  csEnding      = $0002;

  {Font handles, same value as bytes-per-char}
  SmallFont    = 16;
  StandardFont = 48;

  {Maximum number of tree records}
  MaxTreeRec = 306;

  {Max size of decompress buffer}
  MaxData = 4096;

  {Text conversion limits}
  MaxLineLen = 144;

  {encoding/decoding table limits}
  MaxCodeTable   = 63;
  MaxMUCodeTable = 39;

type
  {Compression code tables}
  TCodeRec = record
    Code : Word;
    Sig  : Word;
  end;

  TTermCodeArray   = array[0..MaxCodeTable] of TCodeRec;
  TMakeUpCodeArray = array[0..MaxMUCodeTable] of TCodeRec;

  PBufferedOutputFile = ^TBufferedOutputFile;
  TBufferedOutputFile = record
    BufPos  : Word;
    Buffer  : PByteArray;
    OutFile : File;
  end;

  {For storing station IDs}
  Str20 = string[20];

  {Stores information about our fonts}
  TFontRecord = record
    Bytes  : Byte;  {# of bytes per char in font}
    PWidth : Byte;  {width of font in pixels}
    Width  : Byte;  {width of font in bytes (e.g. 16-pixel-wide = 2)}
    Height : Byte;  {height of font in raster lines}
  end;

const
  LineBufferSize = 4096;

const
  DMSize = 32;

const
  { Trigger constants }
  MaxTrigData = 21;                 { Max length of data trigger (should be odd) }
  MaxDataPointers = 3;              { Max number of data pointers }
  TimerFreq = 50;                   { Dispatcher timer interval in millisecs }

  { Data pointer constants }
  dpProtocol = 1;
  dpFax      = 2;
  dpModem    = 3;

  { Tracing constants }
  MaxTraceCol = 78;                 { Wrap trace reports at this column }

  { Logging constants }
  MaxDLogQueueSize = 16000000;      { Largest acceptable log queue }

type
  /// This will be removed with new debug logging

  { Types of dispatch entries } { We need to kill deps on this }
  TDispatchType = (
     dtNone, dtDispatch, dtTrigger, dtError, dtThread,
     dtTriggerAlloc, dtTriggerDispose, dtTriggerHandlerAlloc,
     dtTriggerHandlerDispose, dtTriggerDataChange, dtTelnet, dtFax,
     dtXModem, dtYModem, dtZModem, dtKermit, dtAscii, dtBPlus,
     dtPacket, dtUser, dtScript);
  TDispatchSubType =
    (dstNone,
     dstReadCom, dstWriteCom, dstLineStatus, dstModemStatus,
     dstAvail, dstTimer, dstData, dstStatus,
     dstThreadStart, dstThreadExit, dstThreadSleep, dstThreadWake,
     dstDataTrigger, dstTimerTrigger, dstStatusTrigger, dstAvailTrigger,
     dstWndHandler, dstProcHandler, dstEventHandler,
     dstSWill, dstSWont, dstSDo, dstSDont, dstRWill, dstRWont,
     dstRDo, dstRDont, dstCommand, dstSTerm,
     dsttfNone, dsttfGetEntry, dsttfInit, dsttf1Init1, dsttf2Init1,
     dsttf2Init1A, dsttf2Init1B, dsttf2Init2, dsttf2Init3, dsttfDial,
     dsttfRetryWait, dsttf1Connect, dsttf1SendTSI, dsttf1TSIResponse,
     dsttf1DCSResponse, dsttf1TrainStart, dsttf1TrainFinish,
     dsttf1WaitCFR, dsttf1WaitPageConnect, dsttf2Connect,
     dsttf2GetParams, dsttfWaitXon, dsttfWaitFreeHeader,
     dsttfSendPageHeader, dsttfOpenCover, dsttfSendCover,
     dsttfPrepPage,  dsttfSendPage, dsttfDrainPage, dsttf1PageEnd,
     dsttf1PrepareEOP, dsttf1SendEOP, dsttf1WaitMPS, dsttf1WaitEOP,
     dsttf1WaitMCF, dsttf1SendDCN, dsttf1Hangup, dsttf1WaitHangup,
     dsttf2SendEOP, dsttf2WaitFPTS, dsttf2WaitFET, dsttf2WaitPageOK,
     dsttf2SendNewParams, dsttf2NextPage, dsttf20CheckPage,
     dsttfClose, dsttfCompleteOK, dsttfAbort, dsttfDone, dstrfNone,
     dstrfInit, dstrf1Init1, dstrf2Init1, dstrf2Init1A, dstrf2Init1B,
     dstrf2Init2, dstrf2Init3, dstrfWaiting, dstrfAnswer,
     dstrf1SendCSI, dstrf1SendDIS, dstrf1CollectFrames,
     dstrf1CollectRetry1, dstrf1CollectRetry2, dstrf1StartTrain,
     dstrf1CollectTrain, dstrf1Timeout, dstrf1Retrain,
     dstrf1FinishTrain, dstrf1SendCFR, dstrf1WaitPageConnect,
     dstrf2ValidConnect, dstrf2GetSenderID, dstrf2GetConnect,
     dstrfStartPage, dstrfGetPageData, dstrf1FinishPage,
     dstrf1WaitEOP, dstrf1WritePage, dstrf1SendMCF, dstrf1WaitDCN,
     dstrf1WaitHangup, dstrf2GetPageResult, dstrf2GetFHNG,
     dstrfComplete, dstrfAbort, dstrfDone,
     dsttxInitial, dsttxHandshake, dsttxGetBlock, dsttxWaitFreeSpace,
     dsttxSendBlock, dsttxDraining, dsttxReplyPending,
     dsttxEndDrain, dsttxFirstEndOfTransmit, dsttxRestEndOfTransmit,
     dsttxEotReply, dsttxFinished, dsttxDone,
     dstrxInitial, dstrxWaitForHSReply, dstrxWaitForBlockStart,
     dstrxCollectBlock, dstrxProcessBlock,  dstrxFinishedSkip,
     dstrxFinished, dstrxDone,
     dsttyInitial, dsttyHandshake, dsttyGetFileName, dsttySendFileName,
     dsttyDraining, dsttyReplyPending, dsttyPrepXmodem,
     dsttySendXmodem, dsttyFinished, dsttyFinishDrain, dsttyDone,
     dstryInitial, dstryDelay, dstryWaitForHSReply,
     dstryWaitForBlockStart, dstryCollectBlock, dstryProcessBlock,
     dstryOpenFile, dstryPrepXmodem, dstryReceiveXmodem, dstryFinished,
     dstryDone, dsttzInitial, dsttzHandshake, dsttzGetFile,
     dsttzSendFile, dsttzCheckFile, dsttzStartData, dsttzEscapeData,
     dsttzSendData, dsttzWaitAck, dsttzSendEof, dsttzDrainEof,
     dsttzCheckEof, dsttzSendFinish, dsttzCheckFinish, dsttzError,
     dsttzCleanup, dsttzDone, dstrzRqstFile, dstrzDelay, dstrzWaitFile,
     dstrzCollectFile, dstrzSendInit, dstrzSendBlockPrep,
     dstrzSendBlock, dstrzSync, dstrzStartFile, dstrzStartData,
     dstrzCollectData, dstrzGotData, dstrzWaitEof, dstrzEndOfFile,
     dstrzSendFinish, dstrzCollectFinish, dstrzError, dstrzWaitCancel,
     dstrzCleanup, dstrzDone,
     dsttkInit, dsttkInitReply, dsttkCollectInit, dsttkOpenFile,
     dsttkSendFile, dsttkFileReply, dsttkCollectFile, dsttkCheckTable,
     dsttkSendData, dsttkBlockReply, dsttkCollectBlock, dsttkSendEof,
     dsttkEofReply, dsttkCollectEof, dsttkSendBreak, dsttkBreakReply,
     dsttkCollectBreak, dsttkComplete, dsttkWaitCancel, dsttkError,
     dsttkDone, dstrkInit, dstrkGetInit, dstrkCollectInit,
     dstrkGetFile, dstrkCollectFile, dstrkGetData, dstrkCollectData,
     dstrkComplete, dstrkWaitCancel, dstrkError, dstrkDone,
     dsttaInitial, dsttaGetBlock, dsttaWaitFreeSpace, dsttaSendBlock,
     dsttaSendDelay, dsttaFinishDrain, dsttaFinished, dsttaDone,
     dstraInitial, dstraCollectBlock, dstraProcessBlock,
     dstraFinished, dstraDone, dstEnable, dstDisable, dstStringPacket,
     dstSizePacket, dstPacketTimeout, dstStartStr, dstEndStr,
     dstIdle, dstWaiting, dstCollecting
     );

  {Holds one dispatcher entry}
  PDispatchRecord = ^TDispatchRecord;
  TDispatchRecord = record
    drType     : TDispatchType;
    drSubType  : TDispatchSubType;
    drTime     : DWORD;
    drData     : Cardinal;
    drMoreData : Cardinal;
  end;

  {Circular dispatch buffer}
  PDispatchQueue = ^TDispatchQueue;
  TDispatchQueue = array[0..MaxDLogQueueSize] of Byte;

  {DispatchBuffer type}
  PDBuffer = ^TDBuffer;
  TDBuffer = array[0..65527] of AnsiChar;
  /// End of dispatch log

  { Output buffer type }
  POBuffer = ^TOBuffer;
  TOBuffer = array[0..pred(High(Integer))] of AnsiChar;

  { Trigger types }
  TTriggerType = (ttNone, ttAvail, ttTimer, ttData, ttStatus);

  { Timer trigger record }
  PTimerTrigger = ^TTimerTrigger;
  TTimerTrigger = record
    tHandle : Cardinal;
    tET     : EventTimer;
    tmSecs  : DWORD;
    tValid  : Boolean;
    tActive : Boolean;
  end;

  { Data trigger match array }
  TCheckIndex = array[0..MaxTrigData] of Cardinal;

  { Data trigger record }
  PDataTrigger = ^TDataTrigger;
  TDataTrigger = record
    tHandle     : Cardinal;
    tLen        : Cardinal;
    tChkIndex   : TCheckIndex;
    tMatched    : Boolean;
    tIgnoreCase : Boolean;
    tData       : array[0..MaxTrigData] of AnsiChar;
  end;

  { Status trigger record }
  PStatusTrigger = ^TStatusTrigger;
  TStatusTrigger = record
    tHandle    : Cardinal;
    tSType     : Cardinal;
    tValue     : Word;
    tSActive   : Boolean;
    StatusHit  : Boolean;
  end;

  { Trigger save record }
  TTriggerSave = record
    tsTimerTriggers  : TList;
    tsDataTriggers   : TList;
    tsStatusTriggers : TList;
  end;

  { Trigger handler records }
  PQtTriggerHandler = ^TQtTriggerHandler;
  TQtTriggerHandler = record
    thHandle  : QObjectH;           { Qt handle that gets messages }
    thDeleted : Boolean;
  end;

  PProcTriggerHandler = ^TProcTriggerHandler;
  TProcTriggerHandler = record
    thNotify  : TApxNotifyProc;     { Address of notification proc }
    thDeleted : Boolean;
  end;

  PEventTriggerHandler = ^TEventTriggerHandler;
  TEventTriggerHandler = record
    thNotify  : TApxNotifyEvent;    { Address of notification event }
    thDeleted : Boolean;
    thSync : Boolean;
  end;

  { Data pointers for various purposes }
  TDataPointerArray = array[1..MaxDataPointers] of Pointer;
  { indexes in use internally (each component must use unique index) :
      1 : protocol component
      2 : fax component
      3 : legacy modem component
    }

procedure SetFlag(var Flags : Cardinal; FlagMask : Cardinal);
procedure ClearFlag(var Flags : Cardinal; FlagMask : Cardinal);
function FlagIsSet(Flags : Cardinal; FlagMask : Cardinal) : Boolean;
procedure SetByteFlag(var Flags : Byte; FlagMask : Byte);
procedure ClearByteFlag(var Flags : Byte; FlagMask : Byte);
function ByteFlagIsSet(Flags : Byte; FlagMask : Byte) : Boolean;
function MinWord(A, B : Cardinal) : Cardinal;

procedure NewTimer(var ET : EventTimer; mSecs : DWORD);
procedure NewTimerSecs(var ET : EventTimer; Secs : LongInt);
function TimerExpired(ET : EventTimer) : Boolean;
procedure DelayMS(mSecs : DWORD; Yield : Boolean);
function ElapsedTime(ET : EventTimer) : DWORD;
function ElapsedTimeInSecs(ET : EventTimer) : DWORD;
function RemainingTime(ET : EventTimer) : DWORD;
function RemainingTimeInSecs(ET : EventTimer) : LongInt;
function Long2StrZ(Dest : PAnsiChar; L : LongInt) : PAnsiChar;
function Str2LongZ(S : PAnsiChar; var I : LongInt) : Boolean;
function JustPathnameZ(Dest : PAnsiChar; PathName : PAnsiChar) : PAnsiChar;
function JustFilenameZ(Dest : PAnsiChar; PathName : PAnsiChar) : PAnsiChar;
function ApxIncludeTrailingPathDelimiterZ(Dest, PathName : PAnsiChar) : PAnsiChar;
function StrStCopy(Dest : PAnsiChar; S : PAnsiChar; Pos, Count : Cardinal) : PAnsiChar;
function ForceExtensionZ(Dest : PAnsiChar; Name, Ext : PAnsiChar) : PAnsiChar;
function DefaultExtensionZ(Dest : PAnsiChar; Name, Ext : PAnsiChar) : PAnsiChar;
function GetPtr(P : Pointer; O : LongInt) : Pointer;

{$IFDEF Linux}
{ Use Qt event mechanism to post a message }
function AxPostMessage(Handle : QObjectH; Msg : Cardinal; Event : TEvent;
  wParam : Longint; lParam : Longint) : Boolean;

{ Use Qt event mechanism to send a message }
function AxSendMessage(Handle : QObjectH; Msg : Cardinal; wParam : Longint;
  lParam : Longint) : Integer;
{$ENDIF}

procedure SafeYield;

function HexifyBlock(var Buffer; BufferSize : Integer) : string;

type
  TApxComponentClass = class of TComponent;
  TApxBaseComponentClass = class of TApxBaseComponent;
  TApxBaseHandleComponentClass = class of TApxBaseHandleComponent;

  TApxBaseComponent = class(TComponent)
  protected
    function GetVersion : string;
    procedure SetVersion(const Value : string);
  public
    class function GetLogString(const D1, D2, D3 : DWORD) : string; virtual;
  published
    property Version : string read GetVersion write SetVersion stored False;
  end;

  TApxBaseHandleComponent = class(THandleComponent)
  protected
    function GetVersion : string;
    procedure SetVersion(const Value : string);
  public
    class function GetLogString(const D1, D2, D3 : DWORD) : string; virtual;
  published
    property Version : string read GetVersion write SetVersion stored False;
  end;

  TApxBaseCustomControl = class(TCustomControl)
  protected
    function GetVersion : string;
    procedure SetVersion(const Value : string);
  published
    property Version : string read GetVersion write SetVersion stored False;
  end;

implementation

function MinWord(A, B : Cardinal) : Cardinal;
begin
  if A < B then
    Result := A
  else
    Result := B;
end;

function FlagIsSet(Flags : Cardinal; FlagMask : Cardinal) : Boolean;
begin
  FlagIsSet := (Flags and FlagMask) <> 0;
end;

procedure ClearFlag(var Flags : Cardinal; FlagMask : Cardinal);
begin
  Flags := Flags and not FlagMask;
end;

procedure SetFlag(var Flags : Cardinal; FlagMask : Cardinal);
begin
  Flags := Flags or FlagMask;
end;

function ByteFlagIsSet(Flags : Byte; FlagMask : Byte) : Boolean;
begin
  ByteFlagIsSet := (Flags and FlagMask) <> 0;
end;

procedure ClearByteFlag(var Flags : Byte; FlagMask : Byte);
begin
  Flags := Flags and not FlagMask;
end;

procedure SetByteFlag(var Flags : Byte; FlagMask : Byte);
begin
  Flags := Flags or FlagMask;
end;

{$IFDEF Linux}
{ Use Qt event mechanism to post a message }
{ Event parameter can be used to block. Receiver should set the Event }
{ passed in this parameter when the receiver is "done" with the message }
{ Sender waits on the passed event after posting message. If no block }
{ is desired, pass nil in the Event parameter }
function AxPostMessage(Handle : QObjectH; Msg : Cardinal; Event : TEvent;
  wParam : Longint; lParam : Longint) : Boolean;
var
  DispatchMessage : PAxMessage;
  CustomEvent : QCustomEventH;
begin
  Result := True;

  CustomEvent := nil;
  New(DispatchMessage);
  try
    DispatchMessage^.Msg := Msg;
    DispatchMessage^.Event := Event;
    DispatchMessage^.wParam := wParam;
    DispatchMessage^.lParam := lParam;
    DispatchMessage^.Result := 0;
    CustomEvent := QCustomEvent_create(QEventType_AxPostDispatchMessage, DispatchMessage);

    DispatchMessage := nil;

    QApplication_postEvent(Handle, CustomEvent);
  except
    if Assigned(DispatchMessage) then
      Dispose(DispatchMessage);

    if Assigned(CustomEvent) then
      QCustomEvent_destroy(CustomEvent);

    Result := False;
  end;
end;

{ Use Qt event mechanism to send a message }
{ This *cannot* be used for thread synchronization - message will be }
{ received in the context of the thread sending the message }
function AxSendMessage(Handle : QObjectH; Msg : Cardinal; wParam : Longint;
  lParam : Longint) : Integer;
var
  DispatchMessage : PAxMessage;
  CustomEvent : QCustomEventH;
begin
  CustomEvent := nil;
  New(DispatchMessage);
  try
    DispatchMessage^.Msg := Msg;
    DispatchMessage^.Event := nil;
    DispatchMessage^.wParam := wParam;
    DispatchMessage^.lParam := lParam;
    DispatchMessage^.Result := 0;

    CustomEvent := QCustomEvent_create(QEventType_AxSendDispatchMessage, DispatchMessage);

    { ignore return =} QApplication_sendEvent(Handle, CustomEvent);

    Result := DispatchMessage^.Result;
  finally
    if Assigned(DispatchMessage) then
      Dispose(DispatchMessage);

    if Assigned(CustomEvent) then
      QCustomEvent_destroy(CustomEvent);
  end;
end;
{$ENDIF}

{ Allow other processes a chance to run }
procedure SafeYield;
begin
  Application.HandleMessage;
end;

{ Returns a set EventTimer that will expire in mSecs }
procedure NewTimer(var ET : EventTimer; mSecs : DWORD);
begin
  with ET do begin
    StartMS := AxTimeGetTime;
    ExpireMS := StartMS + mSecs;
  end;
end;

{ Returns a set EventTimer }
procedure NewTimerSecs(var ET : EventTimer; Secs : LongInt);
begin
  NewTimer(ET, Secs*1000);
end;

{ Returns True if ET has expired }
function TimerExpired(ET : EventTimer) : Boolean;
var
  CurMS : DWORD;
begin
  with ET do begin
    { Get current time; assume timer has expired }
    CurMS := AxTimeGetTime;
    Result := True;

    { Check normal expiration }
    if CurMS > ExpireMS then
      Exit;

    { Check wrapped CurMS }
    if (CurMS < StartMS) and
       ((CurMS + High(DWORD)) > ExpireMS) then
      Exit;

    { If we get here, timer hasn't expired yet }
    Result := False;
  end;
end;

{ Delay for mSecs }
procedure DelayMS(mSecs : DWORD; Yield : Boolean);
var
  ET : EventTimer;
begin
  if mSecs = 0 then Exit;

  NewTimer(ET, mSecs);
  repeat
    if Yield then SafeYield;
  until Application.Terminated or TimerExpired(ET);
end;

{ Returns elapsed time, in mSec, for this timer }
function ElapsedTime(ET : EventTimer) : DWORD;
var
  CurMS : DWORD;
begin
  with ET do begin
    CurMS := AxTimeGetTime;
    if CurMS >= StartMS then
      { No wrap yet }
      Result := CurMS - StartMS
    else
      { Got a wrap, account for it }
      Result := (High(DWORD) - StartMS) + CurMS;
  end;
end;

{ Returns elapsed time, in seconds, for this timer }
function ElapsedTimeInSecs(ET : EventTimer) : DWORD;
begin
  ElapsedTimeInSecs := ElapsedTime(ET) div 1000;
end;

{ Returns remaining time, in mSecs, for this timer }
function RemainingTime(ET : EventTimer) : DWORD;
var
  CurMS : DWORD;
begin
  with ET do begin
    CurMS := AxTimeGetTime;
    if CurMS <= ExpireMS then
      { No wrap }
      Result := ExpireMS - CurMS
    else
      { Need to account for wrap }
      Result := (High(DWORD) - CurMS) + ExpireMS;
  end;
end;

{ Returns remaining time, in seconds, for this timer }
function RemainingTimeInSecs(ET : EventTimer) : LongInt;
begin
  RemainingTimeInSecs := RemainingTime(ET) div 1000;
end;

{ Convert a long/Cardinal/integer/byte/shortint to a string }
function Long2StrZ(Dest : PAnsiChar; L : LongInt) : PAnsiChar;
var
  S : string;
begin
  Str(L, S);
  Result := StrPCopy(Dest, S);
end;

const
  MaxLen  = 255;
  ExtLen = 3;

type
  TSmallArray = Array[0..MaxLen-1] of AnsiChar;

{ Convert a string to a longint, returning true if successful }
function Str2LongZ(S : PAnsiChar; var I : LongInt) : Boolean;
var
  Err : Integer;
begin
  Val(StrPas(S),I,Err);
  Result := Err = 0;
end;

{ Return just the drive:directory portion of a pathname }
function JustPathnameZ(Dest : PAnsiChar; PathName : PAnsiChar) : PAnsiChar;
begin
  Dest := PChar (ExtractFilePath (PathName));
  Result := Dest;
end;

{ Return just the filename of a pathname }
function JustFilenameZ(Dest : PAnsiChar; PathName : PAnsiChar) : PAnsiChar;
begin
  Dest := PChar (ExtractFileName (PathName));
  Result := Dest;
end;

function StrStCopy(Dest : PAnsiChar; S : PAnsiChar; Pos, Count : Cardinal) : PAnsiChar;
var
  Len : Cardinal;

begin
  Len := StrLen(S);
  if Pos < Len then begin
    if (Len-Pos) < Count then
      Count := Len-Pos;
    Move(S[Pos], Dest^, Count);
    Dest[Count] := #0;
  end else
    Dest[0] := #0;
  StrStCopy := Dest;
end;

function ApxIncludeTrailingPathDelimiterZ(Dest, PathName : PAnsiChar) : PAnsiChar;
begin
  Dest := PChar (IncludeTrailingPathDelimiter(PathName));
  Result := Dest;
end;

function ForceExtensionZ(Dest : PAnsiChar; Name, Ext : PAnsiChar) : PAnsiChar;
begin
  Result := StrPCopy(Dest,ChangeFileExt(StrPas(Name),'.'+StrPas(Ext)));
end;

function DefaultExtensionZ(Dest : PAnsiChar; Name, Ext : PAnsiChar) : PAnsiChar;
var
  S : string;
begin
  S := StrPas(Name);
  if ExtractFileExt(S) = '' then
    S := ChangeFileExt(S,'.'+StrPas(Ext));
  Result := StrPCopy(Dest,S);
end;

function GetPtr(P : Pointer; O : LongInt) : Pointer; assembler; register;
asm
  add   eax,edx   {eax = P; edx = Offset}
end;

{ Returns an appropriate string for the given parameters }
class function TApxBaseComponent.GetLogString(const D1, D2, D3: DWORD): string;
begin
  Result := '!!!! Unhandled log entry' + AxLineTerm;
end;

function TApxBaseComponent.GetVersion : string;
begin
  Result := ApxVersionStr;
end;

procedure TApxBaseComponent.SetVersion(const Value : string);
begin
  { Intentionally Empty }
end;

{ Returns an appropriate string for the given parameters }
class function TApxBaseHandleComponent.GetLogString(const D1, D2, D3: DWORD): string;
begin
  Result := '!!!! Unhandled log entry' + AxLineTerm;
end;

function TApxBaseHandleComponent.GetVersion : string;
begin
  Result := ApxVersionStr;
end;

procedure TApxBaseHandleComponent.SetVersion(const Value : string);
begin
  { Intentionally Empty }
end;

function TApxBaseCustomControl.GetVersion : string;
begin
  Result := ApxVersionStr;
end;

procedure TApxBaseCustomControl.SetVersion(const Value : string);
begin
  { Intentionally Empty }
end;

{ Gives text representation of a block of data }
function HexifyBlock(var Buffer; BufferSize : Integer) : string;
const
  { Starting string to work with - this is directly written to by index }
  { below, so any positional changes here will also have to be made below. }
  StockString = '  %6.6x: 00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00 : 0000000000000000' + AxLineTerm;
  HexDigits : array[0..$F] of AnsiChar = '0123456789ABCDEF';
var
  I, J, K, Lines : Integer;
  TempStr : string;
  Hex1, Hex2 : array[0..23] of AnsiChar;
  Ascii1, Ascii2 : array[0..7] of AnsiChar;
begin
  K := 0;
  FillChar(Hex1, SizeOf(Hex1), #32);
  FillChar(Hex2, SizeOf(Hex2), #32);

  { Calculate number of lines required }
  Lines := BufferSize div 16;
  if (BufferSize mod 16) <> 0 then Inc(Lines);

  { Process and append lines }
  for I := 0 to Lines-1 do begin

    { Load string, add index marker }
    TempStr := Format(StockString, [I*16]);

    { Format data for first word }
    for J := 0 to 7 do begin
      if J+K >= BufferSize then begin
        Ascii1[J] := ' ';
        Hex1[J*3] := ' ';
        Hex1[J*3+1] := ' ';
      end else begin
        Ascii1[J] := TApxCharArray(Buffer)[J+K];
        Hex1[J*3] := HexDigits[Byte(Ascii1[J]) shr 4];
        Hex1[J*3+1] := HexDigits[Byte(Ascii1[J]) and $F];

        { Clamp Ascii to printable range }
        if (Ascii1[J] < #32) or (Ascii1[J] > #126) then Ascii1[J] := '.';
      end;
    end;
    Inc(K,8);

    { Format data for second word }
    for J := 0 to 7 do begin
      if J+K >= BufferSize then begin
        Ascii2[J] := ' ';
        Hex2[J*3] := ' ';
        Hex2[J*3+1] := ' ';
      end else begin
        Ascii2[J] := TApxCharArray(Buffer)[J+K];
        Hex2[J*3] := HexDigits[Byte(Ascii2[J]) shr 4];
        Hex2[J*3+1] := HexDigits[Byte(Ascii2[J]) and $F];
        { Clamp Ascii to printable range }
        if (Ascii2[J] < #32) or (Ascii2[J] > #126) then Ascii2[J] := '.';
      end;
    end;
    Inc(K,8);

    { Move data to existing temp string }
    Move(Hex1[0], TempStr[11], SizeOf(Hex1));
    Move(Hex2[0], TempStr[36], SizeOf(Hex2));

    Move(Ascii1[0], TempStr[62], SizeOf(Ascii1));
    Move(Ascii2[0], TempStr[70], SizeOf(Ascii2));

    { Append temp string to result }
    Result := Result + TempStr;
  end;
end;

initialization

end.

