(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxPBEdit.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

unit AxPBEdit;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, AxPBook, AxPort;

type
  TAxPBEditor = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    edtEntryName: TEdit;
    cbxType: TComboBox;
    edtAddress: TEdit;
    cbxEmulation: TComboBox;
    cbxProtocol: TComboBox;
    gbxSettings: TGroupBox;
    Label4: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    cbxDataBits: TComboBox;
    cbxParity: TComboBox;
    cbxStopBits: TComboBox;
    edtCustom1: TEdit;
    edtCustom2: TEdit;
    edtCustom3: TEdit;
    edtCustom4: TEdit;
    Label9: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    procedure SetPhoneBookEntry(const Entry : TAxPBookRecord);
    function GetPhoneBookEntry : TAxPBookRecord;
    { Private declarations }
  public
    { Public declarations }
    property PhoneBookEntry : TAxPBookRecord
      read GetPhoneBookEntry write SetPhoneBookEntry;
    procedure ClearEntry;
    function Execute (var Entry : TAxPBookRecord) : Boolean; overload;
    function Execute : Boolean; overload;
  end;

var
  AxPBEditor: TAxPBEditor;

implementation

{$R *.xfm}

function TAxPBEditor.Execute(var Entry : TAxPBookRecord): Boolean;
  { Show the edit dialog with the specified entry - for editing }
begin
  PhoneBookEntry := Entry;
  Result := ShowModal = mrOK;
  if Result then
    Entry := PhoneBookEntry;
end;

function TAxPBEditor.Execute: Boolean;
  { Show the edit dialog to add an entry }
begin
  ClearEntry;
  Result := ShowModal = mrOK;
end;

procedure TAxPBEditor.FormCreate(Sender: TObject);
  { Initialize the drop downs }
var
  I : Integer;
begin                                                                            
  cbxType.Items.Clear;
  for I := ord(low(TAxPBEntryType)) to ord(high(TAxPBEntryType)) do
    cbxType.Items.Add(CAxPBEntryTypeString[TAxPBEntryType(I)]);

  cbxDataBits.Items.Clear;
  for I := ord(low(TAxDataBits)) to ord(high(TAxDataBits)) do
    cbxDataBits.Items.Add(CAxPBSettingsDataBitsString[TAxDataBits(I)]);
  cbxParity.Items.Clear;
  for I := ord(low(TAxParity)) to ord(high(TAxParity)) do
    cbxParity.Items.Add(CAxPBSettingsParityLongString[TAxParity(I)]);
  cbxStopBits.Items.Clear;
  for I := ord(low(TAxStopBits)) to ord(high(TAxStopBits)) do
    cbxStopBits.Items.Add(CAxPBSettingsStopBitsString[TAxStopBits(I)]);

  cbxEmulation.Items.Clear;
  for I := ord(low(TAxPBEmulation)) to ord(high(TAxPBEmulation)) do
    cbxEmulation.Items.Add(CAxPBEmulationString[TAxPBEmulation(I)]);
  cbxProtocol.Items.Clear;
  for I := ord(low(TAxPBProtocol)) to ord(high(TAxPBProtocol)) do
    cbxProtocol.Items.Add(CAxPBProtocolString[TAxPBProtocol(I)]);
end;

procedure TAxPBEditor.SetPhoneBookEntry(const Entry : TAxPBookRecord);
  { fill in the controls with the specified entry }
begin
  edtEntryName.Text := Entry.EntryName;
  cbxType.ItemIndex := ord(Entry.EntryType);
  edtAddress.Text := Entry.Address;
  cbxDataBits.ItemIndex := ord(Entry.Settings.DataBits) - ord(dbFive);
  cbxParity.ItemIndex := ord(Entry.Settings.Parity);
  cbxStopBits.ItemIndex := ord(Entry.Settings.StopBits);
  cbxEmulation.ItemIndex := ord(Entry.Emulation);
  cbxProtocol.ItemIndex := ord(Entry.Protocol);
  edtCustom1.Text := Entry.Custom1;
  edtCustom2.Text := Entry.Custom2;
  edtCustom3.Text := Entry.Custom3;
  edtCustom4.Text := Entry.Custom4;
end;

function TAxPBEditor.GetPhoneBookEntry : TAxPBookRecord;
  { return the entry based on the controls }
begin
  Result.EntryName := edtEntryName.Text;
  Result.EntryType := TAxPBEntryType(cbxType.ItemIndex);
  Result.Address := edtAddress.Text;
  Result.Settings.DataBits := TAxDataBits(cbxDataBits.ItemIndex + ord(dbFive));
  Result.Settings.Parity := TAxParity(cbxParity.ItemIndex);
  Result.Settings.StopBits := TAxStopBits(cbxStopBits.ItemIndex);
  Result.Emulation := TAxPBEmulation(cbxEmulation.ItemIndex);
  Result.Protocol := TAxPBProtocol(cbxProtocol.ItemIndex);
  Result.Custom1 := edtCustom1.Text;
  Result.Custom2 := edtCustom2.Text;
  Result.Custom3 := edtCustom3.Text;
  Result.Custom4 := edtCustom4.Text;
end;

procedure TAxPBEditor.ClearEntry;
  { initialize the controls to defaults }
begin
  edtEntryName.Text := '';
  cbxType.ItemIndex := ord(pbtSerial);
  edtAddress.Text := '';

  cbxDataBits.ItemIndex := ord(dbEight) - ord(dbFive);
  cbxParity.ItemIndex := ord(pNone);
  cbxStopBits.ItemIndex := ord(sbOne);
  cbxEmulation.ItemIndex := ord(pbeTTY);
  cbxProtocol.ItemIndex := ord(ptZmodem);
  edtCustom1.Text := '';
  edtCustom2.Text := '';
  edtCustom3.Text := '';
  edtCustom4.Text := '';
end;

end.
