(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxSelCom.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F+,J+}
{$C MOVEABLE,DEMANDLOAD,DISCARDABLE}

unit AxSelCom;
  {-Com port selection dialog}
interface

uses
  SysUtils,
  Classes,
  QControls,
  QForms,
  QDialogs,
  QStdCtrls,
  QExtCtrls,
  QButtons,
  AxSystem,
  AxMisc;

type
  TComSelectForm = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    PortsComboBox: TComboBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function SelectedDevice : string;
  end;

var
  ComSelectForm: TComSelectForm;

implementation

{$R *.xfm}

const
  DeviceArray : array[0..20] of string =
  {0}   ('/dev/ttyS%d',      // UART serial port
  {1}    '/dev/ttyC%d',      // Cyclades serial card
  {2}    '/dev/ttyD%d',      // Digiboard serial card
  {3}    '/dev/ttyE%d',      // Stallion serial card
  {4}    '/dev/ttyF%d',      // Computone IntelliPort II serial card
  {5}    '/dev/ttyH%d',      // Chase serial card
  {6}    '/dev/ttyI%d',      // ISDN4Linux
  {7}    '/dev/ttyL%d',      // SDL RISCom serial card
  {8}    '/dev/ttyM%d',      // PAM Software's multimodem boards
  {9}    '/dev/ttyP%d',      // Hayes ESP serial card
  {10}   '/dev/ttyR%d',      // Comtrol Rocketport serial card
  {11}   '/dev/ttyT%d',      // Technology Concepts serial card
  {12}   '/dev/ttyV%d',      // Comtrol VS-1000 serial controller
  {13}   '/dev/ttyW%d',      // Specialix IO8+ serial card
  {14}   '/dev/ttyX%d',      // Specialix
  {15}   '/dev/ttyCH%d',     // Chase Research AT/PCI-Fast serial card
  {16}   '/dev/ttyCP%d',     // Digi Neo serial card
  {17}   '/dev/ttyMX%d',     // Moxa Intellio serial card
  {18}   '/dev/ttySI%d',     // SmartIO serial card
  {19}   '/dev/ttySR%d',     // Specialix RIO serial card
  {20}   '/dev/ttyUSB%d');   // USB serial converters

procedure PopulateList(const List : TStrings);
var
  S : string;
  I,J : integer;
begin
  { Based on the Linux docs, it seems like it's a valid assumption    }
  { that if a given type of card is installed, we'll see consecutive  }
  { device numbers starting at 0. That keeps us from having to cycle  }
  { through *everything*, so that's good. If it turns out to be a bad }
  { assumption -- we'll have to adjust, I guess. }

  { Check special case }
  S := '/dev/modem';
  if AxIsDeviceValid(S) then
    List.Add(S);

  { Check other devices }
  for I := 0 to High(DeviceArray) do begin
    S := Format(DeviceArray[I], [0]);
    if AxIsDeviceValid(S) then begin
      List.Add(S);
      J := 1;
      S := Format(DeviceArray[I], [J]);
      while AxIsDeviceValid(S) do begin
        List.Add(S);
        Inc(J);
        S := Format(DeviceArray[I], [J]);
      end;
    end;
  end;
end;

procedure TComSelectForm.FormCreate(Sender: TObject);
begin
  PopulateList(PortsComboBox.Items);
  PortsComboBox.ItemIndex := 0;
end;

function TComSelectForm.SelectedDevice : string;
begin
  Result := PortsComboBox.Items[PortsComboBox.ItemIndex];
end;

end.
