(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                  AxString.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

unit AxString;

(*
  The string resource is broken into 3 parts.  The first is the actual
  string resources.  This is followed by error numbers corresponding to
  those string resources.  This in turn is followed by a cross reference
  array to convert error numbers into strings.  It is very important that
  the cross reference array be kept in numerical order.  The lookup is
  performed by a binary search.
*)

interface

const
  AxCRLF = #13#10;
  AxLF = #10;

resourcestring

  AxecSOK                           = 'OK';
  AxecSFileNotFound                 = 'File not found';
  AxecSPathNotFound                 = 'Path not found';
  AxecSTooMayFiles                  = 'Too many open files';
  AxecSAccessDenied                 = 'File access denied';
  AxecSInvalidHandle                = 'Invalid file handle';
  AxecSOutOfMemory                  = 'Insufficient memory';
  AxecSInvalidDrive                 = 'Invalid drive';
  AxecSNoMoreFiles                  = 'No more files';

  AxecSDiskRead                     = 'Attempt to read beyond end of file';
  AxecSDiskFull                     = 'Disk is full';
  AxecSNotAssigned                  = 'File/device not assigned';
  AxecSNotOpen                      = 'File/device not open';
  AxecSNotOpenInput                 = 'File/device not open for input';
  AxecSNotOpenOutput                = 'File/device not open for output';
  AxecSWriteProtected               = 'Disk is write-protected';
  AxecSUnknownUnit                  = 'Unknown disk unit';
  AxecSDriveNotReady                = 'Drive is not ready';
  AxecSUnknownCommand               = 'Unknown command';
  AxecSCrcError                     = 'Data error';
  AxecSBadStructLen                 = 'Bad request structure length';
  AxecSSeekError                    = 'Seek error';
  AxecSUnknownMedia                 = 'Unknown media type';
  AxecSSectorNotFound               = 'Disk sectore not found';
  AxecSOutOfPaper                   = 'Printer is out of paper';
  AxecSDeviceWrite                  = 'Device write error';
  AxecSDeviceRead                   = 'Device read error';
  AxecSHardwareFailure              = 'General failure';

  AxecSBadHandle                    = 'Bad handle passed to com function';
  AxecSBadArgument                  = 'Bad argument passed to function';
  AxecSGotQuitMsg                   = 'Got quit message';
  AxecSBufferTooBig                 = 'Terminal buffer greater than 65521';
  AxecSPortNotAssigned              = 'ComPort component not assigned';
  AxecSInternal                     = 'Internal error creating window class';
  AxecSModemNotAssigned             = 'Modem component not assigned';
  AxecSPhonebookNotAssigned         = 'Phonebook component not assigned';
  AxecSCannotUseWithWinSock         = 'Component not compatible with WinSock';

  AxecSBadId                        = 'ie_BadId - specified comport doesn''t exist';
  AxecSBaudRate                     = 'ie_Baudrate - unsupported baud rate';
  AxecSByteSize                     = 'ie_Bytesize - invalid byte size';
  AxecSDefault                      = 'ie_Default = error in default parameters';
  AxecSHardware                     = 'ie_Hardware - specified comport in use';
  AxecSMemory                       = 'ie_Memory - unable to allocate queues';
  AxecSCommNotOpen                  = 'ie_NOpen - device not open';
  AxecSAlreadyOpen                  = 'ie_Open - device already open';
  AxecSNoHandles                    = 'No more handles, can''t open port';
  AxecSNoTimers                     = 'No timers available';
  AxecSNoPortSelected               = 'The ComNumber property of the TApdComPort has not been set';
  AxecSNotOpenedByTapi              = 'Comport was not opened by Tapi';

  AxecSNullApi                      = 'No device layer specified';
  AxecSNotSupported                 = 'Function not supported by driver';
  AxecSRegisterHandlerFailed        = 'EnableCommNotification failed';
  AxecSPutBlockFail                 = 'Failed to put entire block';
  AxecSGetBlockFail                 = 'Failed to get entire block';
  AxecSOutputBufferTooSmall         = 'Output buffer too small for block';
  AxecSBufferIsEmpty                = 'Buffer is empty';
  AxecSTracingNotEnabled            = 'Tracing not enabled';
  AxecSLoggingNotEnabled            = 'Logging not enabled';
  AxecSBaseAddressNotSet            = 'Base address not set';

  AxecSModemNotStarted              = 'StartModem has not been called';
  AxecSModemBusy                    = 'Modem is busy elsewhere';
  AxecSModemNotDialing              = 'Modem is not currently dialing';
  AxecSNotDialing                   = 'Dialer is not dialing';
  AxecSAlreadyDialing               = 'Dialer is already dialing';
  AxecSModemNotResponding           = 'Modem is not responding';
  AxecSModemRejectedCommand         = 'Invalid command sent to modem';
  AxecSModemStatusMismatch          = 'Wrong modem status requested';

// PhonebookEditor strings -- constants in ADPBEDIT.PAS

  AxpeSDeleteQuery                  = 'Are you sure you want to delete this entry?';

// Simple Modem strings -- constants in ADSMODEM.PAS

  AxsmSMsgReady                     = 'Ready';
  AxsmSMsgInitialize                = 'Initializing modem';
  AxsmSMsgInitializeTimeout         = 'Initialize timed out';
  AxsmSAutoAnswerBackground         = 'Autoanswer in backgroung';
  AxsmSAutoAnswerWait               = 'Waiting for incoming call';
  AxsmSAnswerWait                   = 'Answering call';
  AxsmSDialWait                     = 'Dialing';
  AxsmSDialCycle                    = 'Pausing until redial';
  AxsmSNoDialtone                   = 'No dialtone';
  AxsmSConnectWait                  = 'Connected waiting';
  AxsmSConnected                    = 'Connected';
  AxsmSHangup                       = 'Disconnecting';
  AxsmSCancel                       = 'Canceling';

// Dialer strings -- constants in ADDIAL.PAS

  AxddSCycling                      = 'Cycling dial attempt . . .';
  AxddSRetryWaiting                 = 'Waiting . . .';
  AxddSRetryWaitOver                = 'Wait complete, redialing . . .';
  AxddSDialing                      = 'Dialing . . .';
  AxddSModemConnect                 = 'Modem connected!';
  AxddSModemConnectAt               = 'Connected at %d baud';
  AxddSModemVoice                   = 'Connection Result: Remote answered with voice';
  AxddSModemError                   = 'Connection Result: Modem returned an error';
  AxddSModemNoCarrier               = 'Connection Result: No carrier, connection failed';
  AxddSModemBusy                    = 'Connection Result: Remote is busy';
  AxddSModemNoDialTone              = 'Connection Result: No dialtone, check connections';
  AxddSDialTimedOut                 = 'Dial attempt timed out';

// Phonebook entry strings -- constants in ADPENTRY.PAS

  AxpeSMustEnterName                = 'You must enter an entry name';
  AxpeSMustEnterNumber              = 'You must enter a phone number';
  AxpeSNameExists                   = 'A phonebook entry with that name already exists';

// RAS component strings -- constants in ADRASUTL.PAS

  AxcsSOpenPort                     = 'OpenPort';
  AxcsSPortOpened                   = 'PortOpened';
  AxcsSConnectDevice                = 'ConnectDevice';
  AxcsSDeviceConnected              = 'DeviceConnected';
  AxcsSAllDevicesConnected          = 'AllDevicesConnected';
  AxcsSAuthenticate                 = 'Authenticate';
  AxcsSAuthNotify                   = 'AuthNotify';
  AxcsSAuthRetry                    = 'AuthRetry';
  AxcsSAuthCallback                 = 'AuthCallback';
  AxcsSAuthChangePassword           = 'AuthChangePassword';
  AxcsSAuthProject                  = 'AuthProject';
  AxcsSAuthLinkSpeed                = 'AuthLinkSpeed';
  AxcsSAuthAck                      = 'AuthAck';
  AxcsSReAuthenticate               = 'ReAuthenticate';
  AxcsSAuthenticated                = 'Authenticated';
  AxcsSPrepareForCallback           = 'PrepareForCallback';
  AxcsSWaitForModemReset            = 'WaitForModemReset';
  AxcsSWaitForCallback              = 'WaitForCallback';
  AxcsSProjected                    = 'Projected';
  AxcsSStartAuthentication          = 'StartAuthentication';
  AxcsSCallbackComplete             = 'CallbackComplete';
  AxcsSLogonNetwork                 = 'LogonNetwork';
  AxcsSSubEntryConnected            = 'SubEntryConnected';
  AxcsSSubEntryDisconnected         = 'SubEntryDisconnected';

  AxcsSInteractive                  = 'Interactive';
  AxcsSRetryAuthentication          = 'RetryAuthentication';
  AxcsSCallbackSetByCaller          = 'CallbackSetByCaller';
  AxcsSPasswordExpired              = 'PasswordExpired';

  AxcsSDeviceConnected2             = 'DeviceConnected';

// Paging component strings -- constants in ADPAGER.PAS

  AxTDS_SNONE                       = '';
  AxTDS_SOFFHOOK                    = 'Off Hook';
  AxTDS_SDIALING                    = 'Dialing';
  AxTDS_SRINGING                    = 'Ringing';
  AxTDS_SWAITFORCONNECT             = 'Wait For Connect';
  AxTDS_SCONNECTED                  = 'Connected';
  AxTDS_SWAITINGTOREDIAL            = 'Waiting To Redial';
  AxTDS_SREDIALING                  = 'Redialing';
  AxTDS_SMSGNOTSENT                 = 'Message  Not Sent';
  AxTDS_SCANCELLING                 = 'Cancelling';
  AxTDS_SDISCONNECT                 = 'Disconnect';
  AxTDS_SCLEANUP                    = 'Cleanup';

  AxTDE_SNONE                       = '';
  AxTDE_SNODIALTONE                 = 'No Dial Tone';
  AxTDE_SLINEBUSY                   = 'Busy';
  AxTDE_SNOCONNECTION               = 'No Connection';

  AxTPS_SNONE                       = '';
  AxTPS_SLOGINPROMPT                = 'Logged Prompt';
  AxTPS_SLOGGEDIN                   = 'Logged In';
  AxTPS_SLOGINERR                   = 'Login Error';
  AxTPS_SLOGINFAIL                  = 'Login Fail';
  AxTPS_SMSGOKTOSEND                = 'Message Ok To Send';
  AxTPS_SSENDINGMSG                 = 'Sending Message';
  AxTPS_SMSGACK                     = 'Message Acknowledged';
  AxTPS_SMSGNAK                     = 'Message Not Acknowledged';
  AxTPS_SMSGRS                      = 'Message Error';
  AxTPS_SMSGCOMPLETED               = 'Message Completed';
  AxTPS_SDONE                       = 'Done';

// Protocol resource strings
// If strings are added -- apStatusMsg needs to be changed in AWABSPCL.PAS

  AxpsSOK                           = 'OK';
  AxpsSProtocolHandshake            = 'Protocol handshaking in progress';
  AxpsSInvalidDate                  = 'Bad date/time stamp received and ignored';
  AxpsSFileRejected                 = 'File rejected';
  AxpsSFileRenamed                  = 'File renamed';
  AxpsSSkipFile                     = 'File skipped';
  AxpsSFileDoesntExist              = 'File doesn''t exist locally, skipped';
  AxpsSCantWriteFile                = 'File skipped ';
  AxpsSTimeout                      = 'Timeout in protocol';
  AxpsSBlockCheckError              = 'Bad checksum or CRC';
  AxpsSLongPacket                   = 'Block too long';
  AxpsSDuplicateBlock               = 'duplicate block received and ignored ';
  AxpsSProtocolError                = 'Error in protocol';
  AxpsSCancelRequested              = 'Cancel requested';
  AxpsSEndFile                      = 'At end of file';
  AxpsSResumeBad                    = 'B+ host refused resume request';
  AxpsSSequenceError                = 'Block was out of sequence';
  AxpsSAbortNoCarrier               = 'Aborting due to carrier loss';

  AxpsSGotCrcE                      = 'Got CrcE packet (Zmodem)';
  AxpsSGotCrcG                      = 'Got CrcG packet (Zmodem)';
  AxpsSGotCrcW                      = 'Got CrcW packet (Zmodem)';
  AxpsSGotCrcQ                      = 'Got CrcQ packet (Zmodem)';
  AxpsSTryResume                    = 'B+ is trying to resume a download';
  AxpsSHostResume                   = 'B+ host is resuming';

// Fax resource strings
// If strings are added -- apStatusMsg needs to be changed in AWABSPCL.PAS

  AxfpSInitModem                    = 'Initializing modem for fax processing';
  AxfpSDialing                      = 'Dialing';
  AxfpSBusyWait                     = 'Busy, waiting until redial...';
  AxfpSSendPage                     = 'Sending page data';
  AxfpSSendPageStatus               = 'Sending EOP';
  AxfpSPageError                    = 'Error sending page';
  AxfpSPageOK                       = 'page accepted by remote';
  AxfpSConnecting                   = 'Connecting...';

  AxfpSWaiting                      = 'Waiting for incoming call';
  AxfpSNoConnect                    = 'No connect on this call';
  AxfpSAnswer                       = 'Answering incoming call';
  AxfpSIncoming                     = 'Incoming call validated as fax';
  AxfpSGetPage                      = 'Getting page data';
  AxfpSGetPageResult                = 'Getting end-of-page signal';
  AxfpSCheckMorePages               = 'Getting end-of-document status';
  AxfpSGetHangup                    = 'Getting hangup command';
  AxfpSGotHangup                    = 'Got Class 2 FHNG code';

  AxfpSSessionParams                = 'Getting connection params';
  AxfpSGotRemoteID                  = 'Got called-station ID';
  AxfpSCancel                       = 'User abort';
  AxfpSFinished                     = 'Finished';


// Error strings -- constants in OOMISC.INC

  AxecSNoMoreTriggers               = 'No more trigger slots';
  AxecSTriggerTooLong               = 'Data trigger too long';
  AxecSBadTriggerHandle             = 'Bad trigger handle';

  AxecSStartStringEmpty             = 'Start string is empty';
  AxecSPacketTooSmall               = 'Packet size cannot be smaller than start string';
  AxecSNoEndCharCount               = 'CharCount packets must have an end-condition';
  AxecSEmptyEndString               = 'End string is empty';
  AxecSZeroSizePacket               = 'Packet size cannot be zero';
  AxecSPacketTooLong                = 'Packet too long';

  AxecSBadFileList                  = 'Bad format in file list';
  AxecSNoSearchMask                 = 'No search mask specified during transmit';
  AxecSNoMatchingFiles              = 'No files matched search mask';
  AxecSDirNotFound                  = 'Directory in search mask doesn''t exist';
  AxecSCancelRequested              = 'Cancel requested';
  AxecSTimeout                      = 'Fatal time out';
  AxecSProtocolError                = 'Unrecoverable event during protocol';
  AxecSTooManyErrors                = 'Too many errors during protocol';
  AxecSSequenceError                = 'Block sequence error in Xmodem';
  AxecSNoFilename                   = 'No filename specified in protocol receive';
  AxecSFileRejected                 = 'File was rejected';
  AxecSCantWriteFile                = 'Can''t write file';
  AxecSTableFull                    = 'Kermit window table is full, fatal error';
  AxecSAbortNoCarrier               = 'Aborting due to carrier loss';
  AxecSBadProtocolFunction          = 'Function not supported by protocol';

  AxecSKeyTooLong                   = 'Key string too long';
  AxecSDataTooLarge                 = 'Data string too long';
  AxecSNoFieldsDefined              = 'No fields defined in database';
  AxecSIniWrite                     = 'Generic INI file write error';
  AxecSIniRead                      = 'Generic INI file read error';
  AxecSNoIndexKey                   = 'No index defined for database';
  AxecSRecordExists                 = 'Record already exists';
  AxecSRecordNotFound               = 'Record not found in database';
  AxecSMustHaveIdxVal               = 'Invalid index key name';
  AxecSDatabaseFull                 = 'Maximum database records (999) reached';
  AxecSDatabaseEmpty                = 'No records in database';
  AxecSDatabaseNotPrepared          = 'iPrepareIniDatabase not called';
  AxecSBadFieldList                 = 'Bad field list in INI component';
  AxecSBadFieldForIndex             = 'Bad field index in INI component';

  AxecSFaxBadFormat                 = 'File is not an APF file';
  AxecSBadGraphicsFormat            = 'Unsupported graphics file format';
  AxecSConvertAbort                 = 'User aborted fax conversion';
  AxecSUnpackAbort                  = 'User aborted fax unpack';
  AxecSCantMakeBitmap               = 'CreateBitmapIndirect API failure';
  AxecSNoImageLoaded                = 'No image loaded into viewer';
  AxecSNoImageBlockMarked           = 'No block of image marked';
  AxecSFontFileNotFound             = 'APFAX.FNT not found, or resource bad';
  AxecSInvalidPageNumber            = 'Invalid page number specified for fax';
  AxecSBmpTooBig                    = 'BMP size exceeds windows'' maxheight of 32767';
  AxecSEnhFontTooBig                = 'Font selected for enhanced text converter too large';

  AxecSFaxBadMachine                = 'Fax incompatible with remote fax';
  AxecSFaxBadModemResult            = 'Bad response from modem';
  AxecSFaxTrainError                = 'Modems failed to train';
  AxecSFaxInitError                 = 'Error while initializing modem';
  AxecSFaxBusy                      = 'Called fax number was busy';
  AxecSFaxVoiceCall                 = 'Called fax number answered with voice';
  AxecSFaxDataCall                  = 'Incoming data call';
  AxecSFaxNoDialTone                = 'No dial tone';
  AxecSFaxNoCarrier                 = 'Failed to connect to remote fax';
  AxecSFaxSessionError              = 'Fax failed in mid-session';
  AxecSFaxPageError                 = 'Fax failed at page end';
  AxecSFaxGDIPrintError             = 'NextBand GDI error in fax print driver';
  AxecSFaxMixedResolution           = 'Multiple resolutions per session not supported';
  AxecSFaxConverterInitFail         = 'Initialization of fax converter failed';
  AxecSNoAnswer                     = 'Remote fax did not answer';
  AxecSAlreadyMonitored             = 'Directory already being monitored';

  AxecSUniAlreadyInstalled          = 'Unidriv support files already installed';
  AxecSUniCannotGetSysDir           = 'Cannot determine windows system dir';
  AxecSUniCannotGetWinDir           = 'Cannot determine windows dir';
  AxecSUniUnknownLayout             = 'Cannot determine setup file layour';
  AxecSUniCannotParseInfFile        = 'Cannot find Unidriv files in setup file';
  AxecSUniCannotInstallFile         = 'Cannot install Unidrv files in setup file';
  AxecSNotNTDriver                  = 'Printer driver not NT compatible';
  AxecSDrvCopyError                 = 'Error copying printer driver';
  AxecSCannotAddPrinter             = '32-bit AddPrinter call failed';
  AxecSDrvBadResources              = 'Bad/missing resources in driver';
  AxecSDrvDriverNotFound            = 'Driver file not found';
  AxecSUniCannotGetPrinterDriverDir = 'Cannot determine Win NT printer driver dir';
  AxecSInstallDriverFailed          = 'AddPrinterDriver API failed';

  // Additional AxPackEd errors     8300-8399

  AxecStrPackEdMismatchedQuote      = 'Mismatched '' in string';
  AxecStrPackEdNumberExpected       = 'Numeric constant expected after #';
  AxecStrPackEdNumberOutOfRange     = 'Numeric constant in string is out of range';
  AxecStrPackEdHex0String           = '#0 cannot be stored in a Delphi string';
  AxecStrPackEdAlphaExpected        = 'Alpha character excepted after ^';

  // Additional AxTrmEmu Errors     8400-8499

  AxecStrTrmEmuNotEnoughData        = 'Not enough data in queue (%s bytes) to satisfy read request (%s bytes)';

  // Additional AxTrmBuf Errors     8500-8599

  AxecStrTrmBufDelItemsRangeErr     = 'TApxTerminalArray.DeleteItems: either row %d or col %d is out of range';
  AxecStrTrmBufGetItemPtrRangeErr   = 'TApxTerminalArray.GetItemPtr: either row %d or col %d is out of range';
  AxecStrTrmBufGetItemPtrSizeErr    = 'TApxTerminalArray.GetItemPtr: invalid item size';
  AxecStrTrmBufInsertItemRangeErr   = 'TApxTerminalArray.InsertItems: either row %d or col %d is out of range';
  AxecStrTrmBufScrollRowRangeErr    = 'TApxTerminalArray.ScrollRows: either start row %d or end row %d is out of range';
  AxecStrTrmBufColCountTooLow1      = 'TApxTerminalArray.taSetColCount: new col count %d is less than zero';
  AxecStrTrmBufColCountTooLow2      = 'TApxTerminalArray.taSetColCount: new col count %d is less than zero';
  AxecStrTrmBufWriteDupItemsRange   = 'TApxTerminalArray.WriteDupItems: either row %d or col %d is out of range';
  AxecStrTrmBufWriteItemsRangeErr   = 'TApxTerminalArray.WriteItems: either row %d or col %d is out of range';
  AxecStrTrmBufDeleteCharTooLow     = 'TApxTerminalBuffer.DeleteChars: count must be positive';
  AxecStrTrmBufDeleteLinesTooLow    = 'TApxTerminalBuffer.DeleteLines: count must be positive';
  AxecStrTrmBufEraseCharsCount      = 'TApxTerminalBuffer.EraseChars: Count must be +ve';
  AxecStrTrmBufGetLineAttPtrRange   = 'TApxTerminalBuffer.GetLineAttrPtr: row number is out of range';
  AxecStrTrmBufGetLineBackColorRng  = 'TApxTerminalBuffer.GetLineBackColorPtr: row number is out of range';
  AxecStrTrmBufGetLineCharPtrRange  = 'TApxTerminalBuffer.GetLineCharPtr: row number is out of range';
  AxecStrTrmBufGetLineCharSetRange  = 'TApxTerminalBuffer.GetLineCharSetPtr: row number is out of range';
  AxecStrTrmBufGetLineForeColorRng  = 'TApxTerminalBuffer.GetLineForeColorPtr: row number is out of range';
  AxecStrTrmBufInsertCharsCount     = 'TApxTerminalBuffer.InsertChars: count must be positive';
  AxecStrTrmBufInsertLinesCount     = 'TApxTerminalBuffer.InsertLines: count must be positive';
  AxecStrTrmBufScrollRgnRowNum      = 'TApxTerminalBuffer.SetScrollRegion: invalid row number(s)';
  AxecStrTrmBufColCountTooSmall     = 'TApxTerminalBuffer.tbSetColCount: new count too small';
  AxecStrTrmBufSetRowCountTooSmall  = 'TApxTerminalBuffer.tbSetRowCount: new count too small';
  AxecStrTrmBufSetSVRowCountToSmall = 'TApxTerminalBuffer.tbSetSVRowCount: new count too small';

  // Additional AxPager Error       8600-8699

  AxecStrPagerUnableToFreeTrigger   = 'Unable to free trigger: %s';
  AxecStrPagerNoComport             = 'No ComPort Component Assigned';
  AxecStrPagerNoSuchTriggerType     = 'No such trigger type: %s';

  // Additional AxWin32 Errors      8700-8799

  AxecStrWin32DispatcherStarted     = 'Dispatcher already started';

// APRO-specfic error constants are found in ADSOCKET.PAS

  AxADSWSEERROR                     = 'Async Professional Error';
  AxADSWSLOADERROR                  = 'Error loading Winsock DLL';
  AxADSWSVERSIONERROR               = 'Incorrect vresion of Winsock';
  AxADSWSNOTINIT                    = 'Winsock not initialized - $s';
  AxADSWSINVPORT                    = 'Specified port is not valid';
  AxADSWSCANTCHANGE                 = 'Cannot change parameter while socket is connected';
  AxADSWSCANTRESOLVE                = 'Cannot resolve destination address';

// Standard Winsock error constants are found in ADWUTIL.PAS

  AxwsaSEIntr                       = 'Interrupted function call';
  AxwsaSEBadF                       = 'Bad file number';
  AxwsaSEAcces                      = 'Permission denied';
  AxwsaSEFault                      = 'Unknown error';
  AxwsaSEInVal                      = 'Invalid argument';
  AxwsaSEMFile                      = 'Too many open files';

  AxwsaSEWouldBlock                 = 'Warning : the socket would block on this call';
  AxwsaSEInProgress                 = 'A blocking call is in progress';
  AxwsaSEAlReady                    = 'WSAEALREADY: watch out, Al is ready';
  AxwsaSENotSock                    = 'Socket descriptor is (1) not a socket, or (2) is of the wrong type';
  AxwsaSEDestAddrReq                = 'The destination address is required for this operation';
  AxwsaSEMsgSize                    = 'The datagram was too large to fit into the buffer and was truncated';
  AxwsaSEPrototype                  = 'WSAEPROTOTYPE';
  AxwsaSENoProtoOpt                 = 'The option is unknown or not supported';
  AxwsaSEProtoNoSupport             = 'Either (1) not enough buffer space to create socket (2) protocol not supported'; 
  AxwsaSESocktNoSupport             = 'Specified socket type not supported in this address family';
  AxwsaSEOpNotSupp                  = 'Operation is not supported by this socket';
  AxwsaSEPfNoSupport                = 'Specified protocol family is not supported';
  AxwsaSEAfNoSupport                = 'Specified address family is not supported by this protocol'; 
  AxwsaSEAddrInUse                  = 'The address is already in use for this operation';
  AxwsaSEAddrNotAvail               = 'The address is not available from this machine';
  AxwsaSENetDown                    = 'The network subsystem has failed';
  AxwsaSENetUnreach                 = 'The network is unreachable from this machine at this time';
  AxwsaSENetReset                   = 'The network has been reset';
  AxwsaSEConnAborted                = 'The virtual circuit has been aborted due to timeout, etc';
  AxwsaSEConnReset                  = 'The virtual circuit has been reset by the partner';
  AxwsaSENoBufs                     = 'The descriptor is not a socket, or no buffer space is available';
  AxwsaSEIsConn                     = 'The socket is already connected';
  AxwsaSENotConn                    = 'The socket is not connected';
  AxwsaSEShutDown                   = 'The socket has been shut down';
  AxwsaSETooManyRefs                = 'WSAETOOMANYREFS';
  AxwsaSETimedOut                   = 'The operation timed out';
  AxwsaSEConnRefused                = 'The attempt to connect was forcibly refused';
  AxwsaSELoop                       = 'WSAELOOP: see WSAELOOP';
  AxwsaSENameTooLong                = 'The name is too long';
  AxwsaSEHostDown                   = 'The host machine is down';
  AxwsaSEHostUnreach                = 'The host machine is unreachable';
  AxwsaSENotEmpty                   = 'WSAENOTEMPTY';
  AxwsaSEProcLim                    = 'WSAEPROCLIM';
  AxwsaSEUsers                      = 'WSAEUSERS';
  AxwsaSEDQuot                      = 'WSAEDQUOT';
  AxwsaSEStale                      = 'WSAESTALE';
  AxwsaSERemote                     = 'WSAEREMOTE';

  { Extended Windows Sockets error constant definitions }

  AxwsaSSysNotReady                 = 'Network subsystem unusable';
  AxwsaSVerNotSupported             = 'Version requested by WSAStartUp not supported by loaded Winsock DLL';
  AxwsaSNotInitialised              = 'WSAStartUp not yet called';
  AxwsaSEDiscOn                     = 'WSAEDISCON';


  AxwsaSHost_Not_Found              = 'Host not found';
  AxwsaSTry_Again                   = 'Host not found, or SERVERFAIL, can try again';
  AxwsaSNo_Recovery                 = 'Non recoverable errors, FORMERR, REFUSED, NOTIMP';
  AxwsaSNo_Data                     = 'Valid name, but no data record of requested type';

// TAPI Line Call State Messages -- See ADTUTIL & ADTAPI

  AxSTapiLineCallState1             = 'Line is idle';
  AxSTapiLineCallState2             = 'Offering line...';
  AxSTapiLineCallState3             = 'Accepting call...';
  AxSTapiLineCallState4             = 'Dialtone detected';
  AxSTapiLineCallState5             = 'Dialing...';
  AxSTapiLineCallState6             = 'Ringback detected';
  AxSTapiLineCallState7             = 'Called number is busy';
  AxSTapiLineCallState8             = 'Special info';
  AxSTapiLineCallState9             = 'Connected!';
  AxSTapiLineCallState10            = 'Proceeding...';
  AxSTapiLineCallState11            = 'On hold...;';
  AxSTapiLineCallState12            = 'Call conferenced';
  AxSTapiLineCallState13            = 'On hold pending conference...';
  AxSTapiLineCallState14            = 'On hold pending transfer...';
  AxSTapiLineCallState15            = 'Call disconnected (%s)';
  AxSTapiLineCallState16            = 'Unknown state';

// TAPI Line Device State Messages -- See ADTUTIL & ADTAPI

  AxSTapiLineDeviceState33          = 'Other';
  AxSTapiLineDeviceState34          = 'Ringing';
  AxSTapiLineDeviceState35          = 'Connected';
  AxSTapiLineDeviceState36          = 'Disconnected';
  AxSTapiLineDeviceState37          = 'Message wait on';
  AxSTapiLineDeviceState38          = 'Message wait off';
  AxSTapiLineDeviceState39          = 'In service';
  AxSTapiLineDeviceState40          = 'Out of service';
  AxSTapiLineDeviceState41          = 'Maintenance change';
  AxSTapiLineDeviceState42          = 'Open change';
  AxSTapiLineDeviceState43          = 'Closed';
  AxSTapiLineDeviceState44          = 'Number of calls changed';
  AxSTapiLineDeviceState45          = 'Number of completions changed';
  AxSTapiLineDeviceState46          = 'Terminals changed';
  AxSTapiLineDeviceState47          = 'Roam mode changed';
  AxSTapiLineDeviceState48          = 'Battery changed';
  AxSTapiLineDeviceState49          = 'Signal changed';
  AxSTapiLineDeviceState50          = 'Device specific change';
  AxSTapiLineDeviceState51          = 'Re-initialized';
  AxSTapiLineDeviceState52          = 'Lock change';
  AxSTapiLineDeviceState53          = 'Caps change';
  AxSTapiLineDeviceState54          = 'Configuration change';
  AxSTapiLineDeviceState55          = 'Translate change';
  AxSTapiLineDeviceState56          = 'Compltion cancel';
  AxSTapiLineDeviceState57          = 'Removed';
  
  AxSTapiLineDeviceState65          = 'TAPI line reply';

  AxSTapiLineDeviceState97          = 'TAPI state change';
  AxSTapiLineDeviceState98          = 'Called number is busy';
  AxSTapiLineDeviceState99          = 'Dial failed/no connection';
  AxSTapiLineDeviceState100         = 'Waiting for retry in %d seconds';
  AxSTapiLineDeviceState101         = 'Device is in use by another application';

// TAPI Disconnect messages

  AxSTapiDisconnect01               = 'Reason Unspecified';
  AxSTapiDisconnect02               = 'Normal Hangup by Remote';
  AxSTapiDisconnect03               = 'Reason Unknown';
  AxSTapiDisconnect04               = 'Remote Rejected Call';
  AxSTapiDisconnect05               = 'Call Picked Up Elsewhere';
  AxSTapiDisconnect06               = 'Call was Forwarded';
  AxSTapiDisconnect07               = 'Line was Busy';
  AxSTapiDisconnect08               = 'No Answer by Remote';
  AxSTapiDisconnect09               = 'Invalid Destination Address';
  AxSTapiDisconnect10               = 'Remote Unreachable';
  AxSTapiDisconnect11               = 'Network Congestion';
  AxSTapiDisconnect12               = 'Remote Equipment Incompatible';
  AxSTapiDisconnect13               = 'Reason Unavailable';
  AxSTapiDisconnect14               = 'No Dialtone';
  AxSTapiDisconnect15               = 'Number Changed';
  AxSTapiDisconnect16               = 'Out of Order';
  AxSTapiDisconnect17               = 'Temporary Failure';
  AxSTapiDisconnect18               = 'Quality of Service Unavail';
  AxSTapiDisconnect19               = 'Blocked';
  AxSTapiDisconnect20               = 'Do Not Disturb';
  AxSTapiDisconnect21               = 'Cancelled';
  
// TAPI Error messages -- See OOMISC.INC, ADTUTIL & ADTAPI

  AxecSAllocated                    = 'Already allocated';
  AxecSBadDeviceID                  = 'Bad device ID';
  AxecSBearerModeUnavail            = 'Bearer mode unavailable';
  AxecSCallUnavail                  = 'Call unavailable';
  AxecSCompletionOverrun            = 'Completion overrun';
  AxecSConferenceFull               = 'Conference full';
  AxecSDialBilling                  = 'Dial failed';
  AxecSDialDialtone                 = 'Dial failed, no dialtone';
  AxecSDialPrompt                   = 'Dial failed';
  AxecSDialQuiet                    = 'Dial failed';
  AxecSIncompatibleApiVersion       = 'Incompatible API version';
  AxecSIncompatibleExtVersion       = 'Incompatible EXT version';
  AxecSIniFileCorrupt               = 'INI file corrupt';
  AxecSInUse                        = 'Resource in use';
  AxecSInvalAddress                 = 'Invalid address';
  AxecSInvalAddressID               = 'Invalid address ID';
  AxecSInvalAddressMode             = 'Invalid address mode';
  AxecSInvalAddressState            = 'Invalid address state';
  AxecSInvalAppHandle               = 'Invalid application handle';
  AxecSInvalAppName                 = 'Invalid Application name';
  AxecSInvalBearerMode              = 'Invalid bearer mode';
  AxecSInvalCallComplMode           = 'Invalid call completion mode';
  AxecSInvalCallHandle              = 'Invalid call handle';
  AxecSInvalCallParams              = 'Invalid call parameters';
  AxecSInvalCallPrivilege           = 'Invalid call privilege';
  AxecSInvalCallSelect              = 'Invalid call select';
  AxecSInvalCallState               = 'Invalid call state';
  AxecSInvalCallStatelist           = 'Invalid call state list';
  AxecSInvalCard                    = 'Invalid card';
  AxecSInvalCompletionID            = 'Invalid completion ID';
  AxecSInvalConfCallHandle          = 'Invalid conference call handle';
  AxecSInvalConsultCallHandle       = 'Invalid consultation call handle';
  AxecSInvalCountryCode             = 'Invalid country code';
  AxecSInvalDeviceClass             = 'Invalid device class';
  AxecSInvalDeviceHandle            = 'Invalid device handle';
  AxecSInvalDialParams              = 'Invalid dial params';
  AxecSInvalDigitList               = 'Invalid digit list';
  AxecSInvalDigitMode               = 'Invalid digit mode';
  AxecSInvalDigits                  = 'Invalid digits';
  AxecSInvalExtVersion              = 'Invalid ext version';
  AxecSInvalGroupID                 = 'Invalid group ID';
  AxecSInvalLineHandle              = 'Invalid line handle';
  AxecSInvalLineState               = 'Invalid line state';
  AxecSInvalLocation                = 'Invalid location';
  AxecSInvalMediaList               = 'Invalid media list';
  AxecSInvalMediaMode               = 'Invalid media mode';
  AxecSInvalMessageID               = 'Invalid message ID';
  AxecSInvalParam                   = 'Invalid parameter';
  AxecSInvalParkID                  = 'Invalid park ID';
  AxecSInvalParkMode                = 'Invalid park mode';
  AxecSInvalPointer                 = 'Invalid pointer';
  AxecSInvalPrivSelect              = 'Invalid privilege select';
  AxecSInvalRate                    = 'Invalid rate';
  AxecSInvalRequestMode             = 'Invalid request mode';
  AxecSInvalTerminalID              = 'Invalid terminal ID';
  AxecSInvalTerminalMode            = 'Invalid terminal mode';
  AxecSInvalTimeout                 = 'Invalid timeout';
  AxecSInvalTone                    = 'Invalid tone';
  AxecSInvalToneList                = 'Invalid tone list';
  AxecSInvalToneMode                = 'Invalid tone mode';
  AxecSInvalTransferMode            = 'Invalid transfer mode';
  AxecSLineMapperFailed             = 'Line mapper failed';
  AxecSNoConference                 = 'No conference';
  AxecSNoDevice                     = 'No device';
  AxecSNoDriver                     = 'No driver';
  AxecSNoMem                        = 'No memory';
  AxecSNoRequest                    = 'No request';
  AxecSNotOwner                     = 'Not owner';
  AxecSNotRegistered                = 'Not registered';
  AxecSOperationFailed              = 'Operation failed';
  AxecSOperationUnavail             = 'Operation unavailable';
  AxecSRateUnavail                  = 'Rate unavailable';
  AxecSResourceUnavail              = 'Resource unavailable';
  AxecSRequestOverrun               = 'Request overrun';
  AxecSStructureTooSmall            = 'Structure too small';
  AxecSTargetNotFound               = 'Target not found';
  AxecSTargetSelf                   = 'Target is self';
  AxecSUninitialized                = 'Uninitialized';
  AxecSUserUserInfoTooBig           = 'User info too big';
  AxecSReinit                       = 'Reinit failed';
  AxecSAddressBlocked               = 'Address blocked';
  AxecSBillingRejected              = 'Billing rejected';
  AxecSInvalFeature                 = 'Invalid feature';
  AxecSNoMultipleInstance           = 'No multiple instance';

// Apro-specific TAPI messages -- see OOMISC.INC & ADTAPI.PAS

  AxecSTapiBusy                     = 'TAPI already open, dialing or answering';
  AxecSTapiNotSet                   = 'TapiMode not set in TApdComPort';
  AxecSTapiNoSelect                 = 'No TAPI device selected';
  AxecSTapiLoadFail                 = 'Failed to find/load TAPI.DLL';
  AxecSTapiGetAddrFail              = 'Failed to get TAPI address';
  AxecSTapi16Disabled               = 'TAPI disabled for 16-bit environments';
  AxecSTapiUnexpected               = 'Unexpected TAPI error';
  AxecSTapiVoiceNotSupported        = 'TAPI device does not support voice extensions';
  AxecSTapiWaveFail                 = 'TAPI wave file error';
  AxecSTapiCIDBlocked               = 'Caller ID Blocked';
  AxecSTapiCIDOutOfArea             = 'Out of Area Call';
  AxecSTapiWaveFormatError          = 'The selected file is not a wave file';
  AxecSTapiWaveReadError            = 'Unable to read wave file data';
  AxecSTapiWaveBadFormat            = 'Unsupported wave format';
  AxecSTapiTranslateFail            = 'Unable to translate address';
  AxecSTapiWaveDeviceInUse          = 'Wave device in use';
  AxecSTapiWaveFileExists           = 'Wave file already exists';
  AxecSTapiWaveNoData               = 'No wave data available';

// Apro-specific RAS messages -- see OOMISC.INC & ADRASUTL.PAS

  AxecSRasLoadFail                  = 'Failed to find/load RASAPI32.DLL';

// Logging (15xxx)

// Main categories

  AxdtSNone                         = 'No event';
  AxdtSDispatch                     = 'Dispatch';
  AxdtSTrigger                      = 'Trigger';
  AxdtSError                        = 'Error';
  AxdtSThread                       = 'Thread';
  AxdtSTriggerAlloc                 = 'TrigAllc';
  AxdtSTriggerDispose               = 'TrigDisp';
  AxdtSTriggerHandlerAlloc          = 'TrgHdAlc';
  AxdtSTriggerHandlerDispose        = 'TrgHdDsp';
  AxdtSTriggerDataChange            = 'TrDatChg';
  AxdtSTelnet                       = 'Telnet';
  AxdtSFax                          = 'Fax';
  AxdtSXModem                       = 'XModem';
  AxdtSYModem                       = 'YModem';
  AxdtSZModem                       = 'ZModem';
  AxdtSKermit                       = 'Kermit';
  AxdtSAscii                        = 'Ascii';
  AxdtSBPlus                        = 'BPlus';
  AxdtSPacket                       = 'Packet';
  AxdtSUser                         = 'User';
  AxdtSScript                       = 'Script';

// Sub categories

  AxdstSNone                        = '';
  AxdstSReadCom                     = 'ReadCom';
  AxdstSWriteCom                    = 'WriteCom';
  AxdstSLineStatus                  = 'Line status';
  AxdstSModemStatus                 = 'Modem status';
  AxdstSAvail                       = 'Avail';
  AxdstSTimer                       = 'Timer';
  AxdstSData                        = 'Data';
  AxdstSStatus                      = 'Status';
  AxdstSThreadStart                 = 'Start';
  AxdstSThreadExit                  = 'Exit';
  AxdstSThreadSleep                 = 'Sleep';
  AxdstSThreadWake                  = 'Wake';
  AxdstSDataTrigger                 = 'Data';
  AxdstSTimerTrigger                = 'Timer';
  AxdstSStatusTrigger               = 'Status';
  AxdstSAvailTrigger                = 'Avail';
  AxdstSWndHandler                  = 'Window';
  AxdstSProcHandler                 = 'Procedure';
  AxdstSEventHandler                = 'Method';
  AxdstSSWill                       = 'Sent WILL';
  AxdstSSWont                       = 'Sent WON''T';
  AxdstSSDo                         = 'Sent DO';
  AxdstSSDont                       = 'Sent DON''T';
  AxdstSRWill                       = 'Recv WILL';
  AxdstSRWont                       = 'Recv WON''T';
  AxdstSRDo                         = 'Recv DO';
  AxdstSRDont                       = 'Recv DON''T';
  AxdstSCommand                     = 'Command';
  AxdstSSTerm                       = 'Sent Term';
  AxdstStfNone                      = 'tfNone';
  AxdstStfGetEntry                  = 'tfGetEntry';
  AxdstStfInit                      = 'tfInit';
  AxdstStf1Init1                    = 'tf1Init1';
  AxdstStf2Init1                    = 'tf2Init1';
  AxdstStf2Init1A                   = 'tf2Init1A';
  AxdstStf2Init1B                   = 'tf2Init1B';
  AxdstStf2Init2                    = 'tf2Init2';
  AxdstStf2Init3                    = 'tf2Init3';
  AxdstStfDial                      = 'tfDial';
  AxdstStfRetryWait                 = 'tfRetryWait';
  AxdstStf1Connect                  = 'tf1Connect';
  AxdstStf1SendTSI                  = 'tf1SendTSI';
  AxdstStf1TSIResponse              = 'tf1TSIRespns';
  AxdstStf1DCSResponse              = 'tf1DCSRspns';
  AxdstStf1TrainStart               = 'tf1TrainStrt';
  AxdstStf1TrainFinish              = 'tf1TrainFnsh';
  AxdstStf1WaitCFR                  = 'tf1WaitCFR';
  AxdstStf1WaitPageConnect          = 'tf1WaitPgCn';
  AxdstStf2Connect                  = 'tf2Connect';
  AxdstStf2GetParams                = 'tf2GetParams';
  AxdstStfWaitXon                   = 'tfWaitXon';
  AxdstStfWaitFreeHeader            = 'tfWaitFrHead';
  AxdstStfSendPageHeader            = 'tfSndPgeHdr';
  AxdstStfOpenCover                 = 'tfOpenCover';
  AxdstStfSendCover                 = 'tfSendCover';
  AxdstStfPrepPage                  = 'tfPrepPage';
  AxdstStfSendPage                  = 'tfSendPage';
  AxdstStfDrainPage                 = 'tfDrainPage';
  AxdstStf1PageEnd                  = 'tf1PageEnd';
  AxdstStf1PrepareEOP               = 'tf1PrepEOP';
  AxdstStf1SendEOP                  = 'tf1SendEOP';
  AxdstStf1WaitMPS                  = 'tf1WaitMPS';
  AxdstStf1WaitEOP                  = 'tf1WaitEOP';
  AxdstStf1WaitMCF                  = 'tf1WaitMCF';
  AxdstStf1SendDCN                  = 'tf1SendDCN';
  AxdstStf1Hangup                   = 'tf1Hangup';
  AxdstStf1WaitHangup               = 'tf1WaitHngp';
  AxdstStf2SendEOP                  = 'tf2SendEOP';
  AxdstStf2WaitFPTS                 = 'tf2WaitFPTS';
  AxdstStf2WaitFET                  = 'tf2WaitFET';
  AxdstStf2WaitPageOK               = 'tf2WaitPgOK';
  AxdstStf2SendNewParams            = 'tf2SndNwPrm';
  AxdstStf2NextPage                 = 'tf2NextPage';
  AxdstStf20CheckPage               = 'tf20ChckPg';
  AxdstStfClose                     = 'tfClose';
  AxdstStfCompleteOK                = 'tfCompleteOK';
  AxdstStfAbort                     = 'tfAbort';
  AxdstStfDone                      = 'tfDone';
  AxdstSrfNone                      = 'rfNone';
  AxdstSrfInit                      = 'rfInit';
  AxdstSrf1Init1                    = 'rf1Init1';
  AxdstSrf2Init1                    = 'rf2Init1';
  AxdstSrf2Init1A                   = 'rf2Init1A';
  AxdstSrf2Init1B                   = 'rf2Init1B';
  AxdstSrf2Init2                    = 'rf2Init2';
  AxdstSrf2Init3                    = 'rf2Init3';
  AxdstSrfWaiting                   = 'rfWaiting';
  AxdstSrfAnswer                    = 'rfAnswer';
  AxdstSrf1SendCSI                  = 'rf1SendCSI';
  AxdstSrf1SendDIS                  = 'rf1SendDIS';
  AxdstSrf1CollectFrames            = 'rf1CollFrms';
  AxdstSrf1CollectRetry1            = 'rf1CollRtry1';
  AxdstSrf1CollectRetry2            = 'rf1CollRtry2';
  AxdstSrf1StartTrain               = 'rf1StrtTrn';
  AxdstSrf1CollectTrain             = 'rf1CollTrn';
  AxdstSrf1Timeout                  = 'rf1Timeout';
  AxdstSrf1Retrain                  = 'rf1Retrain';
  AxdstSrf1FinishTrain              = 'rf1FinTrn';
  AxdstSrf1SendCFR                  = 'rf1SendCFR';
  AxdstSrf1WaitPageConnect          = 'rf1WtPgCnnct';
  AxdstSrf2ValidConnect             = 'rf2ValCnnct';
  AxdstSrf2GetSenderID              = 'rf2GtSndID';
  AxdstSrf2GetConnect               = 'rf2GtCnnct';
  AxdstSrfStartPage                 = 'rfStartPage';
  AxdstSrfGetPageData               = 'rfGtPgDta';
  AxdstSrf1FinishPage               = 'rf1FinPage';
  AxdstSrf1WaitEOP                  = 'rf1WaitEOP';
  AxdstSrf1WritePage                = 'rf1WritePage';
  AxdstSrf1SendMCF                  = 'rf1SendMCF';
  AxdstSrf1WaitDCN                  = 'rf1WaitDCN';
  AxdstSrf1WaitHangup               = 'rf1WtHngp';
  AxdstSrf2GetPageResult            = 'rf2GtPgRslt';
  AxdstSrf2GetFHNG                  = 'rf2GetFHNG';
  AxdstSrfComplete                  = 'rfComplete';
  AxdstSrfAbort                     = 'rfAbort';
  AxdstSrfDone                      = 'rfDone';
  AxdstStxInitial                   = 'txInitial';
  AxdstStxHandshake                 = 'txHandshake';
  AxdstStxGetBlock                  = 'txGetBlock';
  AxdstStxWaitFreeSpace             = 'txWtFreeSpc';
  AxdstStxSendBlock                 = 'txSendBlock';
  AxdstStxDraining                  = 'txDraining';
  AxdstStxReplyPending              = 'txRplyPnding';
  AxdstStxEndDrain                  = 'txEndDrain';
  AxdstStxFirstEndOfTransmit        = 'txFirstEOT';
  AxdstStxRestEndOfTransmit         = 'txRestEOT';
  AxdstStxEotReply                  = 'txEotReply';
  AxdstStxFinished                  = 'txFinished';
  AxdstStxDone                      = 'txDone';
  AxdstSrxInitial                   = 'rxInitial';
  AxdstSrxWaitForHSReply            = 'rxWtFrHSRply';
  AxdstSrxWaitForBlockStart         = 'rxWtFrBlStrt';
  AxdstSrxCollectBlock              = 'rxCollBlock';
  AxdstSrxProcessBlock              = 'rxProcBlck';
  AxdstSrxFinishedSkip              = 'rxFinSkip';
  AxdstSrxFinished                  = 'rxFinished';
  AxdstSrxDone                      = 'rxDone';
  AxdstStyInitial                   = 'tyInitial';
  AxdstStyHandshake                 = 'tyHandshake';
  AxdstStyGetFileName               = 'tyGetFlName';
  AxdstStySendFileName              = 'tySndFlName';
  AxdstStyDraining                  = 'tyDraining';
  AxdstStyReplyPending              = 'tyRplyPndng';
  AxdstStyPrepXmodem                = 'tyPrpXmdm';
  AxdstStySendXmodem                = 'tySndXmdm';
  AxdstStyFinished                  = 'tyFinishd';
  AxdstStyFinishDrain               = 'tyFinDrain';
  AxdstStyDone                      = 'tyDone';
  AxdstSryInitial                   = 'ryInitial';
  AxdstSryDelay                     = 'ryDelay';
  AxdstSryWaitForHSReply            = 'ryWtFrHSRply';
  AxdstSryWaitForBlockStart         = 'ryWtFBlkStrt';
  AxdstSryCollectBlock              = 'ryCollBlck';
  AxdstSryProcessBlock              = 'ryProcBlck';
  AxdstSryOpenFile                  = 'ryOpenFile';
  AxdstSryPrepXmodem                = 'ryPrepXmdm';
  AxdstSryReceiveXmodem             = 'ryRcvXmodem';
  AxdstSryFinished                  = 'ryFinished';
  AxdstSryDone                      = 'ryDone';
  AxdstStzInitial                   = 'tzInitial';
  AxdstStzHandshake                 = 'tzHandshake';
  AxdstStzGetFile                   = 'tzGetFile';
  AxdstStzSendFile                  = 'tzSendFile';
  AxdstStzCheckFile                 = 'tzCheckFile';
  AxdstStzStartData                 = 'tzStartData';
  AxdstStzEscapeData                = 'tzEscapeData';
  AxdstStzSendData                  = 'tzSendData';
  AxdstStzWaitAck                   = 'tzWaitAck';
  AxdstStzSendEof                   = 'tzSendEof';
  AxdstStzDrainEof                  = 'tzDrainEof';
  AxdstStzCheckEof                  = 'tzCheckEof';
  AxdstStzSendFinish                = 'tzSendFinish';
  AxdstStzCheckFinish               = 'tzChkFinish';
  AxdstStzError                     = 'tzError';
  AxdstStzCleanup                   = 'tzCleanup';
  AxdstStzDone                      = 'tzDone';
  AxdstSrzRqstFile                  = 'rzRqstFile';
  AxdstSrzDelay                     = 'rzDelay';
  AxdstSrzWaitFile                  = 'rzWaitFile';
  AxdstSrzCollectFile               = 'rzCollFile';
  AxdstSrzSendInit                  = 'rzSendInit';
  AxdstSrzSendBlockPrep             = 'rzSndBlkPrp';
  AxdstSrzSendBlock                 = 'rzSendBlock';
  AxdstSrzSync                      = 'rzSync';
  AxdstSrzStartFile                 = 'rzStartFile';
  AxdstSrzStartData                 = 'rzStartData';
  AxdstSrzCollectData               = 'rzCollData';
  AxdstSrzGotData                   = 'rzGotData';
  AxdstSrzWaitEof                   = 'rzWaitEof';
  AxdstSrzEndOfFile                 = 'rzEndOfFile';
  AxdstSrzSendFinish                = 'rzSendFinish';
  AxdstSrzCollectFinish             = 'rzCollFin';
  AxdstSrzError                     = 'rzError';
  AxdstSrzWaitCancel                = 'rzWaitCancel';
  AxdstSrzCleanup                   = 'rzCleanup';
  AxdstSrzDone                      = 'rzDone';
  AxdstStkInit                      = 'tkInit';
  AxdstStkInitReply                 = 'tkInitReply';
  AxdstStkCollectInit               = 'tkCollInit';
  AxdstStkOpenFile                  = 'tkOpenFile';
  AxdstStkSendFile                  = 'tkSendFile';
  AxdstStkFileReply                 = 'tkFileReply';
  AxdstStkCollectFile               = 'tkCollFile';
  AxdstStkCheckTable                = 'tkCheckTable';
  AxdstStkSendData                  = 'tkSendData';
  AxdstStkBlockReply                = 'tkBlockReply';
  AxdstStkCollectBlock              = 'tkCollBlock';
  AxdstStkSendEof                   = 'tkSendEof';
  AxdstStkEofReply                  = 'tkEofReply';
  AxdstStkCollectEof                = 'tkCollectEof';
  AxdstStkSendBreak                 = 'tkSendBreak';
  AxdstStkBreakReply                = 'tkBreakReply';
  AxdstStkCollectBreak              = 'tkCollBreak';
  AxdstStkComplete                  = 'tkComplete';
  AxdstStkWaitCancel                = 'tkWaitCancel';
  AxdstStkError                     = 'tkError';
  AxdstStkDone                      = 'tkDone';
  AxdstSrkInit                      = 'rkInit';
  AxdstSrkGetInit                   = 'rkGetInit';
  AxdstSrkCollectInit               = 'rkCollInit';
  AxdstSrkGetFile                   = 'rkGetFile';
  AxdstSrkCollectFile               = 'rkCollFile';
  AxdstSrkGetData                   = 'rkGetData';
  AxdstSrkCollectData               = 'rkCollData';
  AxdstSrkComplete                  = 'rkComplete';
  AxdstSrkWaitCancel                = 'rkWaitCancel';
  AxdstSrkError                     = 'rkError';
  AxdstSrkDone                      = 'rkDone';
  AxdstStaInitial                   = 'taInitial';
  AxdstStaGetBlock                  = 'taGetBlock';
  AxdstStaWaitFreeSpace             = 'taWaitFrSpc';
  AxdstStaSendBlock                 = 'taSendBlock';
  AxdstStaSendDelay                 = 'taSendDelay';
  AxdstStaFinishDrain               = 'taFinDrain';
  AxdstStaFinished                  = 'taFinished';
  AxdstStaDone                      = 'taDone';
  AxdstSraInitial                   = 'raInitial';
  AxdstSraCollectBlock              = 'raCollBlock';
  AxdstSraProcessBlock              = 'raProcBlock';
  AxdstSraFinished                  = 'raFinished';
  AxdstSraDone                      = 'raDone';
  AxdstSEnable                      = 'Enable';
  AxdstSDisable                     = 'Disable';
  AxdstSStringPacket                = 'StringPacket';
  AxdstSSizePacket                  = 'SizePacket';
  AxdstSPacketTimeout               = 'PcktTimeout';
  AxdstSStartStr                    = 'StartStr';
  AxdstSEndStr                      = 'EndStr';
  AxdstSIdle                        = 'Idle';
  AxdstSWaiting                     = 'Waiting';
  AxdstSCollecting                  = 'Collecting';

// Debug log entries for scripting

  AxSLogScriptFileLoaded            = 'Script file %s loaded ';
  AxSLogScriptEnterAllTriggers      = 'Entering AllTriggers %s %d %d';
  AxSLogScriptTimeoutTrigger        = 'Got timeout trigger';
  AxSLogScriptDataTrigger           = 'Got data trigger';
  AxSLogScriptLeavingAllTriggers    = 'Leaving AllTriggers';
  AxSLogScriptCommand               = 'Index: %d  Command: %s %s %s %s';
  AxSLogScriptMatched               = '  Matched ';
  AxSLogScriptNotMatched            = '  not matched ';
  AxSLogScriptEnterProcessTillWait  = 'Entering ProcessTillWait';
  AxSLogScriptScriptFinished        = 'Script is finished';
  AxSLogScriptExitProcessTillWait   = 'Leaving ProcessTillWait %d';
  AxSLogScriptEnterStartScript      = 'Entering StartScript';
  AxSLogScriptLeaveStartScript      = 'Leaving StartScript';

//  headings

  AxSHeader1                        = 'Time      Type      SubType       Data      OtherData';
  AxSHeader2                        = '--------  --------  ------------  --------  ---------';

// modem tags

  AxSMsTag1                         = 'DCTS ';
  AxSMsTag2                         = 'DDSR ';
  AxSMsTag3                         = 'TERI ';
  AxSMsTag4                         = 'DDCD ';
  AxSMsTag5                         = 'CTS ';
  AxSMsTag6                         = 'DSR ';
  AxSMsTag7                         = 'RI ';
  AxSMsTag8                         = 'DCD ';

// Telnet tags
  AxSTelent0                        = 'Binary';
  AxSTelent1                        = 'Echo';
  AxSTelent2                        = 'Reconnection';
  AxSTelent3                        = 'Supress Go Ahead';
  AxSTelent4                        = 'Approx Msg Size';
  AxSTelent5                        = 'Status';
  AxSTelent6                        = 'Timing Mark';
  AxSTelent7                        = 'Remote Trans & Echo';
  AxSTelent8                        = 'Output Line Width';
  AxSTelent9                        = 'Output Page Size';
  AxSTelent10                       = 'Output C/R Disp';
  AxSTelent11                       = 'Output Horz Tabs';
  AxSTelent12                       = 'Output Horz Tab Disp';
  AxSTelent13                       = 'Output FF Disp';
  AxSTelent14                       = 'Output Vert Tabs';
  AxSTelent15                       = 'Output Vert Tab Disp';
  AxSTelent16                       = 'Output Linefeed Disp';
  AxSTelent17                       = 'Extended ASCII';
  AxSTelent18                       = 'Logout';
  AxSTelent19                       = 'Byte Macro';
  AxSTelent20                       = 'Data Entry Terminal';
  AxSTelent21                       = 'SUPDUP';
  AxSTelent22                       = 'SUPDUP Output';
  AxSTelent23                       = 'Send Location';
  AxSTelent24                       = 'Terminal Type';
  AxSTelent25                       = 'End of Record';
  AxSTelent26                       = 'TACACS User ID';
  AxSTelent27                       = 'Output Marking';
  AxSTelent28                       = 'Terminal Loc Num';
  AxSTelent29                       = 'Telnet3270 Regime';
  AxSTelent30                       = 'X.3 PAD';
  AxSTelent31                       = 'Neg Window Size';
  AxSTelent32                       = 'Terminal Speed';
  AxSTelent33                       = 'Flow Control';
  AxSTelent34                       = 'LineMode';
  AxSTelent35                       = 'X Display Location';
  AxSTelent36                       = 'Environment';
  AxSTelent37                       = 'Authentication';
  AxSTelent38                       = 'Telnet code 38';
  AxSTelent39                       = 'New Environment';
  AxSTelent40                       = 'Telnet code 40';
  AxSTelent41                       = 'Telnet code 41';
  AxSTelent42                       = 'Character Set';

const

  AxecOK                           = 0;
  AxecFileNotFound                 = 2;
  AxecPathNotFound                 = 3;
  AxecTooMayFiles                  = 4;
  AxecAccessDenied                 = 5;
  AxecInvalidHandle                = 6;
  AxecOutOfMemory                  = 8;
  AxecInvalidDrive                 = 15;
  AxecNoMoreFiles                  = 18;

  AxecDiskRead                     = 100;
  AxecDiskFull                     = 101;
  AxecNotAssigned                  = 102;
  AxecNotOpen                      = 103;
  AxecNotOpenInput                 = 104;
  AxecNotOpenOutput                = 105;
  AxecWriteProtected               = 150;
  AxecUnknownUnit                  = 151;
  AxecDriveNotReady                = 152;
  AxecUnknownCommand               = 153;
  AxecCrcError                     = 154;
  AxecBadStructLen                 = 155;
  AxecSeekError                    = 156;
  AxecUnknownMedia                 = 157;
  AxecSectorNotFound               = 158;
  AxecOutOfPaper                   = 159;
  AxecDeviceWrite                  = 160;
  AxecDeviceRead                   = 161;
  AxecHardwareFailure              = 162;

  AxecBadHandle                    = 1001;
  AxecBadArgument                  = 1002;
  AxecGotQuitMsg                   = 1003;
  AxecBufferTooBig                 = 1004;
  AxecPortNotAssigned              = 1005;
  AxecInternal                     = 1006;
  AxecModemNotAssigned             = 1007;
  AxecPhonebookNotAssigned         = 1008;
  AxecCannotUseWithWinSock         = 1009;

  AxecBadId                        = 2001;
  AxecBaudRate                     = 2002;
  AxecByteSize                     = 2003;
  AxecDefault                      = 2004;
  AxecHardware                     = 2005;
  AxecMemory                       = 2006;
  AxecCommNotOpen                  = 2007;
  AxecAlreadyOpen                  = 2008;
  AxecNoHandles                    = 2009;
  AxecNoTimers                     = 2010;
  AxecNoPortSelected               = 2011;
  AxecNotOpenedByTapi              = 2012;

  AxecNullApi                      = 3001;
  AxecNotSupported                 = 3002;
  AxecRegisterHandlerFailed        = 3003;
  AxecPutBlockFail                 = 3004;
  AxecGetBlockFail                 = 3005;
  AxecOutputBufferTooSmall         = 3006;
  AxecBufferIsEmpty                = 3007;
  AxecTracingNotEnabled            = 3008;
  AxecLoggingNotEnabled            = 3009;
  AxecBaseAddressNotSet            = 3010;

  AxecModemNotStarted              = 4001;
  AxecModemBusy                    = 4002;
  AxecModemNotDialing              = 4003;
  AxecNotDialing                   = 4004;
  AxecAlreadyDialing               = 4005;
  AxecModemNotResponding           = 4006;
  AxecModemRejectedCommand         = 4007;
  AxecModemStatusMismatch          = 4008;

// PhonebookEditor strings -- constants in ADPBEDIT.PAS

  AxpeDeleteQuery                  = 4101;

// Simple Modem strings -- constants in ADSMODEM.PAS

  AxsmMsgReady                     = 4201;
  AxsmMsgInitialize                = 4202;
  AxsmMsgInitializeTimeout         = 4203;
  AxsmAutoAnswerBackground         = 4204;
  AxsmAutoAnswerWait               = 4205;
  AxsmAnswerWait                   = 4206;
  AxsmDialWait                     = 4207;
  AxsmDialCycle                    = 4208;
  AxsmNoDialtone                   = 4209;
  AxsmConnectWait                  = 4210;
  AxsmConnected                    = 4211;
  AxsmHangup                       = 4212;
  AxsmCancel                       = 4213;

// Dialer strings -- constants in ADDIAL.PAS

  AxddCycling                      = 4301;
  AxddRetryWaiting                 = 4302;
  AxddRetryWaitOver                = 4303;
  AxddDialing                      = 4304;
  AxddModemConnect                 = 4305;
  AxddModemConnectAt               = 4306;
  AxddModemVoice                   = 4307;
  AxddModemError                   = 4308;
  AxddModemNoCarrier               = 4309;
  AxddModemBusy                    = 4310;
  AxddModemNoDialTone              = 4311;
  AxddDialTimedOut                 = 4312;

// Phonebook entry strings -- constants in ADPENTRY.PAS

  AxpeMustEnterName                = 4401;
  AxpeMustEnterNumber              = 4402;
  AxpeNameExists                   = 4403;

// RAS component strings -- constants in ADRASUTL.PAS

  AxcsOpenPort                     = 4500;
  AxcsPortOpened                   = 4501;
  AxcsConnectDevice                = 4502;
  AxcsDeviceConnected              = 4503;
  AxcsAllDevicesConnected          = 4504;
  AxcsAuthenticate                 = 4505;
  AxcsAuthNotify                   = 4506;
  AxcsAuthRetry                    = 4507;
  AxcsAuthCallback                 = 4508;
  AxcsAuthChangePassword           = 4509;
  AxcsAuthProject                  = 4510;
  AxcsAuthLinkSpeed                = 4511;
  AxcsAuthAck                      = 4512;
  AxcsReAuthenticate               = 4513;
  AxcsAuthenticated                = 4514;
  AxcsPrepareForCallback           = 4515;
  AxcsWaitForModemReset            = 4516;
  AxcsWaitForCallback              = 4517;
  AxcsProjected                    = 4518;
  AxcsStartAuthentication          = 4519;
  AxcsCallbackComplete             = 4520;
  AxcsLogonNetwork                 = 4521;
  AxcsSubEntryConnected            = 4522;
  AxcsSubEntryDisconnected         = 4523;

  AxcsInteractive                  = 4550;
  AxcsRetryAuthentication          = 4551;
  AxcsCallbackSetByCaller          = 4552;
  AxcsPasswordExpired              = 4553;

  AxcsDeviceConnected2             = 4599;

// Paging component strings -- constants in ADPAGER.PAS

  AxTDS_NONE                       = 4600;
  AxTDS_OFFHOOK                    = 4601;
  AxTDS_DIALING                    = 4602;
  AxTDS_RINGING                    = 4603;
  AxTDS_WAITFORCONNECT             = 4604;
  AxTDS_CONNECTED                  = 4605;
  AxTDS_WAITINGTOREDIAL            = 4606;
  AxTDS_REDIALING                  = 4607;
  AxTDS_MSGNOTSENT                 = 4608;
  AxTDS_CANCELLING                 = 4609;
  AxTDS_DISCONNECT                 = 4610;
  AxTDS_CLEANUP                    = 4611;

  AxTDE_NONE                       = 4630;
  AxTDE_NODIALTONE                 = 4631;
  AxTDE_LINEBUSY                   = 4632;
  AxTDE_NOCONNECTION               = 4633;

  AxTPS_NONE                       = 4660;
  AxTPS_LOGINPROMPT                = 4661;
  AxTPS_LOGGEDIN                   = 4662;
  AxTPS_LOGINERR                   = 4663;
  AxTPS_LOGINFAIL                  = 4664;
  AxTPS_MSGOKTOSEND                = 4665;
  AxTPS_SENDINGMSG                 = 4666;
  AxTPS_MSGACK                     = 4667;
  AxTPS_MSGNAK                     = 4668;
  AxTPS_MSGRS                      = 4669;
  AxTPS_MSGCOMPLETED               = 4670;
  AxTPS_DONE                       = 4671;

// Protocol resource strings
// If strings are added -- apStatusMsg needs to be changed in AWABSPCL.PAS

  AxpsOK                           = 4700;
  AxpsProtocolHandshake            = 4701;
  AxpsInvalidDate                  = 4702;
  AxpsFileRejected                 = 4703;
  AxpsFileRenamed                  = 4704;
  AxpsSkipFile                     = 4705;
  AxpsFileDoesntExist              = 4706;
  AxpsCantWriteFile                = 4707;
  AxpsTimeout                      = 4708;
  AxpsBlockCheckError              = 4709;
  AxpsLongPacket                   = 4710;
  AxpsDuplicateBlock               = 4711;
  AxpsProtocolError                = 4712;
  AxpsCancelRequested              = 4713;
  AxpsEndFile                      = 4714;
  AxpsResumeBad                    = 4715;
  AxpsSequenceError                = 4716;
  AxpsAbortNoCarrier               = 4717;

  AxpsGotCrcE                      = 4718;
  AxpsGotCrcG                      = 4719;
  AxpsGotCrcW                      = 4720;
  AxpsGotCrcQ                      = 4721;
  AxpsTryResume                    = 4722;
  AxpsHostResume                   = 4723;

// Fax resource strings
// If strings are added -- apStatusMsg needs to be changed in AWABSPCL.PAS

  AxfpInitModem                    = 4801;
  AxfpDialing                      = 4802;
  AxfpBusyWait                     = 4803;
  AxfpSendPage                     = 4804;
  AxfpSendPageStatus               = 4805;
  AxfpPageError                    = 4806;
  AxfpPageOK                       = 4807;
  AxfpConnecting                   = 4808;

  AxfpWaiting                      = 4820;
  AxfpNoConnect                    = 4821;
  AxfpAnswer                       = 4822;
  AxfpIncoming                     = 4823;
  AxfpGetPage                      = 4824;
  AxfpGetPageResult                = 4825;
  AxfpCheckMorePages               = 4826;
  AxfpGetHangup                    = 4827;
  AxfpGotHangup                    = 4828;

  AxfpSessionParams                = 4840;
  AxfpGotRemoteID                  = 4841;
  AxfpCancel                       = 4842;
  AxfpFinished                     = 4843;


// Error strings -- constants in OOMISC.INC

  AxecNoMoreTriggers               = 5001;
  AxecTriggerTooLong               = 5002;
  AxecBadTriggerHandle             = 5003;

  AxecStartStringEmpty             = 5501;
  AxecPacketTooSmall               = 5502;
  AxecNoEndCharCount               = 5503;
  AxecEmptyEndString               = 5504;
  AxecZeroSizePacket               = 5505;
  AxecPacketTooLong                = 5506;

  AxecBadFileList                  = 6001;
  AxecNoSearchMask                 = 6002;
  AxecNoMatchingFiles              = 6003;
  AxecDirNotFound                  = 6004;
  AxecCancelRequested              = 6005;
  AxecTimeout                      = 6006;
  AxecProtocolError                = 6007;
  AxecTooManyErrors                = 6008;
  AxecSequenceError                = 6009;
  AxecNoFilename                   = 6010;
  AxecFileRejected                 = 6011;
  AxecCantWriteFile                = 6012;
  AxecTableFull                    = 6013;
  AxecAbortNoCarrier               = 6014;
  AxecBadProtocolFunction          = 6015;

  AxecKeyTooLong                   = 7001;
  AxecDataTooLarge                 = 7002;
  AxecNoFieldsDefined              = 7003;
  AxecIniWrite                     = 7004;
  AxecIniRead                      = 7005;
  AxecNoIndexKey                   = 7006;
  AxecRecordExists                 = 7007;
  AxecRecordNotFound               = 7008;
  AxecMustHaveIdxVal               = 7009;
  AxecDatabaseFull                 = 7010;
  AxecDatabaseEmpty                = 7011;
  AxecDatabaseNotPrepared          = 7012;
  AxecBadFieldList                 = 7013;
  AxecBadFieldForIndex             = 7014;

  AxecFaxBadFormat                 = 8001;
  AxecBadGraphicsFormat            = 8002;
  AxecConvertAbort                 = 8003;
  AxecUnpackAbort                  = 8004;
  AxecCantMakeBitmap               = 8005;
  
  AxecNoImageLoaded                = 8050;
  AxecNoImageBlockMarked           = 8051;
  AxecFontFileNotFound             = 8052;
  AxecInvalidPageNumber            = 8053;
  AxecBmpTooBig                    = 8054;
  AxecEnhFontTooBig                = 8055; 

  AxecFaxBadMachine                = 8060; 
  AxecFaxBadModemResult            = 8061;
  AxecFaxTrainError                = 8062;
  AxecFaxInitError                 = 8063;
  AxecFaxBusy                      = 8064;
  AxecFaxVoiceCall                 = 8065;
  AxecFaxDataCall                  = 8066;
  AxecFaxNoDialTone                = 8067;
  AxecFaxNoCarrier                 = 8068;
  AxecFaxSessionError              = 8069;
  AxecFaxPageError                 = 8070;
  AxecFaxGDIPrintError             = 8071;
  AxecFaxMixedResolution           = 8072;
  AxecFaxConverterInitFail         = 8073;
  AxecNoAnswer                     = 8074;
  AxecAlreadyMonitored             = 8075;

  AxecUniAlreadyInstalled          = 8080;
  AxecUniCannotGetSysDir           = 8081;
  AxecUniCannotGetWinDir           = 8082;
  AxecUniUnknownLayout             = 8083;
  AxecUniCannotParseInfFile        = 8084;
  AxecUniCannotInstallFile         = 8085;
  AxecNotNTDriver                  = 8086;
  AxecDrvCopyError                 = 8087;
  AxecCannotAddPrinter             = 8088;
  AxecDrvBadResources              = 8089;
  AxecDrvDriverNotFound            = 8090;
  AxecUniCannotGetPrinterDriverDir = 8091;
  AxecInstallDriverFailed          = 8092;

  // Additional AxPackEd errors     8300-8399

  AxecPackEdMismatchedQuote        = 8300;
  AxecPackEdNumberExpected         = 8301;
  AxecPackEdNumberOutOfRange       = 8302;
  AxecPackEdHex0String             = 8303;
  AxecPackEdAlphaExpected          = 8304;

  // Additional AxTrmEmu Errors     8400-8499

  AxecTrmEmuNotEnoughData          = 8400;

  // Additional AxTrmBuf Errors     8500-8599

  AxecTrmBufDelItemsRangeErr       = 8500;
  AxecTrmBufGetItemPtrRangeErr     = 8501;
  AxecTrmBufGetItemPtrSizeErr      = 8502;
  AxecTrmBufInsertItemRangeErr     = 8503;
  AxecTrmBufScrollRowRangeErr      = 8504;
  AxecTrmBufColCountTooLow1        = 8505;
  AxecTrmBufColCountTooLow2        = 8506;
  AxecTrmBufWriteDupItemsRange     = 8507;
  AxecTrmBufWriteItemsRangeErr     = 8508;
  AxecTrmBufDeleteCharTooLow       = 8509;
  AxecTrmBufDeleteLinesTooLow      = 8510;
  AxecTrmBufEraseCharsCount        = 8511;
  AxecTrmBufGetLineAttPtrRange     = 8512;
  AxecTrmBufGetLineBackColorRng    = 8513;
  AxecTrmBufGetLineCharPtrRange    = 8514;
  AxecTrmBufGetLineCharSetRange    = 8515;
  AxecTrmBufGetLineForeColorRng    = 8516;
  AxecTrmBufInsertCharsCount       = 8517;
  AxecTrmBufInsertLinesCount       = 8518;
  AxecTrmBufScrollRgnRowNum        = 8519;
  AxecTrmBufColCountTooSmall       = 8520;
  AxecTrmBufSetRowCountTooSmall    = 8521;
  AxecTrmBufSetSVRowCountToSmall   = 8522;

  // Additional AxPager Error       8600-8699

  AxecPagerUnableToFreeTrigger     = 8600;
  AxecPagerNoComport               = 8601;
  AxecPagerNoSuchTriggerType       = 8602;

  // Additional AxWin32 Errors      8700-8799

  AxecWin32DispatcherStarted       = 8700;

// APRO-specfic error constants are found in ADSOCKET.PAS

  AxADWSEERROR                     = 9001;
  AxADWSLOADERROR                  = 9002;
  AxADWSVERSIONERROR               = 9003;
  AxADWSNOTINIT                    = 9004;
  AxADWSINVPORT                    = 9005;
  AxADWSCANTCHANGE                 = 9006;
  AxADWSCANTRESOLVE                = 9007;

// Standard Winsock error constants are found in ADWUTIL.PAS

  AxwsaEIntr                       = 10004;
  AxwsaEBadF                       = 10009;
  AxwsaEAcces                      = 10013;
  AxwsaEFault                      = 10014;
  AxwsaEInVal                      = 10022;
  AxwsaEMFile                      = 10024;

  AxwsaEWouldBlock                 = 10035;
  AxwsaEInProgress                 = 10036;
  AxwsaEAlReady                    = 10037;
  AxwsaENotSock                    = 10038;
  AxwsaEDestAddrReq                = 10039;
  AxwsaEMsgSize                    = 10040;
  AxwsaEPrototype                  = 10041;
  AxwsaENoProtoOpt                 = 10042;
  AxwsaEProtoNoSupport             = 10043;
  AxwsaESocktNoSupport             = 10044;
  AxwsaEOpNotSupp                  = 10045;
  AxwsaEPfNoSupport                = 10046;
  AxwsaEAfNoSupport                = 10047;
  AxwsaEAddrInUse                  = 10048;
  AxwsaEAddrNotAvail               = 10049;        
  AxwsaENetDown                    = 10050;
  AxwsaENetUnreach                 = 10051;
  AxwsaENetReset                   = 10052;
  AxwsaEConnAborted                = 10053;
  AxwsaEConnReset                  = 10054;
  AxwsaENoBufs                     = 10055;
  AxwsaEIsConn                     = 10056;
  AxwsaENotConn                    = 10057;
  AxwsaEShutDown                   = 10058;
  AxwsaETooManyRefs                = 10059; 
  AxwsaETimedOut                   = 10060;
  AxwsaEConnRefused                = 10061;
  AxwsaELoop                       = 10062;
  AxwsaENameTooLong                = 10063;
  AxwsaEHostDown                   = 10064;
  AxwsaEHostUnreach                = 10065;
  AxwsaENotEmpty                   = 10066;
  AxwsaEProcLim                    = 10067;
  AxwsaEUsers                      = 10068;
  AxwsaEDQuot                      = 10069;
  AxwsaEStale                      = 10070;
  AxwsaERemote                     = 10071;

  { Extended Windows Sockets error constant definitions }

  AxwsaSysNotReady                 = 10091;
  AxwsaVerNotSupported             = 10092;
  AxwsaNotInitialised              = 10093;
  
  AxwsaEDiscOn                     = 10101;

  AxwsaHost_Not_Found              = 11001;
  AxwsaTry_Again                   = 11002;
  AxwsaNo_Recovery                 = 11003;
  AxwsaNo_Data                     = 11004; 

// TAPI Line Call State Messages -- See ADTUTIL & ADTAPI

  AxTapiLineCallState1             = 13501;
  AxTapiLineCallState2             = 13502;
  AxTapiLineCallState3             = 13503;
  AxTapiLineCallState4             = 13504;
  AxTapiLineCallState5             = 13505;
  AxTapiLineCallState6             = 13506;
  AxTapiLineCallState7             = 13507;
  AxTapiLineCallState8             = 13508;
  AxTapiLineCallState9             = 13509;
  AxTapiLineCallState10            = 13510;
  AxTapiLineCallState11            = 13511;
  AxTapiLineCallState12            = 13512;
  AxTapiLineCallState13            = 13513;
  AxTapiLineCallState14            = 13514;
  AxTapiLineCallState15            = 13515;
  AxTapiLineCallState16            = 13516;

// TAPI Line Device State Messages -- See ADTUTIL & ADTAPI

  AxTapiLineDeviceState33          = 13533;
  AxTapiLineDeviceState34          = 13534;
  AxTapiLineDeviceState35          = 13535;
  AxTapiLineDeviceState36          = 13536;
  AxTapiLineDeviceState37          = 13537;
  AxTapiLineDeviceState38          = 13538;
  AxTapiLineDeviceState39          = 13539;
  AxTapiLineDeviceState40          = 13540;
  AxTapiLineDeviceState41          = 13541;
  AxTapiLineDeviceState42          = 13542;
  AxTapiLineDeviceState43          = 13543;
  AxTapiLineDeviceState44          = 13544;
  AxTapiLineDeviceState45          = 13545;
  AxTapiLineDeviceState46          = 13546;
  AxTapiLineDeviceState47          = 13547;
  AxTapiLineDeviceState48          = 13548;
  AxTapiLineDeviceState49          = 13549;
  AxTapiLineDeviceState50          = 13550;
  AxTapiLineDeviceState51          = 13551;
  AxTapiLineDeviceState52          = 13552;
  AxTapiLineDeviceState53          = 13553;
  AxTapiLineDeviceState54          = 13554;
  AxTapiLineDeviceState55          = 13555;
  AxTapiLineDeviceState56          = 13556;
  AxTapiLineDeviceState57          = 13557;
  
  AxTapiLineDeviceState65          = 13565;

  AxTapiLineDeviceState97          = 13597;
  AxTapiLineDeviceState98          = 13598;
  AxTapiLineDeviceState99          = 13599;
  AxTapiLineDeviceState100         = 13600;
  AxTapiLineDeviceState101         = 13601;

// TAPI Disconnect messages

  AxTapiDisconnect01               = 13650;
  AxTapiDisconnect02               = 13651;
  AxTapiDisconnect03               = 13652;
  AxTapiDisconnect04               = 13653;
  AxTapiDisconnect05               = 13654;
  AxTapiDisconnect06               = 13655;
  AxTapiDisconnect07               = 13656;
  AxTapiDisconnect08               = 13657;
  AxTapiDisconnect09               = 13658;
  AxTapiDisconnect10               = 13659;
  AxTapiDisconnect11               = 13660;
  AxTapiDisconnect12               = 13661;
  AxTapiDisconnect13               = 13662;
  AxTapiDisconnect14               = 13663;
  AxTapiDisconnect15               = 13664;
  AxTapiDisconnect16               = 13665;
  AxTapiDisconnect17               = 13666;
  AxTapiDisconnect18               = 13667;
  AxTapiDisconnect19               = 13668;
  AxTapiDisconnect20               = 13669;
  AxTapiDisconnect21               = 13670;

// TAPI Error messages -- See OOMISC.INC, ADTUTIL & ADTAPI

  AxecAllocated                    = 13801;
  AxecBadDeviceID                  = 13802;
  AxecBearerModeUnavail            = 13803;
  AxecCallUnavail                  = 13805;
  AxecCompletionOverrun            = 13806;
  AxecConferenceFull               = 13807;
  AxecDialBilling                  = 13808;
  AxecDialDialtone                 = 13809;
  AxecDialPrompt                   = 13810;
  AxecDialQuiet                    = 13811;
  AxecIncompatibleApiVersion       = 13812;
  AxecIncompatibleExtVersion       = 13813;
  AxecIniFileCorrupt               = 13814;
  AxecInUse                        = 13815;
  AxecInvalAddress                 = 13816;
  AxecInvalAddressID               = 13817;
  AxecInvalAddressMode             = 13818;
  AxecInvalAddressState            = 13819;
  AxecInvalAppHandle               = 13820;
  AxecInvalAppName                 = 13821;
  AxecInvalBearerMode              = 13822;
  AxecInvalCallComplMode           = 13823;
  AxecInvalCallHandle              = 13824; 
  AxecInvalCallParams              = 13825;
  AxecInvalCallPrivilege           = 13826;
  AxecInvalCallSelect              = 13827;
  AxecInvalCallState               = 13828;
  AxecInvalCallStatelist           = 13829;
  AxecInvalCard                    = 13830;
  AxecInvalCompletionID            = 13831;
  AxecInvalConfCallHandle          = 13832;
  AxecInvalConsultCallHandle       = 13833;
  AxecInvalCountryCode             = 13834;
  AxecInvalDeviceClass             = 13835;
  AxecInvalDeviceHandle            = 13836;
  AxecInvalDialParams              = 13837;
  AxecInvalDigitList               = 13838;
  AxecInvalDigitMode               = 13839;
  AxecInvalDigits                  = 13840;
  AxecInvalExtVersion              = 13841;
  AxecInvalGroupID                 = 13842;
  AxecInvalLineHandle              = 13843;
  AxecInvalLineState               = 13844;
  AxecInvalLocation                = 13845;
  AxecInvalMediaList               = 13846;
  AxecInvalMediaMode               = 13847;
  AxecInvalMessageID               = 13848;
  AxecInvalParam                   = 13850;
  AxecInvalParkID                  = 13851;
  AxecInvalParkMode                = 13852;
  AxecInvalPointer                 = 13853;
  AxecInvalPrivSelect              = 13854;
  AxecInvalRate                    = 13855;
  AxecInvalRequestMode             = 13856;
  AxecInvalTerminalID              = 13857;
  AxecInvalTerminalMode            = 13858;
  AxecInvalTimeout                 = 13859;
  AxecInvalTone                    = 13860;
  AxecInvalToneList                = 13861;
  AxecInvalToneMode                = 13862;
  AxecInvalTransferMode            = 13863;
  AxecLineMapperFailed             = 13864;
  AxecNoConference                 = 13865;
  AxecNoDevice                     = 13866;
  AxecNoDriver                     = 13867;
  AxecNoMem                        = 13868;
  AxecNoRequest                    = 13869;
  AxecNotOwner                     = 13870;
  AxecNotRegistered                = 13871;
  AxecOperationFailed              = 13872;
  AxecOperationUnavail             = 13873;
  AxecRateUnavail                  = 13874;
  AxecResourceUnavail              = 13875;
  AxecRequestOverrun               = 13876;
  AxecStructureTooSmall            = 13877;
  AxecTargetNotFound               = 13878;
  AxecTargetSelf                   = 13879;
  AxecUninitialized                = 13880;
  AxecUserUserInfoTooBig           = 13881;
  AxecReinit                       = 13882;
  AxecAddressBlocked               = 13883;
  AxecBillingRejected              = 13884;
  AxecInvalFeature                 = 13885;
  AxecNoMultipleInstance           = 13886;

// Apro-specific TAPI messages -- see OOMISC.INC & ADTAPI.PAS

  AxecTapiBusy                     = 13928;
  AxecTapiNotSet                   = 13929;
  AxecTapiNoSelect                 = 13930;
  AxecTapiLoadFail                 = 13931;
  AxecTapiGetAddrFail              = 13932;
  AxecTapi16Disabled               = 13933;
  AxecTapiUnexpected               = 13934;
  AxecTapiVoiceNotSupported        = 13935;
  AxecTapiWaveFail                 = 13936;
  AxecTapiCIDBlocked               = 13937;
  AxecTapiCIDOutOfArea             = 13938;
  AxecTapiWaveFormatError          = 13939;
  AxecTapiWaveReadError            = 13940;
  AxecTapiWaveBadFormat            = 13941;
  AxecTapiTranslateFail            = 13942;
  AxecTapiWaveDeviceInUse          = 13943;
  AxecTapiWaveFileExists           = 13944;
  AxecTapiWaveNoData               = 13945; 

// Apro-specific RAS messages -- see OOMISC.INC & ADRASUTL.PAS

  AxecRasLoadFail                  = 13980;

// Logging (15xxx)

// Main categories

  AxdtNone                         = 15001;
  AxdtDispatch                     = 15002;
  AxdtTrigger                      = 15003;
  AxdtError                        = 15004;
  AxdtThread                       = 15005;
  AxdtTriggerAlloc                 = 15006;
  AxdtTriggerDispose               = 15007;
  AxdtTriggerHandlerAlloc          = 15008;
  AxdtTriggerHandlerDispose        = 15009;
  AxdtTriggerDataChange            = 15010;
  AxdtTelnet                       = 15011;
  AxdtFax                          = 15012;
  AxdtXModem                       = 15013;
  AxdtYModem                       = 15014;
  AxdtZModem                       = 15015;
  AxdtKermit                       = 15016;
  AxdtAscii                        = 15017;
  AxdtBPlus                        = 15018;
  AxdtPacket                       = 15019;
  AxdtUser                         = 15020;
  AxdtScript                       = 15021;

// Sub categories

  AxdstNone                        = 15100;
  AxdstReadCom                     = 15101;
  AxdstWriteCom                    = 15102;
  AxdstLineStatus                  = 15103;
  AxdstModemStatus                 = 15104;
  AxdstAvail                       = 15105;
  AxdstTimer                       = 15106;
  AxdstData                        = 15107;
  AxdstStatus                      = 15108;
  AxdstThreadStart                 = 15109;
  AxdstThreadExit                  = 15110;
  AxdstThreadSleep                 = 15111;
  AxdstThreadWake                  = 15112;
  AxdstDataTrigger                 = 15113;
  AxdstTimerTrigger                = 15114;
  AxdstStatusTrigger               = 15115;
  AxdstAvailTrigger                = 15116;
  AxdstWndHandler                  = 15117;
  AxdstProcHandler                 = 15118;
  AxdstEventHandler                = 15119;
  AxdstSWill                       = 15120;
  AxdstSWont                       = 15121;
  AxdstSDo                         = 15122;
  AxdstSDont                       = 15123;
  AxdstRWill                       = 15124;
  AxdstRWont                       = 15125;
  AxdstRDo                         = 15126;
  AxdstRDont                       = 15127;
  AxdstCommand                     = 15128;
  AxdstSTerm                       = 15129;
  AxdsttfNone                      = 15130;
  AxdsttfGetEntry                  = 15131;
  AxdsttfInit                      = 15132;
  Axdsttf1Init1                    = 15133;
  Axdsttf2Init1                    = 15134;
  Axdsttf2Init1A                   = 15135;
  Axdsttf2Init1B                   = 15136;
  Axdsttf2Init2                    = 15137;
  Axdsttf2Init3                    = 15138;
  AxdsttfDial                      = 15139;
  AxdsttfRetryWait                 = 15140;
  Axdsttf1Connect                  = 15141;
  Axdsttf1SendTSI                  = 15142;
  Axdsttf1TSIResponse              = 15143;
  Axdsttf1DCSResponse              = 15144;
  Axdsttf1TrainStart               = 15145;
  Axdsttf1TrainFinish              = 15146;
  Axdsttf1WaitCFR                  = 15147;
  Axdsttf1WaitPageConnect          = 15148;
  Axdsttf2Connect                  = 15149;
  Axdsttf2GetParams                = 15150;
  AxdsttfWaitXon                   = 15151;
  AxdsttfWaitFreeHeader            = 15152;
  AxdsttfSendPageHeader            = 15153;
  AxdsttfOpenCover                 = 15154;
  AxdsttfSendCover                 = 15155;
  AxdsttfPrepPage                  = 15156;
  AxdsttfSendPage                  = 15157;
  AxdsttfDrainPage                 = 15158;
  Axdsttf1PageEnd                  = 15159;
  Axdsttf1PrepareEOP               = 15160;
  Axdsttf1SendEOP                  = 15161;
  Axdsttf1WaitMPS                  = 15162;
  Axdsttf1WaitEOP                  = 15163;
  Axdsttf1WaitMCF                  = 15164;
  Axdsttf1SendDCN                  = 15165;
  Axdsttf1Hangup                   = 15166;
  Axdsttf1WaitHangup               = 15167;
  Axdsttf2SendEOP                  = 15168;
  Axdsttf2WaitFPTS                 = 15169;
  Axdsttf2WaitFET                  = 15170;
  Axdsttf2WaitPageOK               = 15171;
  Axdsttf2SendNewParams            = 15172;
  Axdsttf2NextPage                 = 15173;
  Axdsttf20CheckPage               = 15174;
  AxdsttfClose                     = 15175;
  AxdsttfCompleteOK                = 15176;
  AxdsttfAbort                     = 15177;
  AxdsttfDone                      = 15178;
  AxdstrfNone                      = 15179;
  AxdstrfInit                      = 15180;
  Axdstrf1Init1                    = 15181;
  Axdstrf2Init1                    = 15182;
  Axdstrf2Init1A                   = 15183;
  Axdstrf2Init1B                   = 15184;
  Axdstrf2Init2                    = 15185;
  Axdstrf2Init3                    = 15186;
  AxdstrfWaiting                   = 15187;
  AxdstrfAnswer                    = 15188;
  Axdstrf1SendCSI                  = 15189;
  Axdstrf1SendDIS                  = 15190;
  Axdstrf1CollectFrames            = 15191;
  Axdstrf1CollectRetry1            = 15192;
  Axdstrf1CollectRetry2            = 15193;
  Axdstrf1StartTrain               = 15194;
  Axdstrf1CollectTrain             = 15195;
  Axdstrf1Timeout                  = 15196;
  Axdstrf1Retrain                  = 15197;
  Axdstrf1FinishTrain              = 15198;
  Axdstrf1SendCFR                  = 15199;
  Axdstrf1WaitPageConnect          = 15200;
  Axdstrf2ValidConnect             = 15201;
  Axdstrf2GetSenderID              = 15202;
  Axdstrf2GetConnect               = 15203;
  AxdstrfStartPage                 = 15204;
  AxdstrfGetPageData               = 15205;
  Axdstrf1FinishPage               = 15206;
  Axdstrf1WaitEOP                  = 15207;
  Axdstrf1WritePage                = 15208;
  Axdstrf1SendMCF                  = 15209;
  Axdstrf1WaitDCN                  = 15210;
  Axdstrf1WaitHangup               = 15211;
  Axdstrf2GetPageResult            = 15212;
  Axdstrf2GetFHNG                  = 15213;
  AxdstrfComplete                  = 15214;
  AxdstrfAbort                     = 15215;
  AxdstrfDone                      = 15216;
  AxdsttxInitial                   = 15217;
  AxdsttxHandshake                 = 15218;
  AxdsttxGetBlock                  = 15219;
  AxdsttxWaitFreeSpace             = 15220;
  AxdsttxSendBlock                 = 15221;
  AxdsttxDraining                  = 15222;
  AxdsttxReplyPending              = 15223;
  AxdsttxEndDrain                  = 15224;
  AxdsttxFirstEndOfTransmit        = 15225;
  AxdsttxRestEndOfTransmit         = 15226;
  AxdsttxEotReply                  = 15227;
  AxdsttxFinished                  = 15228;
  AxdsttxDone                      = 15229;
  AxdstrxInitial                   = 15230;
  AxdstrxWaitForHSReply            = 15231;
  AxdstrxWaitForBlockStart         = 15232;
  AxdstrxCollectBlock              = 15233;
  AxdstrxProcessBlock              = 15234;
  AxdstrxFinishedSkip              = 15235;
  AxdstrxFinished                  = 15236;
  AxdstrxDone                      = 15237;
  AxdsttyInitial                   = 15238;
  AxdsttyHandshake                 = 15239;
  AxdsttyGetFileName               = 15240;
  AxdsttySendFileName              = 15241;
  AxdsttyDraining                  = 15242;
  AxdsttyReplyPending              = 15243;
  AxdsttyPrepXmodem                = 15244;
  AxdsttySendXmodem                = 15245;
  AxdsttyFinished                  = 15246;
  AxdsttyFinishDrain               = 15247;
  AxdsttyDone                      = 15248;
  AxdstryInitial                   = 15249;
  AxdstryDelay                     = 15250;
  AxdstryWaitForHSReply            = 15251;
  AxdstryWaitForBlockStart         = 15252;
  AxdstryCollectBlock              = 15253;
  AxdstryProcessBlock              = 15254;
  AxdstryOpenFile                  = 15255;
  AxdstryPrepXmodem                = 15256;
  AxdstryReceiveXmodem             = 15257;
  AxdstryFinished                  = 15258;
  AxdstryDone                      = 15259;
  AxdsttzInitial                   = 15260;
  AxdsttzHandshake                 = 15261;
  AxdsttzGetFile                   = 15262;
  AxdsttzSendFile                  = 15263;
  AxdsttzCheckFile                 = 15264;
  AxdsttzStartData                 = 15265;
  AxdsttzEscapeData                = 15266;
  AxdsttzSendData                  = 15267;
  AxdsttzWaitAck                   = 15268;
  AxdsttzSendEof                   = 15269;
  AxdsttzDrainEof                  = 15270;
  AxdsttzCheckEof                  = 15271;
  AxdsttzSendFinish                = 15272;
  AxdsttzCheckFinish               = 15273;
  AxdsttzError                     = 15274;
  AxdsttzCleanup                   = 15275;
  AxdsttzDone                      = 15276;
  AxdstrzRqstFile                  = 15277;
  AxdstrzDelay                     = 15278;
  AxdstrzWaitFile                  = 15279;
  AxdstrzCollectFile               = 15280;
  AxdstrzSendInit                  = 15281;
  AxdstrzSendBlockPrep             = 15282;
  AxdstrzSendBlock                 = 15283;
  AxdstrzSync                      = 15284;
  AxdstrzStartFile                 = 15285;
  AxdstrzStartData                 = 15286;
  AxdstrzCollectData               = 15287;
  AxdstrzGotData                   = 15288;
  AxdstrzWaitEof                   = 15289;
  AxdstrzEndOfFile                 = 15290;
  AxdstrzSendFinish                = 15291;
  AxdstrzCollectFinish             = 15292;
  AxdstrzError                     = 15293;
  AxdstrzWaitCancel                = 15294;
  AxdstrzCleanup                   = 15295;
  AxdstrzDone                      = 15296;
  AxdsttkInit                      = 15297;
  AxdsttkInitReply                 = 15298;
  AxdsttkCollectInit               = 15299;
  AxdsttkOpenFile                  = 15300;
  AxdsttkSendFile                  = 15301;
  AxdsttkFileReply                 = 15302;
  AxdsttkCollectFile               = 15303;
  AxdsttkCheckTable                = 15304;
  AxdsttkSendData                  = 15305;
  AxdsttkBlockReply                = 15306;
  AxdsttkCollectBlock              = 15307;
  AxdsttkSendEof                   = 15308;
  AxdsttkEofReply                  = 15309;
  AxdsttkCollectEof                = 15310;
  AxdsttkSendBreak                 = 15311;
  AxdsttkBreakReply                = 15312;
  AxdsttkCollectBreak              = 15313;
  AxdsttkComplete                  = 15314;
  AxdsttkWaitCancel                = 15315;
  AxdsttkError                     = 15316;
  AxdsttkDone                      = 15317;
  AxdstrkInit                      = 15319;
  AxdstrkGetInit                   = 15320;
  AxdstrkCollectInit               = 15321;
  AxdstrkGetFile                   = 15322;
  AxdstrkCollectFile               = 15323; 
  AxdstrkGetData                   = 15323;
  AxdstrkCollectData               = 15324;
  AxdstrkComplete                  = 15325;
  AxdstrkWaitCancel                = 15326;
  AxdstrkError                     = 15327;
  AxdstrkDone                      = 15328;
  AxdsttaInitial                   = 15329;
  AxdsttaGetBlock                  = 15330;
  AxdsttaWaitFreeSpace             = 15331;
  AxdsttaSendBlock                 = 15332;
  AxdsttaSendDelay                 = 15333;
  AxdsttaFinishDrain               = 15334;
  AxdsttaFinished                  = 15335;
  AxdsttaDone                      = 15336;
  AxdstraInitial                   = 15337;
  AxdstraCollectBlock              = 15338;
  AxdstraProcessBlock              = 15339;
  AxdstraFinished                  = 15340; 
  AxdstraDone                      = 15341;
  AxdstEnable                      = 15342;
  AxdstDisable                     = 15343;
  AxdstStringPacket                = 15344;
  AxdstSizePacket                  = 15345;
  AxdstPacketTimeout               = 15346;
  AxdstStartStr                    = 15347;
  AxdstEndStr                      = 15348;
  AxdstIdle                        = 15349;
  AxdstWaiting                     = 15350;
  AxdstCollecting                  = 15351;

// Debug log entries for scripting

  AxLogScriptFileLoaded            = 15400;
  AxLogScriptEnterAllTriggers      = 15401;
  AxLogScriptTimeoutTrigger        = 15402;
  AxLogScriptDataTrigger           = 15403;
  AxLogScriptLeavingAllTriggers    = 15404;
  AxLogScriptCommand               = 15405;
  AxLogScriptMatched               = 15406;
  AxLogScriptNotMatched            = 15407;
  AxLogScriptEnterProcessTillWait  = 15408;
  AxLogScriptScriptFinished        = 15409;
  AxLogScriptExitProcessTillWait   = 15410;
  AxLogScriptEnterStartScript      = 15411;
  AxLogScriptLeaveStartScript      = 15412;

//  headings
  AxHeader1                        = 15501;
  AxHeader2                        = 15502;

// modem tags

  AxMsTag1                         = 15601;
  AxMsTag2                         = 15602;
  AxMsTag3                         = 15603;
  AxMsTag4                         = 15604;
  AxMsTag5                         = 15605;
  AxMsTag6                         = 15606;
  AxMsTag7                         = 15607;
  AxMsTag8                         = 15608;

// Telnet tags

  AxTelent0                        = 15700;
  AxTelent1                        = 15701;
  AxTelent2                        = 15702;
  AxTelent3                        = 15703;
  AxTelent4                        = 15704;
  AxTelent5                        = 15705;
  AxTelent6                        = 15706;
  AxTelent7                        = 15707;
  AxTelent8                        = 15708;
  AxTelent9                        = 15709;
  AxTelent10                       = 15710;
  AxTelent11                       = 15711;
  AxTelent12                       = 15712;
  AxTelent13                       = 15713;
  AxTelent14                       = 15714;
  AxTelent15                       = 15715;
  AxTelent16                       = 15716;
  AxTelent17                       = 15717;
  AxTelent18                       = 15718;
  AxTelent19                       = 15719;
  AxTelent20                       = 15720;
  AxTelent21                       = 15721;
  AxTelent22                       = 15722;
  AxTelent23                       = 15723;
  AxTelent24                       = 15724;
  AxTelent25                       = 15725;
  AxTelent26                       = 15726;
  AxTelent27                       = 15727;
  AxTelent28                       = 15728;
  AxTelent29                       = 15729;
  AxTelent30                       = 15730;
  AxTelent31                       = 15731;
  AxTelent32                       = 15732;
  AxTelent33                       = 15732;
  AxTelent34                       = 15733;
  AxTelent35                       = 15734;
  AxTelent36                       = 15735;
  AxTelent37                       = 15736;
  AxTelent38                       = 15737;
  AxTelent39                       = 15739;
  AxTelent40                       = 15740;
  AxTelent41                       = 15741;
  AxTelent42                       = 15742;

const
  AxMaxMessages = 876;

type
  AxMessageNumberLookupRecord = record
    MessageNumber : integer;
    MessageString : string;
  end;

const
  AxMessageNumberLookup : array [1..AxMaxMessages] of AxMessageNumberLookupRecord =
    ((MessageNumber : AxecOK;                           MessageString : AxecSOK),
     (MessageNumber : AxecFileNotFound;                 MessageString : AxecSFileNotFound),
     (MessageNumber : AxecPathNotFound;                 MessageString : AxecSPathNotFound),
     (MessageNumber : AxecTooMayFiles;                  MessageString : AxecSTooMayFiles),
     (MessageNumber : AxecAccessDenied;                 MessageString : AxecSAccessDenied),
     (MessageNumber : AxecInvalidHandle;                MessageString : AxecSInvalidHandle),
     (MessageNumber : AxecOutOfMemory;                  MessageString : AxecSOutOfMemory),
     (MessageNumber : AxecInvalidDrive;                 MessageString : AxecSInvalidDrive),
     (MessageNumber : AxecNoMoreFiles;                  MessageString : AxecSNoMoreFiles),

     (MessageNumber : AxecDiskRead;                     MessageString : AxecSDiskRead),
     (MessageNumber : AxecDiskFull;                     MessageString : AxecSDiskFull),
     (MessageNumber : AxecNotAssigned;                  MessageString : AxecSNotAssigned),
     (MessageNumber : AxecNotOpen;                      MessageString : AxecSNotOpen),
     (MessageNumber : AxecNotOpenInput;                 MessageString : AxecSNotOpenInput),
     (MessageNumber : AxecNotOpenOutput;                MessageString : AxecSNotOpenOutput),
     (MessageNumber : AxecWriteProtected;               MessageString : AxecSWriteProtected),
     (MessageNumber : AxecDriveNotReady;                MessageString : AxecSDriveNotReady),
     (MessageNumber : AxecUnknownCommand;               MessageString : AxecSUnknownCommand),
     (MessageNumber : AxecCrcError;                     MessageString : AxecSCrcError),
     (MessageNumber : AxecBadStructLen;                 MessageString : AxecSBadStructLen),
     (MessageNumber : AxecSeekError;                    MessageString : AxecSSeekError),
     (MessageNumber : AxecUnknownMedia;                 MessageString : AxecSUnknownMedia),
     (MessageNumber : AxecSectorNotFound;               MessageString : AxecSSectorNotFound),
     (MessageNumber : AxecOutOfPaper;                   MessageString : AxecSOutOfPaper),
     (MessageNumber : AxecDeviceWrite;                  MessageString : AxecSDeviceWrite),
     (MessageNumber : AxecDeviceRead;                   MessageString : AxecSDeviceRead),
     (MessageNumber : AxecHardwareFailure;              MessageString : AxecSHardwareFailure),

     (MessageNumber : AxecBadHandle;                    MessageString : AxecSBadHandle),
     (MessageNumber : AxecBadArgument;                  MessageString : AxecSBadArgument),
     (MessageNumber : AxecGotQuitMsg;                   MessageString : AxecSGotQuitMsg),
     (MessageNumber : AxecBufferTooBig;                 MessageString : AxecSBufferTooBig),
     (MessageNumber : AxecPortNotAssigned;              MessageString : AxecSPortNotAssigned),
     (MessageNumber : AxecInternal;                     MessageString : AxecSInternal),
     (MessageNumber : AxecModemNotAssigned;             MessageString : AxecSModemNotAssigned),
     (MessageNumber : AxecPhonebookNotAssigned;         MessageString : AxecSPhonebookNotAssigned),
     (MessageNumber : AxecCannotUseWithWinSock;         MessageString : AxecSCannotUseWithWinSock),

     (MessageNumber : AxecBadId;                        MessageString : AxecSBadId),
     (MessageNumber : AxecBaudRate;                     MessageString : AxecSBaudRate),
     (MessageNumber : AxecByteSize;                     MessageString : AxecSByteSize),
     (MessageNumber : AxecDefault;                      MessageString : AxecSDefault),
     (MessageNumber : AxecHardware;                     MessageString : AxecSHardware),
     (MessageNumber : AxecMemory;                       MessageString : AxecSMemory),
     (MessageNumber : AxecCommNotOpen;                  MessageString : AxecSCommNotOpen),
     (MessageNumber : AxecAlreadyOpen;                  MessageString : AxecSAlreadyOpen),
     (MessageNumber : AxecNoHandles;                    MessageString : AxecSNoHandles),
     (MessageNumber : AxecNoTimers;                     MessageString : AxecSNoTimers),
     (MessageNumber : AxecNoPortSelected;               MessageString : AxecSNoPortSelected),
     (MessageNumber : AxecNotOpenedByTapi;              MessageString : AxecSNotOpenedByTapi),

     (MessageNumber : AxecNullApi;                      MessageString : AxecSNullApi),
     (MessageNumber : AxecNotSupported;                 MessageString : AxecSNotSupported),
     (MessageNumber : AxecRegisterHandlerFailed;        MessageString : AxecSRegisterHandlerFailed),
     (MessageNumber : AxecPutBlockFail;                 MessageString : AxecSPutBlockFail),
     (MessageNumber : AxecGetBlockFail;                 MessageString : AxecSGetBlockFail),
     (MessageNumber : AxecOutputBufferTooSmall;         MessageString : AxecSOutputBufferTooSmall),
     (MessageNumber : AxecBufferIsEmpty;                MessageString : AxecSBufferIsEmpty),
     (MessageNumber : AxecTracingNotEnabled;            MessageString : AxecSTracingNotEnabled),
     (MessageNumber : AxecLoggingNotEnabled;            MessageString : AxecSLoggingNotEnabled),
     (MessageNumber : AxecBaseAddressNotSet;            MessageString : AxecSBaseAddressNotSet),

     (MessageNumber : AxecModemNotStarted;              MessageString : AxecSModemNotStarted),
     (MessageNumber : AxecModemBusy;                    MessageString : AxecSModemBusy),
     (MessageNumber : AxecModemNotDialing;              MessageString : AxecSModemNotDialing),
     (MessageNumber : AxecNotDialing;                   MessageString : AxecSNotDialing),
     (MessageNumber : AxecAlreadyDialing;               MessageString : AxecSAlreadyDialing),
     (MessageNumber : AxecModemNotResponding;           MessageString : AxecSModemNotResponding),
     (MessageNumber : AxecModemRejectedCommand;         MessageString : AxecSModemRejectedCommand),
     (MessageNumber : AxecModemStatusMismatch;          MessageString : AxecSModemStatusMismatch),

// PhonebookEditor strings -- constants in ADPBEDIT.PAS

     (MessageNumber : AxpeDeleteQuery;                  MessageString : AxpeSDeleteQuery),

// Simple Modem strings -- constants in ADSMODEM.PAS

     (MessageNumber : AxsmMsgReady;                     MessageString : AxsmSMsgReady),
     (MessageNumber : AxsmMsgInitialize;                MessageString : AxsmSMsgInitialize),
     (MessageNumber : AxsmMsgInitializeTimeout;         MessageString : AxsmSMsgInitializeTimeout),
     (MessageNumber : AxsmAutoAnswerBackground;         MessageString : AxsmSAutoAnswerBackground),
     (MessageNumber : AxsmAutoAnswerWait;               MessageString : AxsmSAutoAnswerWait),
     (MessageNumber : AxsmAnswerWait;                   MessageString : AxsmSAnswerWait),
     (MessageNumber : AxsmDialWait;                     MessageString : AxsmSDialWait),
     (MessageNumber : AxsmDialCycle;                    MessageString : AxsmSDialCycle),
     (MessageNumber : AxsmNoDialtone;                   MessageString : AxsmSNoDialtone),
     (MessageNumber : AxsmConnectWait;                  MessageString : AxsmSConnectWait),
     (MessageNumber : AxsmConnected;                    MessageString : AxsmSConnected),
     (MessageNumber : AxsmHangup;                       MessageString : AxsmSHangup),
     (MessageNumber : AxsmCancel;                       MessageString : AxsmSCancel),

// Dialer strings -- constants in ADDIAL.PAS

     (MessageNumber : AxddCycling;                      MessageString : AxddSCycling),
     (MessageNumber : AxddRetryWaiting;                 MessageString : AxddSRetryWaiting),
     (MessageNumber : AxddRetryWaitOver;                MessageString : AxddSRetryWaitOver),
     (MessageNumber : AxddDialing;                      MessageString : AxddSDialing),
     (MessageNumber : AxddModemConnect;                 MessageString : AxddSModemConnect),
     (MessageNumber : AxddModemConnectAt;               MessageString : AxddSModemConnectAt),
     (MessageNumber : AxddModemVoice;                   MessageString : AxddSModemVoice),
     (MessageNumber : AxddModemError;                   MessageString : AxddSModemError),
     (MessageNumber : AxddModemNoCarrier;               MessageString : AxddSModemNoCarrier),
     (MessageNumber : AxddModemBusy;                    MessageString : AxddSModemBusy),
     (MessageNumber : AxddModemNoDialTone;              MessageString : AxddSModemNoDialTone),
     (MessageNumber : AxddDialTimedOut;                 MessageString : AxddSDialTimedOut),

// Phonebook entry strings -- constants in ADPENTRY.PAS

     (MessageNumber : AxpeMustEnterName;                MessageString : AxpeSMustEnterName),
     (MessageNumber : AxpeMustEnterNumber;              MessageString : AxpeSMustEnterNumber),
     (MessageNumber : AxpeNameExists;                   MessageString : AxpeSNameExists),

// RAS component strings -- constants in ADRASUTL.PAS

     (MessageNumber : AxcsOpenPort;                     MessageString : AxcsSOpenPort),
     (MessageNumber : AxcsPortOpened;                   MessageString : AxcsSPortOpened),
     (MessageNumber : AxcsConnectDevice;                MessageString : AxcsSConnectDevice),
     (MessageNumber : AxcsDeviceConnected;              MessageString : AxcsSDeviceConnected),
     (MessageNumber : AxcsAllDevicesConnected;          MessageString : AxcsSAllDevicesConnected),
     (MessageNumber : AxcsAuthenticate;                 MessageString : AxcsSAuthenticate),
     (MessageNumber : AxcsAuthNotify;                   MessageString : AxcsSAuthNotify),
     (MessageNumber : AxcsAuthRetry;                    MessageString : AxcsSAuthRetry),
     (MessageNumber : AxcsAuthCallback;                 MessageString : AxcsSAuthCallback),
     (MessageNumber : AxcsAuthChangePassword;           MessageString : AxcsSAuthChangePassword),
     (MessageNumber : AxcsAuthProject;                  MessageString : AxcsSAuthProject),
     (MessageNumber : AxcsAuthLinkSpeed;                MessageString : AxcsSAuthLinkSpeed),
     (MessageNumber : AxcsAuthAck;                      MessageString : AxcsSAuthAck),
     (MessageNumber : AxcsReAuthenticate;               MessageString : AxcsSReAuthenticate),
     (MessageNumber : AxcsAuthenticated;                MessageString : AxcsSAuthenticated),
     (MessageNumber : AxcsPrepareForCallback;           MessageString : AxcsSPrepareForCallback),
     (MessageNumber : AxcsWaitForModemReset;            MessageString : AxcsSWaitForModemReset),
     (MessageNumber : AxcsWaitForCallback;              MessageString : AxcsSWaitForCallback),
     (MessageNumber : AxcsProjected;                    MessageString : AxcsSProjected),
     (MessageNumber : AxcsStartAuthentication;          MessageString : AxcsSStartAuthentication),
     (MessageNumber : AxcsCallbackComplete;             MessageString : AxcsSCallbackComplete),
     (MessageNumber : AxcsLogonNetwork;                 MessageString : AxcsSLogonNetwork),
     (MessageNumber : AxcsSubEntryConnected;            MessageString : AxcsSSubEntryConnected),
     (MessageNumber : AxcsSubEntryDisconnected;         MessageString : AxcsSSubEntryDisconnected),

     (MessageNumber : AxcsInteractive;                  MessageString : AxcsSInteractive),
     (MessageNumber : AxcsRetryAuthentication;          MessageString : AxcsSRetryAuthentication),
     (MessageNumber : AxcsCallbackSetByCaller;          MessageString : AxcsSCallbackSetByCaller),
     (MessageNumber : AxcsPasswordExpired;              MessageString : AxcsSPasswordExpired),

     (MessageNumber : AxcsDeviceConnected2;             MessageString : AxcsSDeviceConnected2),

// Paging component strings -- constants in ADPAGER.PAS

     (MessageNumber : AxTDS_NONE;                       MessageString : AxTDS_SNONE),
     (MessageNumber : AxTDS_OFFHOOK;                    MessageString : AxTDS_SOFFHOOK),
     (MessageNumber : AxTDS_DIALING;                    MessageString : AxTDS_SDIALING),
     (MessageNumber : AxTDS_RINGING;                    MessageString : AxTDS_SRINGING),
     (MessageNumber : AxTDS_WAITFORCONNECT;             MessageString : AxTDS_SWAITFORCONNECT),
     (MessageNumber : AxTDS_CONNECTED;                  MessageString : AxTDS_SCONNECTED),
     (MessageNumber : AxTDS_WAITINGTOREDIAL;            MessageString : AxTDS_SWAITINGTOREDIAL),
     (MessageNumber : AxTDS_REDIALING;                  MessageString : AxTDS_SREDIALING),
     (MessageNumber : AxTDS_MSGNOTSENT;                 MessageString : AxTDS_SMSGNOTSENT),
     (MessageNumber : AxTDS_CANCELLING;                 MessageString : AxTDS_SCANCELLING),
     (MessageNumber : AxTDS_DISCONNECT;                 MessageString : AxTDS_SDISCONNECT),
     (MessageNumber : AxTDS_CLEANUP;                    MessageString : AxTDS_SCLEANUP),

     (MessageNumber : AxTDE_NONE;                       MessageString : AxTDE_SNONE),
     (MessageNumber : AxTDE_NODIALTONE;                 MessageString : AxTDE_SNODIALTONE),
     (MessageNumber : AxTDE_LINEBUSY;                   MessageString : AxTDE_SLINEBUSY),
     (MessageNumber : AxTDE_NOCONNECTION;               MessageString : AxTDE_SNOCONNECTION),

     (MessageNumber : AxTPS_NONE;                       MessageString : AxTPS_SNONE),
     (MessageNumber : AxTPS_LOGINPROMPT;                MessageString : AxTPS_SLOGINPROMPT),
     (MessageNumber : AxTPS_LOGGEDIN;                   MessageString : AxTPS_SLOGGEDIN),
     (MessageNumber : AxTPS_LOGINERR;                   MessageString : AxTPS_SLOGINERR),
     (MessageNumber : AxTPS_LOGINFAIL;                  MessageString : AxTPS_SLOGINFAIL),
     (MessageNumber : AxTPS_MSGOKTOSEND;                MessageString : AxTPS_SMSGOKTOSEND),
     (MessageNumber : AxTPS_SENDINGMSG;                 MessageString : AxTPS_SSENDINGMSG),
     (MessageNumber : AxTPS_MSGACK;                     MessageString : AxTPS_SMSGACK),
     (MessageNumber : AxTPS_MSGNAK;                     MessageString : AxTPS_SMSGNAK),
     (MessageNumber : AxTPS_MSGRS;                      MessageString : AxTPS_SMSGRS),
     (MessageNumber : AxTPS_MSGCOMPLETED;               MessageString : AxTPS_SMSGCOMPLETED),
     (MessageNumber : AxTPS_DONE;                       MessageString : AxTPS_SDONE),

// Protocol resource strings
// If strings are added -- aStatusMsg needs to be changed in AWABSPCL.PAS

     (MessageNumber : AxpsOK;                           MessageString : AxpsSOK),
     (MessageNumber : AxpsProtocolHandshake;            MessageString : AxpsSProtocolHandshake),
     (MessageNumber : AxpsInvalidDate;                  MessageString : AxpsSInvalidDate),
     (MessageNumber : AxpsFileRejected;                 MessageString : AxpsSFileRejected),
     (MessageNumber : AxpsFileRenamed;                  MessageString : AxpsSFileRenamed),
     (MessageNumber : AxpsSkipFile;                     MessageString : AxpsSSkipFile),
     (MessageNumber : AxpsFileDoesntExist;              MessageString : AxpsSFileDoesntExist),
     (MessageNumber : AxpsCantWriteFile;                MessageString : AxpsSCantWriteFile),
     (MessageNumber : AxpsTimeout;                      MessageString : AxpsSTimeout),
     (MessageNumber : AxpsBlockCheckError;              MessageString : AxpsSBlockCheckError),
     (MessageNumber : AxpsLongPacket;                   MessageString : AxpsSLongPacket),
     (MessageNumber : AxpsDuplicateBlock;               MessageString : AxpsSDuplicateBlock),
     (MessageNumber : AxpsProtocolError;                MessageString : AxpsSProtocolError),
     (MessageNumber : AxpsCancelRequested;              MessageString : AxpsSCancelRequested),
     (MessageNumber : AxpsEndFile;                      MessageString : AxpsSEndFile),
     (MessageNumber : AxpsResumeBad;                    MessageString : AxpsSResumeBad),
     (MessageNumber : AxpsSequenceError;                MessageString : AxpsSSequenceError),
     (MessageNumber : AxpsAbortNoCarrier;               MessageString : AxpsSAbortNoCarrier),

     (MessageNumber : AxpsGotCrcE;                      MessageString : AxpsSGotCrcE),
     (MessageNumber : AxpsGotCrcG;                      MessageString : AxpsSGotCrcG),
     (MessageNumber : AxpsGotCrcW;                      MessageString : AxpsSGotCrcW),
     (MessageNumber : AxpsGotCrcQ;                      MessageString : AxpsSGotCrcQ),
     (MessageNumber : AxpsTryResume;                    MessageString : AxpsSTryResume),
     (MessageNumber : AxpsHostResume;                   MessageString : AxpsSHostResume),

// Fax resource strings
// If strings are added -- apStatusMsg needs to be changed in AWABSPCL.PAS

     (MessageNumber : AxfpInitModem;                    MessageString : AxfpSInitModem),
     (MessageNumber : AxfpDialing;                      MessageString : AxfpSDialing),
     (MessageNumber : AxfpBusyWait;                     MessageString : AxfpSBusyWait),
     (MessageNumber : AxfpSendPage;                     MessageString : AxfpSSendPage),
     (MessageNumber : AxfpSendPageStatus;               MessageString : AxfpSSendPageStatus),
     (MessageNumber : AxfpPageError;                    MessageString : AxfpSPageError),
     (MessageNumber : AxfpPageOK;                       MessageString : AxfpSPageOK),
     (MessageNumber : AxfpConnecting;                   MessageString : AxfpSConnecting),

     (MessageNumber : AxfpWaiting;                      MessageString : AxfpSWaiting),
     (MessageNumber : AxfpNoConnect;                    MessageString : AxfpSNoConnect),
     (MessageNumber : AxfpAnswer;                       MessageString : AxfpSAnswer),
     (MessageNumber : AxfpIncoming;                     MessageString : AxfpSIncoming),
     (MessageNumber : AxfpGetPage;                      MessageString : AxfpSGetPage),
     (MessageNumber : AxfpGetPageResult;                MessageString : AxfpSGetPageResult),
     (MessageNumber : AxfpCheckMorePages;               MessageString : AxfpSCheckMorePages),
     (MessageNumber : AxfpGetHangup;                    MessageString : AxfpSGetHangup),
     (MessageNumber : AxfpGotHangup;                    MessageString : AxfpSGotHangup),

     (MessageNumber : AxfpSessionParams;                MessageString : AxfpSSessionParams),
     (MessageNumber : AxfpGotRemoteID;                  MessageString : AxfpSGotRemoteID),
     (MessageNumber : AxfpCancel;                       MessageString : AxfpSCancel),
     (MessageNumber : AxfpFinished;                     MessageString : AxfpSFinished),

// Error strings -- constants in OOMISC.INC

     (MessageNumber : AxecNoMoreTriggers;               MessageString : AxecSNoMoreTriggers),
     (MessageNumber : AxecTriggerTooLong;               MessageString : AxecSTriggerTooLong),
     (MessageNumber : AxecBadTriggerHandle;             MessageString : AxecSBadTriggerHandle),
     
     (MessageNumber : AxecStartStringEmpty;             MessageString : AxecSStartStringEmpty),
     (MessageNumber : AxecPacketTooSmall;               MessageString : AxecSPacketTooSmall),
     (MessageNumber : AxecNoEndCharCount;               MessageString : AxecSNoEndCharCount),
     (MessageNumber : AxecEmptyEndString;               MessageString : AxecSEmptyEndString),
     (MessageNumber : AxecZeroSizePacket;               MessageString : AxecSZeroSizePacket),
     (MessageNumber : AxecPacketTooLong;                MessageString : AxecSPacketTooLong),

     (MessageNumber : AxecBadFileList;                  MessageString : AxecSBadFileList),
     (MessageNumber : AxecNoSearchMask;                 MessageString : AxecSNoSearchMask),
     (MessageNumber : AxecNoMatchingFiles;              MessageString : AxecSNoMatchingFiles),
     (MessageNumber : AxecDirNotFound;                  MessageString : AxecSDirNotFound),
     (MessageNumber : AxecCancelRequested;              MessageString : AxecSCancelRequested),
     (MessageNumber : AxecTimeout;                      MessageString : AxecSTimeout),
     (MessageNumber : AxecProtocolError;                MessageString : AxecSProtocolError),
     (MessageNumber : AxecTooManyErrors;                MessageString : AxecSTooManyErrors),
     (MessageNumber : AxecSequenceError;                MessageString : AxecSSequenceError),
     (MessageNumber : AxecNoFilename;                   MessageString : AxecSNoFilename),
     (MessageNumber : AxecFileRejected;                 MessageString : AxecSFileRejected),
     (MessageNumber : AxecCantWriteFile;                MessageString : AxecSCantWriteFile),
     (MessageNumber : AxecTableFull;                    MessageString : AxecSTableFull),
     (MessageNumber : AxecAbortNoCarrier;               MessageString : AxecSAbortNoCarrier),
     (MessageNumber : AxecBadProtocolFunction;          MessageString : AxecSBadProtocolFunction),

     (MessageNumber : AxecKeyTooLong;                   MessageString : AxecSKeyTooLong),
     (MessageNumber : AxecDataTooLarge;                 MessageString : AxecSDataTooLarge),
     (MessageNumber : AxecNoFieldsDefined;              MessageString : AxecSNoFieldsDefined),
     (MessageNumber : AxecIniWrite;                     MessageString : AxecSIniWrite),
     (MessageNumber : AxecIniRead;                      MessageString : AxecSIniRead),
     (MessageNumber : AxecNoIndexKey;                   MessageString : AxecSNoIndexKey),
     (MessageNumber : AxecRecordExists;                 MessageString : AxecSRecordExists),
     (MessageNumber : AxecRecordNotFound;               MessageString : AxecSRecordNotFound),
     (MessageNumber : AxecMustHaveIdxVal;               MessageString : AxecSMustHaveIdxVal),
     (MessageNumber : AxecDatabaseFull;                 MessageString : AxecSDatabaseFull),
     (MessageNumber : AxecDatabaseEmpty;                MessageString : AxecSDatabaseEmpty),
     (MessageNumber : AxecDatabaseNotPrepared;          MessageString : AxecSDatabaseNotPrepared),
     (MessageNumber : AxecBadFieldList;                 MessageString : AxecSBadFieldList),
     (MessageNumber : AxecBadFieldForIndex;             MessageString : AxecSBadFieldForIndex),

     (MessageNumber : AxecFaxBadFormat;                 MessageString : AxecSFaxBadFormat),
     (MessageNumber : AxecBadGraphicsFormat;            MessageString : AxecSBadGraphicsFormat),
     (MessageNumber : AxecConvertAbort;                 MessageString : AxecSConvertAbort),
     (MessageNumber : AxecUnpackAbort;                  MessageString : AxecSUnpackAbort),
     (MessageNumber : AxecCantMakeBitmap;               MessageString : AxecSCantMakeBitmap),
     (MessageNumber : AxecNoImageLoaded;                MessageString : AxecSNoImageLoaded),
     (MessageNumber : AxecNoImageBlockMarked;           MessageString : AxecSNoImageBlockMarked),
     (MessageNumber : AxecFontFileNotFound;             MessageString : AxecSFontFileNotFound),
     (MessageNumber : AxecInvalidPageNumber;            MessageString : AxecSInvalidPageNumber),
     (MessageNumber : AxecBmpTooBig;                    MessageString : AxecSBmpTooBig),
     (MessageNumber : AxecEnhFontTooBig;                MessageString : AxecSEnhFontTooBig),

     (MessageNumber : AxecFaxBadMachine;                MessageString : AxecSFaxBadMachine),
     (MessageNumber : AxecFaxBadModemResult;            MessageString : AxecSFaxBadModemResult),
     (MessageNumber : AxecFaxTrainError;                MessageString : AxecSFaxTrainError),
     (MessageNumber : AxecFaxInitError;                 MessageString : AxecSFaxInitError),
     (MessageNumber : AxecFaxBusy;                      MessageString : AxecSFaxBusy),
     (MessageNumber : AxecFaxVoiceCall;                 MessageString : AxecSFaxVoiceCall),
     (MessageNumber : AxecFaxDataCall;                  MessageString : AxecSFaxDataCall),
     (MessageNumber : AxecFaxNoDialTone;                MessageString : AxecSFaxNoDialTone),
     (MessageNumber : AxecFaxNoCarrier;                 MessageString : AxecSFaxNoCarrier),
     (MessageNumber : AxecFaxSessionError;              MessageString : AxecSFaxSessionError),
     (MessageNumber : AxecFaxPageError;                 MessageString : AxecSFaxPageError),
     (MessageNumber : AxecFaxGDIPrintError;             MessageString : AxecSFaxGDIPrintError),
     (MessageNumber : AxecFaxMixedResolution;           MessageString : AxecSFaxMixedResolution),
     (MessageNumber : AxecFaxConverterInitFail;         MessageString : AxecSFaxConverterInitFail),
     (MessageNumber : AxecNoAnswer;                     MessageString : AxecSNoAnswer),
     (MessageNumber : AxecAlreadyMonitored;             MessageString : AxecSAlreadyMonitored),

     (MessageNumber : AxecUniAlreadyInstalled;          MessageString : AxecSUniAlreadyInstalled),
     (MessageNumber : AxecUniCannotGetSysDir;           MessageString : AxecSUniCannotGetSysDir),
     (MessageNumber : AxecUniCannotGetWinDir;           MessageString : AxecSUniCannotGetWinDir),
     (MessageNumber : AxecUniUnknownLayout;             MessageString : AxecSUniUnknownLayout),
     (MessageNumber : AxecUniCannotParseInfFile;        MessageString : AxecSUniCannotParseInfFile),
     (MessageNumber : AxecUniCannotInstallFile;         MessageString : AxecSUniCannotInstallFile),
     (MessageNumber : AxecNotNTDriver;                  MessageString : AxecSNotNTDriver),
     (MessageNumber : AxecDrvCopyError;                 MessageString : AxecSDrvCopyError),
     (MessageNumber : AxecCannotAddPrinter;             MessageString : AxecSCannotAddPrinter),
     (MessageNumber : AxecDrvBadResources;              MessageString : AxecSDrvBadResources),
     (MessageNumber : AxecDrvDriverNotFound;            MessageString : AxecSDrvDriverNotFound),
     (MessageNumber : AxecUniCannotGetPrinterDriverDir; MessageString : AxecSUniCannotGetPrinterDriverDir),
     (MessageNumber : AxecInstallDriverFailed;          MessageString : AxecSInstallDriverFailed),

  // Additional AxPackEd errors     8300-8399

     (MessageNumber : AxecPackEdMismatchedQuote;        MessageString : AxecStrPackEdMismatchedQuote),
     (MessageNumber : AxecPackEdNumberExpected;         MessageString : AxecStrPackEdNumberExpected),
     (MessageNumber : AxecPackEdNumberOutOfRange;       MessageString : AxecStrPackEdNumberOutOfRange),
     (MessageNumber : AxecPackEdHex0String;             MessageString : AxecStrPackEdHex0String),
     (MessageNumber : AxecPackEdAlphaExpected;          MessageString : AxecStrPackEdAlphaExpected),

  // Additional AxTrmEmu Errors     8400-8499

     (MessageNumber : AxecTrmEmuNotEnoughData;          MessageString : AxecStrTrmEmuNotEnoughData),

  // Additional AxTrmBuf Errors     8500-8599

     (MessageNumber : AxecTrmBufDelItemsRangeErr;       MessageString : AxecStrTrmBufDelItemsRangeErr),
     (MessageNumber : AxecTrmBufGetItemPtrRangeErr;     MessageString : AxecStrTrmBufGetItemPtrRangeErr),
     (MessageNumber : AxecTrmBufGetItemPtrSizeErr;      MessageString : AxecStrTrmBufGetItemPtrSizeErr),
     (MessageNumber : AxecTrmBufInsertItemRangeErr;     MessageString : AxecStrTrmBufInsertItemRangeErr),
     (MessageNumber : AxecTrmBufScrollRowRangeErr;      MessageString : AxecStrTrmBufScrollRowRangeErr),
     (MessageNumber : AxecTrmBufColCountTooLow1;        MessageString : AxecStrTrmBufColCountTooLow1),
     (MessageNumber : AxecTrmBufColCountTooLow2;        MessageString : AxecStrTrmBufColCountTooLow2),
     (MessageNumber : AxecTrmBufWriteDupItemsRange;     MessageString : AxecStrTrmBufWriteDupItemsRange),
     (MessageNumber : AxecTrmBufWriteDupItemsRange;     MessageString : AxecStrTrmBufWriteItemsRangeErr),
     (MessageNumber : AxecTrmBufDeleteCharTooLow;       MessageString : AxecStrTrmBufDeleteCharTooLow),
     (MessageNumber : AxecTrmBufDeleteLinesTooLow;      MessageString : AxecStrTrmBufDeleteLinesTooLow),
     (MessageNumber : AxecTrmBufEraseCharsCount;        MessageString : AxecStrTrmBufEraseCharsCount),
     (MessageNumber : AxecTrmBufGetLineAttPtrRange;     MessageString : AxecStrTrmBufGetLineAttPtrRange),
     (MessageNumber : AxecTrmBufGetLineAttPtrRange;     MessageString : AxecStrTrmBufGetLineBackColorRng),
     (MessageNumber : AxecTrmBufGetLineCharPtrRange;    MessageString : AxecStrTrmBufGetLineCharPtrRange),
     (MessageNumber : AxecTrmBufGetLineCharSetRange;    MessageString : AxecStrTrmBufGetLineCharSetRange),
     (MessageNumber : AxecTrmBufGetLineForeColorRng;    MessageString : AxecStrTrmBufGetLineForeColorRng),
     (MessageNumber : AxecTrmBufInsertCharsCount;       MessageString : AxecStrTrmBufInsertCharsCount),
     (MessageNumber : AxecTrmBufInsertLinesCount;       MessageString : AxecStrTrmBufInsertLinesCount),
     (MessageNumber : AxecTrmBufScrollRgnRowNum;        MessageString : AxecStrTrmBufScrollRgnRowNum),
     (MessageNumber : AxecTrmBufColCountTooSmall;       MessageString : AxecStrTrmBufColCountTooSmall),
     (MessageNumber : AxecTrmBufSetRowCountTooSmall;    MessageString : AxecStrTrmBufSetRowCountTooSmall),
     (MessageNumber : AxecTrmBufSetSVRowCountToSmall;   MessageString : AxecStrTrmBufSetSVRowCountToSmall),

  // Additional AxPager Error       8600-8699

     (MessageNumber : AxecPagerUnableToFreeTrigger;     MessageString : AxecStrPagerUnableToFreeTrigger),
     (MessageNumber : AxecPagerNoComport;               MessageString : AxecStrPagerNoComport),
     (MessageNumber : AxecPagerNoSuchTriggerType;       MessageString : AxecStrPagerNoSuchTriggerType),

  // Additional AxWin32 Errors      8700-8799

     (MessageNumber : AxecWin32DispatcherStarted;       MessageString : AxecStrWin32DispatcherStarted),

// APRO-specfic error constants are found in ADSOCKET.PAS

     (MessageNumber : AxADWSEERROR;                     MessageString : AxADSWSEERROR),
     (MessageNumber : AxADWSLOADERROR;                  MessageString : AxADSWSLOADERROR),
     (MessageNumber : AxADWSVERSIONERROR;               MessageString : AxADSWSVERSIONERROR),
     (MessageNumber : AxADWSNOTINIT;                    MessageString : AxADSWSNOTINIT),
     (MessageNumber : AxADWSINVPORT;                    MessageString : AxADSWSINVPORT),
     (MessageNumber : AxADWSCANTCHANGE;                 MessageString : AxADSWSCANTCHANGE),
     (MessageNumber : AxADWSCANTRESOLVE;                MessageString : AxADSWSCANTRESOLVE),

// Standard Winsock error constants are found in ADWUTIL.PAS

     (MessageNumber : AxwsaEIntr;                       MessageString : AxwsaSEIntr),
     (MessageNumber : AxwsaEBadF;                       MessageString : AxwsaSEBadF),
     (MessageNumber : AxwsaEAcces;                      MessageString : AxwsaSEAcces),
     (MessageNumber : AxwsaEFault;                      MessageString : AxwsaSEFault),
     (MessageNumber : AxwsaEInVal;                      MessageString : AxwsaSEInVal),
     (MessageNumber : AxwsaEMFile;                      MessageString : AxwsaSEMFile),

     (MessageNumber : AxwsaEWouldBlock;                 MessageString : AxwsaSEWouldBlock),
     (MessageNumber : AxwsaEInProgress;                 MessageString : AxwsaSEInProgress),
     (MessageNumber : AxwsaEAlReady;                    MessageString : AxwsaSEAlReady),
     (MessageNumber : AxwsaENotSock;                    MessageString : AxwsaSENotSock),
     (MessageNumber : AxwsaEDestAddrReq;                MessageString : AxwsaSEDestAddrReq),
     (MessageNumber : AxwsaEMsgSize;                    MessageString : AxwsaSEMsgSize),
     (MessageNumber : AxwsaEPrototype;                  MessageString : AxwsaSEPrototype),
     (MessageNumber : AxwsaENoProtoOpt;                 MessageString : AxwsaSENoProtoOpt),
     (MessageNumber : AxwsaEProtoNoSupport;             MessageString : AxwsaSEProtoNoSupport),
     (MessageNumber : AxwsaESocktNoSupport;             MessageString : AxwsaSESocktNoSupport),
     (MessageNumber : AxwsaEOpNotSupp;                  MessageString : AxwsaSEOpNotSupp),
     (MessageNumber : AxwsaEPfNoSupport;                MessageString : AxwsaSEPfNoSupport),
     (MessageNumber : AxwsaEAfNoSupport;                MessageString : AxwsaSEAfNoSupport),
     (MessageNumber : AxwsaEAddrInUse;                  MessageString : AxwsaSEAddrInUse),
     (MessageNumber : AxwsaEAddrNotAvail;               MessageString : AxwsaSEAddrNotAvail),
     (MessageNumber : AxwsaENetDown;                    MessageString : AxwsaSENetDown),
     (MessageNumber : AxwsaENetUnreach;                 MessageString : AxwsaSENetUnreach),
     (MessageNumber : AxwsaENetReset;                   MessageString : AxwsaSENetReset),
     (MessageNumber : AxwsaEConnAborted;                MessageString : AxwsaSEConnAborted),
     (MessageNumber : AxwsaEConnReset;                  MessageString : AxwsaSEConnReset),
     (MessageNumber : AxwsaENoBufs;                     MessageString : AxwsaSENoBufs),
     (MessageNumber : AxwsaEIsConn;                     MessageString : AxwsaSEIsConn),
     (MessageNumber : AxwsaENotConn;                    MessageString : AxwsaSENotConn),
     (MessageNumber : AxwsaEShutDown;                   MessageString : AxwsaSEShutDown),
     (MessageNumber : AxwsaETooManyRefs;                MessageString : AxwsaSETooManyRefs),
     (MessageNumber : AxwsaETimedOut;                   MessageString : AxwsaSETimedOut),
     (MessageNumber : AxwsaEConnRefused;                MessageString : AxwsaSEConnRefused),
     (MessageNumber : AxwsaELoop;                       MessageString : AxwsaSELoop),
     (MessageNumber : AxwsaENameTooLong;                MessageString : AxwsaSENameTooLong),
     (MessageNumber : AxwsaEHostDown;                   MessageString : AxwsaSEHostDown),
     (MessageNumber : AxwsaEHostUnreach;                MessageString : AxwsaSEHostUnreach),
     (MessageNumber : AxwsaENotEmpty;                   MessageString : AxwsaSENotEmpty),
     (MessageNumber : AxwsaEProcLim;                    MessageString : AxwsaSEProcLim),
     (MessageNumber : AxwsaEUsers;                      MessageString : AxwsaSEUsers),
     (MessageNumber : AxwsaEDQuot;                      MessageString : AxwsaSEDQuot),
     (MessageNumber : AxwsaEStale;                      MessageString : AxwsaSEStale),
     (MessageNumber : AxwsaERemote;                     MessageString : AxwsaSERemote),

  { Extended Windows Sockets error constant definitions }

     (MessageNumber : AxwsaSysNotReady;                 MessageString : AxwsaSSysNotReady),
     (MessageNumber : AxwsaVerNotSupported;             MessageString : AxwsaSVerNotSupported),
     (MessageNumber : AxwsaNotInitialised;              MessageString : AxwsaSNotInitialised),
     (MessageNumber : AxwsaEDiscOn;                     MessageString : AxwsaSEDiscOn),


     (MessageNumber : AxwsaHost_Not_Found;              MessageString : AxwsaSHost_Not_Found),
     (MessageNumber : AxwsaTry_Again;                   MessageString : AxwsaSTry_Again),
     (MessageNumber : AxwsaNo_Recovery;                 MessageString : AxwsaSNo_Recovery),
     (MessageNumber : AxwsaNo_Data;                     MessageString : AxwsaSNo_Data),

// TAPI Line Call State Messages -- See ADTUTIL & ADTAPI

     (MessageNumber : AxTapiLineCallState1;             MessageString : AxSTapiLineCallState1),
     (MessageNumber : AxTapiLineCallState2;             MessageString : AxSTapiLineCallState2),
     (MessageNumber : AxTapiLineCallState3;             MessageString : AxSTapiLineCallState3),
     (MessageNumber : AxTapiLineCallState4;             MessageString : AxSTapiLineCallState4),
     (MessageNumber : AxTapiLineCallState5;             MessageString : AxSTapiLineCallState5),
     (MessageNumber : AxTapiLineCallState6;             MessageString : AxSTapiLineCallState6),
     (MessageNumber : AxTapiLineCallState7;             MessageString : AxSTapiLineCallState7),
     (MessageNumber : AxTapiLineCallState8;             MessageString : AxSTapiLineCallState8),
     (MessageNumber : AxTapiLineCallState9;             MessageString : AxSTapiLineCallState9),
     (MessageNumber : AxTapiLineCallState10;            MessageString : AxSTapiLineCallState10),
     (MessageNumber : AxTapiLineCallState11;            MessageString : AxSTapiLineCallState11),
     (MessageNumber : AxTapiLineCallState12;            MessageString : AxSTapiLineCallState12),
     (MessageNumber : AxTapiLineCallState13;            MessageString : AxSTapiLineCallState13),
     (MessageNumber : AxTapiLineCallState14;            MessageString : AxSTapiLineCallState14),
     (MessageNumber : AxTapiLineCallState15;            MessageString : AxSTapiLineCallState15),
     (MessageNumber : AxTapiLineCallState16;            MessageString : AxSTapiLineCallState16),

// TAPI Line Device State Messages -- See ADTUTIL & ADTAPI

     (MessageNumber : AxTapiLineDeviceState33;          MessageString : AxSTapiLineDeviceState33),
     (MessageNumber : AxTapiLineDeviceState34;          MessageString : AxSTapiLineDeviceState34),
     (MessageNumber : AxTapiLineDeviceState35;          MessageString : AxSTapiLineDeviceState35),
     (MessageNumber : AxTapiLineDeviceState36;          MessageString : AxSTapiLineDeviceState36),
     (MessageNumber : AxTapiLineDeviceState37;          MessageString : AxSTapiLineDeviceState37),
     (MessageNumber : AxTapiLineDeviceState38;          MessageString : AxSTapiLineDeviceState38),
     (MessageNumber : AxTapiLineDeviceState39;          MessageString : AxSTapiLineDeviceState39),
     (MessageNumber : AxTapiLineDeviceState40;          MessageString : AxSTapiLineDeviceState40),
     (MessageNumber : AxTapiLineDeviceState41;          MessageString : AxSTapiLineDeviceState41),
     (MessageNumber : AxTapiLineDeviceState42;          MessageString : AxSTapiLineDeviceState42),
     (MessageNumber : AxTapiLineDeviceState43;          MessageString : AxSTapiLineDeviceState43),
     (MessageNumber : AxTapiLineDeviceState44;          MessageString : AxSTapiLineDeviceState44),
     (MessageNumber : AxTapiLineDeviceState45;          MessageString : AxSTapiLineDeviceState45),
     (MessageNumber : AxTapiLineDeviceState46;          MessageString : AxSTapiLineDeviceState46),
     (MessageNumber : AxTapiLineDeviceState47;          MessageString : AxSTapiLineDeviceState47),
     (MessageNumber : AxTapiLineDeviceState48;          MessageString : AxSTapiLineDeviceState48),
     (MessageNumber : AxTapiLineDeviceState49;          MessageString : AxSTapiLineDeviceState49),
     (MessageNumber : AxTapiLineDeviceState50;          MessageString : AxSTapiLineDeviceState50),
     (MessageNumber : AxTapiLineDeviceState51;          MessageString : AxSTapiLineDeviceState51),
     (MessageNumber : AxTapiLineDeviceState52;          MessageString : AxSTapiLineDeviceState52),
     (MessageNumber : AxTapiLineDeviceState53;          MessageString : AxSTapiLineDeviceState53),
     (MessageNumber : AxTapiLineDeviceState54;          MessageString : AxSTapiLineDeviceState54),
     (MessageNumber : AxTapiLineDeviceState55;          MessageString : AxSTapiLineDeviceState55),
     (MessageNumber : AxTapiLineDeviceState56;          MessageString : AxSTapiLineDeviceState56),
     (MessageNumber : AxTapiLineDeviceState57;          MessageString : AxSTapiLineDeviceState57),

     (MessageNumber : AxTapiLineDeviceState65;          MessageString : AxSTapiLineDeviceState65),

     (MessageNumber : AxTapiLineDeviceState97;          MessageString : AxSTapiLineDeviceState97),
     (MessageNumber : AxTapiLineDeviceState98;          MessageString : AxSTapiLineDeviceState98),
     (MessageNumber : AxTapiLineDeviceState99;          MessageString : AxSTapiLineDeviceState99),
     (MessageNumber : AxTapiLineDeviceState100;         MessageString : AxSTapiLineDeviceState100),
     (MessageNumber : AxTapiLineDeviceState101;         MessageString : AxSTapiLineDeviceState101),

// TAPI Disconnect messages

     (MessageNumber : AxTapiDisconnect01;               MessageString : AxSTapiDisconnect01),
     (MessageNumber : AxTapiDisconnect02;               MessageString : AxSTapiDisconnect02),
     (MessageNumber : AxTapiDisconnect03;               MessageString : AxSTapiDisconnect03),
     (MessageNumber : AxTapiDisconnect04;               MessageString : AxSTapiDisconnect04),
     (MessageNumber : AxTapiDisconnect05;               MessageString : AxSTapiDisconnect05),
     (MessageNumber : AxTapiDisconnect06;               MessageString : AxSTapiDisconnect06),
     (MessageNumber : AxTapiDisconnect07;               MessageString : AxSTapiDisconnect07),
     (MessageNumber : AxTapiDisconnect08;               MessageString : AxSTapiDisconnect08),
     (MessageNumber : AxTapiDisconnect09;               MessageString : AxSTapiDisconnect09),
     (MessageNumber : AxTapiDisconnect10;               MessageString : AxSTapiDisconnect10),
     (MessageNumber : AxTapiDisconnect11;               MessageString : AxSTapiDisconnect11),
     (MessageNumber : AxTapiDisconnect12;               MessageString : AxSTapiDisconnect12),
     (MessageNumber : AxTapiDisconnect13;               MessageString : AxSTapiDisconnect13),
     (MessageNumber : AxTapiDisconnect14;               MessageString : AxSTapiDisconnect14),
     (MessageNumber : AxTapiDisconnect15;               MessageString : AxSTapiDisconnect15),
     (MessageNumber : AxTapiDisconnect16;               MessageString : AxSTapiDisconnect16),
     (MessageNumber : AxTapiDisconnect17;               MessageString : AxSTapiDisconnect17),
     (MessageNumber : AxTapiDisconnect18;               MessageString : AxSTapiDisconnect18),
     (MessageNumber : AxTapiDisconnect19;               MessageString : AxSTapiDisconnect19),
     (MessageNumber : AxTapiDisconnect20;               MessageString : AxSTapiDisconnect20),
     (MessageNumber : AxTapiDisconnect21;               MessageString : AxSTapiDisconnect21),

// TAPI Error messages -- See OOMISC.INC, ADTUTIL & ADTAPI

     (MessageNumber : AxecAllocated;                    MessageString : AxecSAllocated),
     (MessageNumber : AxecBadDeviceID;                  MessageString : AxecSBadDeviceID),
     (MessageNumber : AxecBearerModeUnavail;            MessageString : AxecSBearerModeUnavail),
     (MessageNumber : AxecCallUnavail;                  MessageString : AxecSCallUnavail),
     (MessageNumber : AxecCompletionOverrun;            MessageString : AxecSCompletionOverrun),
     (MessageNumber : AxecConferenceFull;               MessageString : AxecSConferenceFull),
     (MessageNumber : AxecDialBilling;                  MessageString : AxecSDialBilling),
     (MessageNumber : AxecDialDialtone;                 MessageString : AxecSDialDialtone),
     (MessageNumber : AxecDialPrompt;                   MessageString : AxecSDialPrompt),
     (MessageNumber : AxecDialQuiet;                    MessageString : AxecSDialQuiet),
     (MessageNumber : AxecIncompatibleApiVersion;       MessageString : AxecSIncompatibleApiVersion),
     (MessageNumber : AxecIncompatibleExtVersion;       MessageString : AxecSIncompatibleExtVersion),
     (MessageNumber : AxecIniFileCorrupt;               MessageString : AxecSIniFileCorrupt),
     (MessageNumber : AxecInUse;                        MessageString : AxecSInUse),
     (MessageNumber : AxecInvalAddress;                 MessageString : AxecSInvalAddress),
     (MessageNumber : AxecInvalAddressID;               MessageString : AxecSInvalAddressID),
     (MessageNumber : AxecInvalAddressMode;             MessageString : AxecSInvalAddressMode),
     (MessageNumber : AxecInvalAddressState;            MessageString : AxecSInvalAddressState),
     (MessageNumber : AxecInvalAppHandle;               MessageString : AxecSInvalAppHandle),
     (MessageNumber : AxecInvalAppName;                 MessageString : AxecSInvalAppName),
     (MessageNumber : AxecInvalBearerMode;              MessageString : AxecSInvalBearerMode),
     (MessageNumber : AxecInvalCallComplMode;           MessageString : AxecSInvalCallComplMode),
     (MessageNumber : AxecInvalCallHandle;              MessageString : AxecSInvalCallHandle),
     (MessageNumber : AxecInvalCallParams;              MessageString : AxecSInvalCallParams),
     (MessageNumber : AxecInvalCallPrivilege;           MessageString : AxecSInvalCallPrivilege),
     (MessageNumber : AxecInvalCallSelect;              MessageString : AxecSInvalCallSelect),
     (MessageNumber : AxecInvalCallState;               MessageString : AxecSInvalCallState),
     (MessageNumber : AxecInvalCallStatelist;           MessageString : AxecSInvalCallStatelist),
     (MessageNumber : AxecInvalCard;                    MessageString : AxecSInvalCard),
     (MessageNumber : AxecInvalCompletionID;            MessageString : AxecSInvalCompletionID),
     (MessageNumber : AxecInvalConfCallHandle;          MessageString : AxecSInvalConfCallHandle),
     (MessageNumber : AxecInvalConsultCallHandle;       MessageString : AxecSInvalConsultCallHandle),
     (MessageNumber : AxecInvalCountryCode;             MessageString : AxecSInvalCountryCode),
     (MessageNumber : AxecInvalDeviceClass;             MessageString : AxecSInvalDeviceClass),
     (MessageNumber : AxecInvalDeviceHandle;            MessageString : AxecSInvalDeviceHandle),
     (MessageNumber : AxecInvalDialParams;              MessageString : AxecSInvalDialParams),
     (MessageNumber : AxecInvalDigitList;               MessageString : AxecSInvalDigitList),
     (MessageNumber : AxecInvalDigitMode;               MessageString : AxecSInvalDigitMode),
     (MessageNumber : AxecInvalDigits;                  MessageString : AxecSInvalDigits),
     (MessageNumber : AxecInvalExtVersion;              MessageString : AxecSInvalExtVersion),
     (MessageNumber : AxecInvalGroupID;                 MessageString : AxecSInvalGroupID),
     (MessageNumber : AxecInvalLineHandle;              MessageString : AxecSInvalLineHandle),
     (MessageNumber : AxecInvalLineState;               MessageString : AxecSInvalLineState),
     (MessageNumber : AxecInvalLocation;                MessageString : AxecSInvalLocation),
     (MessageNumber : AxecInvalMediaList;               MessageString : AxecSInvalMediaList),
     (MessageNumber : AxecInvalMediaMode;               MessageString : AxecSInvalMediaMode),
     (MessageNumber : AxecInvalMessageID;               MessageString : AxecSInvalMessageID),
     (MessageNumber : AxecInvalParam;                   MessageString : AxecSInvalParam),
     (MessageNumber : AxecInvalParkID;                  MessageString : AxecSInvalParkID),
     (MessageNumber : AxecInvalParkMode;                MessageString : AxecSInvalParkMode),
     (MessageNumber : AxecInvalPointer;                 MessageString : AxecSInvalPointer),
     (MessageNumber : AxecInvalPrivSelect;              MessageString : AxecSInvalPrivSelect),
     (MessageNumber : AxecInvalRate;                    MessageString : AxecSInvalRate),
     (MessageNumber : AxecInvalRequestMode;             MessageString : AxecSInvalRequestMode),
     (MessageNumber : AxecInvalTerminalID;              MessageString : AxecSInvalTerminalID),
     (MessageNumber : AxecInvalTerminalMode;            MessageString : AxecSInvalTerminalMode),
     (MessageNumber : AxecInvalTimeout;                 MessageString : AxecSInvalTimeout),
     (MessageNumber : AxecInvalTone;                    MessageString : AxecSInvalTone),
     (MessageNumber : AxecInvalToneList;                MessageString : AxecSInvalToneList),
     (MessageNumber : AxecInvalToneMode;                MessageString : AxecSInvalToneMode),
     (MessageNumber : AxecInvalTransferMode;            MessageString : AxecSInvalTransferMode),
     (MessageNumber : AxecLineMapperFailed;             MessageString : AxecSLineMapperFailed),
     (MessageNumber : AxecNoConference;                 MessageString : AxecSNoConference),
     (MessageNumber : AxecNoDevice;                     MessageString : AxecSNoDevice),
     (MessageNumber : AxecNoDriver;                     MessageString : AxecSNoDriver),
     (MessageNumber : AxecNoMem;                        MessageString : AxecSNoMem),
     (MessageNumber : AxecNoRequest;                    MessageString : AxecSNoRequest),
     (MessageNumber : AxecNotOwner;                     MessageString : AxecSNotOwner),
     (MessageNumber : AxecNotRegistered;                MessageString : AxecSNotRegistered),
     (MessageNumber : AxecOperationFailed;              MessageString : AxecSOperationFailed),
     (MessageNumber : AxecOperationUnavail;             MessageString : AxecSOperationUnavail),
     (MessageNumber : AxecRateUnavail;                  MessageString : AxecSRateUnavail),
     (MessageNumber : AxecResourceUnavail;              MessageString : AxecSResourceUnavail),
     (MessageNumber : AxecRequestOverrun;               MessageString : AxecSRequestOverrun),
     (MessageNumber : AxecStructureTooSmall;            MessageString : AxecSStructureTooSmall),
     (MessageNumber : AxecTargetNotFound;               MessageString : AxecSTargetNotFound),
     (MessageNumber : AxecTargetSelf;                   MessageString : AxecSTargetSelf),
     (MessageNumber : AxecUninitialized;                MessageString : AxecSUninitialized),
     (MessageNumber : AxecUserUserInfoTooBig;           MessageString : AxecSUserUserInfoTooBig),
     (MessageNumber : AxecReinit;                       MessageString : AxecSReinit),
     (MessageNumber : AxecAddressBlocked;               MessageString : AxecSAddressBlocked),
     (MessageNumber : AxecBillingRejected;              MessageString : AxecSBillingRejected),
     (MessageNumber : AxecInvalFeature;                 MessageString : AxecSInvalFeature),
     (MessageNumber : AxecNoMultipleInstance;           MessageString : AxecSNoMultipleInstance),

// Apro-specific TAPI messages -- see OOMISC.INC & ADTAPI.PAS

     (MessageNumber : AxecTapiBusy;                     MessageString : AxecSTapiBusy),
     (MessageNumber : AxecTapiNotSet;                   MessageString : AxecSTapiNotSet),
     (MessageNumber : AxecTapiNoSelect;                 MessageString : AxecSTapiNoSelect),
     (MessageNumber : AxecTapiLoadFail;                 MessageString : AxecSTapiLoadFail),
     (MessageNumber : AxecTapiGetAddrFail;              MessageString : AxecSTapiGetAddrFail),
     (MessageNumber : AxecTapi16Disabled;               MessageString : AxecSTapi16Disabled),
     (MessageNumber : AxecTapiUnexpected;               MessageString : AxecSTapiUnexpected),
     (MessageNumber : AxecTapiVoiceNotSupported;        MessageString : AxecSTapiVoiceNotSupported),
     (MessageNumber : AxecTapiWaveFail;                 MessageString : AxecSTapiWaveFail),
     (MessageNumber : AxecTapiCIDBlocked;               MessageString : AxecSTapiCIDBlocked),
     (MessageNumber : AxecTapiCIDOutOfArea;             MessageString : AxecSTapiCIDOutOfArea),
     (MessageNumber : AxecTapiWaveFormatError;          MessageString : AxecSTapiWaveFormatError),
     (MessageNumber : AxecTapiWaveReadError;            MessageString : AxecSTapiWaveReadError),
     (MessageNumber : AxecTapiWaveBadFormat;            MessageString : AxecSTapiWaveBadFormat),
     (MessageNumber : AxecTapiTranslateFail;            MessageString : AxecSTapiTranslateFail),
     (MessageNumber : AxecTapiWaveDeviceInUse;          MessageString : AxecSTapiWaveDeviceInUse),
     (MessageNumber : AxecTapiWaveFileExists;           MessageString : AxecSTapiWaveFileExists),
     (MessageNumber : AxecTapiWaveNoData;               MessageString : AxecSTapiWaveNoData),

// Apro-specific RAS messages -- see OOMISC.INC & ADRASUTL.PAS

     (MessageNumber : AxecRasLoadFail;                  MessageString : AxecSRasLoadFail),

// Logging (15xxx)

// Main categories

     (MessageNumber : AxdtNone;                         MessageString : AxdtSNone),
     (MessageNumber : AxdtDispatch;                     MessageString : AxdtSDispatch),
     (MessageNumber : AxdtTrigger;                      MessageString : AxdtSTrigger),
     (MessageNumber : AxdtError;                        MessageString : AxdtSError),
     (MessageNumber : AxdtThread;                       MessageString : AxdtSThread),
     (MessageNumber : AxdtTriggerAlloc;                 MessageString : AxdtSTriggerAlloc),
     (MessageNumber : AxdtTriggerDispose;               MessageString : AxdtSTriggerDispose),
     (MessageNumber : AxdtTriggerHandlerAlloc;          MessageString : AxdtSTriggerHandlerAlloc),
     (MessageNumber : AxdtTriggerHandlerDispose;        MessageString : AxdtSTriggerHandlerDispose),
     (MessageNumber : AxdtTriggerDataChange;            MessageString : AxdtSTriggerDataChange),
     (MessageNumber : AxdtTelnet;                       MessageString : AxdtSTelnet),
     (MessageNumber : AxdtFax;                          MessageString : AxdtSFax),
     (MessageNumber : AxdtXModem;                       MessageString : AxdtSXModem),
     (MessageNumber : AxdtYModem;                       MessageString : AxdtSYModem),
     (MessageNumber : AxdtZModem;                       MessageString : AxdtSZModem),
     (MessageNumber : AxdtKermit;                       MessageString : AxdtSKermit),
     (MessageNumber : AxdtAscii;                        MessageString : AxdtSAscii),
     (MessageNumber : AxdtBPlus;                        MessageString : AxdtSBPlus),
     (MessageNumber : AxdtPacket;                       MessageString : AxdtSPacket),
     (MessageNumber : AxdtUser;                         MessageString : AxdtSUser),
     (MessageNumber : AxdtScript;                       MessageString : AxdtSScript),

// Sub categories

     (MessageNumber : AxdstNone;                        MessageString : AxdstSNone),
     (MessageNumber : AxdstReadCom;                     MessageString : AxdstSReadCom),
     (MessageNumber : AxdstWriteCom;                    MessageString : AxdstSWriteCom),
     (MessageNumber : AxdstLineStatus;                  MessageString : AxdstSLineStatus),
     (MessageNumber : AxdstModemStatus;                 MessageString : AxdstSModemStatus),
     (MessageNumber : AxdstAvail;                       MessageString : AxdstSAvail),
     (MessageNumber : AxdstTimer;                       MessageString : AxdstSTimer),
     (MessageNumber : AxdstData;                        MessageString : AxdstSData),
     (MessageNumber : AxdstStatus;                      MessageString : AxdstSStatus),
     (MessageNumber : AxdstThreadStart;                 MessageString : AxdstSThreadStart),
     (MessageNumber : AxdstThreadExit;                  MessageString : AxdstSThreadExit),
     (MessageNumber : AxdstThreadSleep;                 MessageString : AxdstSThreadSleep),
     (MessageNumber : AxdstThreadWake;                  MessageString : AxdstSThreadWake),
     (MessageNumber : AxdstDataTrigger;                 MessageString : AxdstSDataTrigger),
     (MessageNumber : AxdstTimerTrigger;                MessageString : AxdstSTimerTrigger),
     (MessageNumber : AxdstStatusTrigger;               MessageString : AxdstSStatusTrigger),
     (MessageNumber : AxdstAvailTrigger;                MessageString : AxdstSAvailTrigger),
     (MessageNumber : AxdstWndHandler;                  MessageString : AxdstSWndHandler),
     (MessageNumber : AxdstProcHandler;                 MessageString : AxdstSProcHandler),
     (MessageNumber : AxdstEventHandler;                MessageString : AxdstSEventHandler),
     (MessageNumber : AxdstSWill;                       MessageString : AxdstSSWill),
     (MessageNumber : AxdstSWont;                       MessageString : AxdstSSWont),
     (MessageNumber : AxdstSDo;                         MessageString : AxdstSSDo),
     (MessageNumber : AxdstSDont;                       MessageString : AxdstSSDont),
     (MessageNumber : AxdstRWill;                       MessageString : AxdstSRWill),
     (MessageNumber : AxdstRWont;                       MessageString : AxdstSRWont),
     (MessageNumber : AxdstRDo;                         MessageString : AxdstSRDo),
     (MessageNumber : AxdstRDont;                       MessageString : AxdstSRDont),
     (MessageNumber : AxdstCommand;                     MessageString : AxdstSCommand),
     (MessageNumber : AxdstSTerm;                       MessageString : AxdstSSTerm),
     (MessageNumber : AxdsttfNone;                      MessageString : AxdstStfNone),
     (MessageNumber : AxdsttfGetEntry;                  MessageString : AxdstStfGetEntry),
     (MessageNumber : AxdsttfInit;                      MessageString : AxdstStfInit),
     (MessageNumber : Axdsttf1Init1;                    MessageString : AxdstStf1Init1),
     (MessageNumber : Axdsttf2Init1;                    MessageString : AxdstStf2Init1),
     (MessageNumber : Axdsttf2Init1A;                   MessageString : AxdstStf2Init1A),
     (MessageNumber : Axdsttf2Init1B;                   MessageString : AxdstStf2Init1B),
     (MessageNumber : Axdsttf2Init2;                    MessageString : AxdstStf2Init2),
     (MessageNumber : Axdsttf2Init3;                    MessageString : AxdstStf2Init3),
     (MessageNumber : AxdsttfDial;                      MessageString : AxdstStfDial),
     (MessageNumber : AxdsttfRetryWait;                 MessageString : AxdstStfRetryWait),
     (MessageNumber : Axdsttf1Connect;                  MessageString : AxdstStf1Connect),
     (MessageNumber : Axdsttf1SendTSI;                  MessageString : AxdstStf1SendTSI),
     (MessageNumber : Axdsttf1TSIResponse;              MessageString : AxdstStf1TSIResponse),
     (MessageNumber : Axdsttf1DCSResponse;              MessageString : AxdstStf1DCSResponse),
     (MessageNumber : Axdsttf1TrainStart;               MessageString : AxdstStf1TrainStart),
     (MessageNumber : Axdsttf1TrainFinish;              MessageString : AxdstStf1TrainFinish),
     (MessageNumber : Axdsttf1WaitCFR;                  MessageString : AxdstStf1WaitCFR),
     (MessageNumber : Axdsttf1WaitPageConnect;          MessageString : AxdstStf1WaitPageConnect),
     (MessageNumber : Axdsttf2Connect;                  MessageString : AxdstStf2Connect),
     (MessageNumber : Axdsttf2GetParams;                MessageString : AxdstStf2GetParams),
     (MessageNumber : AxdsttfWaitXon;                   MessageString : AxdstStfWaitXon),
     (MessageNumber : AxdsttfWaitFreeHeader;            MessageString : AxdstStfWaitFreeHeader),
     (MessageNumber : AxdsttfSendPageHeader;            MessageString : AxdstStfSendPageHeader),
     (MessageNumber : AxdsttfOpenCover;                 MessageString : AxdstStfOpenCover),
     (MessageNumber : AxdsttfSendCover;                 MessageString : AxdstStfSendCover),
     (MessageNumber : AxdsttfPrepPage;                  MessageString : AxdstStfPrepPage),
     (MessageNumber : AxdsttfSendPage;                  MessageString : AxdstStfSendPage),
     (MessageNumber : AxdsttfDrainPage;                 MessageString : AxdstStfDrainPage),
     (MessageNumber : Axdsttf1PageEnd;                  MessageString : AxdstStf1PageEnd),
     (MessageNumber : Axdsttf1PrepareEOP;               MessageString : AxdstStf1PrepareEOP),
     (MessageNumber : Axdsttf1SendEOP;                  MessageString : AxdstStf1SendEOP),
     (MessageNumber : Axdsttf1WaitMPS;                  MessageString : AxdstStf1WaitMPS),
     (MessageNumber : Axdsttf1WaitEOP;                  MessageString : AxdstStf1WaitEOP),
     (MessageNumber : Axdsttf1WaitMCF;                  MessageString : AxdstStf1WaitMCF),
     (MessageNumber : Axdsttf1SendDCN;                  MessageString : AxdstStf1SendDCN),
     (MessageNumber : Axdsttf1Hangup;                   MessageString : AxdstStf1Hangup),
     (MessageNumber : Axdsttf1WaitHangup;               MessageString : AxdstStf1WaitHangup),
     (MessageNumber : Axdsttf2SendEOP;                  MessageString : AxdstStf2SendEOP),
     (MessageNumber : Axdsttf2WaitFPTS;                 MessageString : AxdstStf2SendEOP),
     (MessageNumber : Axdsttf2WaitFET;                  MessageString : AxdstStf2WaitFET),
     (MessageNumber : Axdsttf2WaitPageOK;               MessageString : AxdstStf2WaitPageOK),
     (MessageNumber : Axdsttf2SendNewParams;            MessageString : AxdstStf2SendNewParams),
     (MessageNumber : Axdsttf2NextPage;                 MessageString : AxdstStf2NextPage),
     (MessageNumber : Axdsttf20CheckPage;               MessageString : AxdstStf20CheckPage),
     (MessageNumber : AxdsttfClose;                     MessageString : AxdstStfClose),
     (MessageNumber : AxdsttfCompleteOK;                MessageString : AxdstStfCompleteOK),
     (MessageNumber : AxdsttfAbort;                     MessageString : AxdstStfAbort),
     (MessageNumber : AxdsttfDone;                      MessageString : AxdstStfDone),
     (MessageNumber : AxdstrfNone;                      MessageString : AxdstSrfNone),
     (MessageNumber : AxdstrfInit;                      MessageString : AxdstSrfInit),
     (MessageNumber : Axdstrf1Init1;                    MessageString : AxdstSrf1Init1),
     (MessageNumber : Axdstrf2Init1;                    MessageString : AxdstSrf2Init1),
     (MessageNumber : Axdstrf2Init1A;                   MessageString : AxdstSrf2Init1A),
     (MessageNumber : Axdstrf2Init1B;                   MessageString : AxdstSrf2Init1B),
     (MessageNumber : Axdstrf2Init2;                    MessageString : AxdstSrf2Init1B),
     (MessageNumber : Axdstrf2Init3;                    MessageString : AxdstSrf2Init3),
     (MessageNumber : AxdstrfWaiting;                   MessageString : AxdstSrfWaiting),
     (MessageNumber : AxdstrfAnswer;                    MessageString : AxdstSrfAnswer),
     (MessageNumber : Axdstrf1SendCSI;                  MessageString : AxdstSrf1SendCSI),
     (MessageNumber : Axdstrf1SendDIS;                  MessageString : AxdstSrf1SendDIS),
     (MessageNumber : Axdstrf1CollectFrames;            MessageString : AxdstSrf1CollectFrames),
     (MessageNumber : Axdstrf1CollectRetry1;            MessageString : AxdstSrf1CollectRetry1),
     (MessageNumber : Axdstrf1CollectRetry2;            MessageString : AxdstSrf1CollectRetry2),
     (MessageNumber : Axdstrf1StartTrain;               MessageString : AxdstSrf1StartTrain),
     (MessageNumber : Axdstrf1CollectTrain;             MessageString : AxdstSrf1CollectTrain),
     (MessageNumber : Axdstrf1Timeout;                  MessageString : AxdstSrf1Timeout),
     (MessageNumber : Axdstrf1Retrain;                  MessageString : AxdstSrf1Retrain),
     (MessageNumber : Axdstrf1FinishTrain;              MessageString : AxdstSrf1FinishTrain),
     (MessageNumber : Axdstrf1SendCFR;                  MessageString : AxdstSrf1SendCFR),
     (MessageNumber : Axdstrf1WaitPageConnect;          MessageString : AxdstSrf1WaitPageConnect),
     (MessageNumber : Axdstrf2ValidConnect;             MessageString : AxdstSrf2ValidConnect),
     (MessageNumber : Axdstrf2GetSenderID;              MessageString : AxdstSrf2GetSenderID),
     (MessageNumber : Axdstrf2GetConnect;               MessageString : AxdstSrf2GetConnect),
     (MessageNumber : AxdstrfStartPage;                 MessageString : AxdstSrfStartPage),
     (MessageNumber : AxdstrfGetPageData;               MessageString : AxdstSrfGetPageData),
     (MessageNumber : Axdstrf1FinishPage;               MessageString : AxdstSrf1FinishPage),
     (MessageNumber : Axdstrf1WaitEOP;                  MessageString : AxdstSrf1WaitEOP),
     (MessageNumber : Axdstrf1WritePage;                MessageString : AxdstSrf1WritePage),
     (MessageNumber : Axdstrf1SendMCF;                  MessageString : AxdstSrf1SendMCF),
     (MessageNumber : Axdstrf1WaitDCN;                  MessageString : AxdstSrf1WaitDCN),
     (MessageNumber : Axdstrf1WaitHangup;               MessageString : AxdstSrf1WaitHangup),
     (MessageNumber : Axdstrf2GetPageResult;            MessageString : AxdstSrf2GetPageResult),
     (MessageNumber : Axdstrf2GetFHNG;                  MessageString : AxdstSrf2GetFHNG),
     (MessageNumber : AxdstrfComplete;                  MessageString : AxdstSrfComplete),
     (MessageNumber : AxdstrfAbort;                     MessageString : AxdstSrfAbort),
     (MessageNumber : AxdstrfDone;                      MessageString : AxdstSrfDone),
     (MessageNumber : AxdsttxInitial;                   MessageString : AxdstStxInitial),
     (MessageNumber : AxdsttxHandshake;                 MessageString : AxdstStxHandshake),
     (MessageNumber : AxdsttxGetBlock;                  MessageString : AxdstStxGetBlock),
     (MessageNumber : AxdsttxWaitFreeSpace;             MessageString : AxdstStxWaitFreeSpace),
     (MessageNumber : AxdsttxSendBlock;                 MessageString : AxdstStxSendBlock),
     (MessageNumber : AxdsttxDraining;                  MessageString : AxdstStxDraining),
     (MessageNumber : AxdsttxReplyPending;              MessageString : AxdstStxReplyPending),
     (MessageNumber : AxdsttxEndDrain;                  MessageString : AxdstStxEndDrain),
     (MessageNumber : AxdsttxFirstEndOfTransmit;        MessageString : AxdstStxFirstEndOfTransmit),
     (MessageNumber : AxdsttxRestEndOfTransmit;         MessageString : AxdstStxRestEndOfTransmit),
     (MessageNumber : AxdsttxEotReply;                  MessageString : AxdstStxEotReply),
     (MessageNumber : AxdsttxFinished;                  MessageString : AxdstStxFinished),
     (MessageNumber : AxdsttxDone;                      MessageString : AxdstStxDone),
     (MessageNumber : AxdstrxInitial;                   MessageString : AxdstSrxInitial),
     (MessageNumber : AxdstrxWaitForHSReply;            MessageString : AxdstSrxWaitForHSReply),
     (MessageNumber : AxdstrxWaitForBlockStart;         MessageString : AxdstSrxWaitForBlockStart),
     (MessageNumber : AxdstrxCollectBlock;              MessageString : AxdstSrxCollectBlock),
     (MessageNumber : AxdstrxProcessBlock;              MessageString : AxdstSrxProcessBlock),
     (MessageNumber : AxdstrxFinishedSkip;              MessageString : AxdstSrxFinishedSkip),
     (MessageNumber : AxdstrxFinished;                  MessageString : AxdstSrxFinished),
     (MessageNumber : AxdstrxDone;                      MessageString : AxdstSrxDone),
     (MessageNumber : AxdsttyInitial;                   MessageString : AxdstStyInitial),
     (MessageNumber : AxdsttyHandshake;                 MessageString : AxdstStyHandshake),
     (MessageNumber : AxdsttyGetFileName;               MessageString : AxdstStyGetFileName),
     (MessageNumber : AxdsttySendFileName;              MessageString : AxdstStySendFileName),
     (MessageNumber : AxdsttyDraining;                  MessageString : AxdstStyDraining),
     (MessageNumber : AxdsttyReplyPending;              MessageString : AxdstStyReplyPending),
     (MessageNumber : AxdsttyPrepXmodem;                MessageString : AxdstStyPrepXmodem),
     (MessageNumber : AxdsttySendXmodem;                MessageString : AxdstStySendXmodem),
     (MessageNumber : AxdsttyFinished;                  MessageString : AxdstStyFinished),
     (MessageNumber : AxdsttyFinishDrain;               MessageString : AxdstStyFinishDrain),
     (MessageNumber : AxdsttyDone;                      MessageString : AxdstStyDone),
     (MessageNumber : AxdstryInitial;                   MessageString : AxdstSryInitial),
     (MessageNumber : AxdstryDelay;                     MessageString : AxdstSryDelay),
     (MessageNumber : AxdstryWaitForHSReply;            MessageString : AxdstSryWaitForHSReply),
     (MessageNumber : AxdstryWaitForBlockStart;         MessageString : AxdstSryWaitForBlockStart),
     (MessageNumber : AxdstryCollectBlock;              MessageString : AxdstSryCollectBlock),
     (MessageNumber : AxdstryProcessBlock;              MessageString : AxdstSryProcessBlock),
     (MessageNumber : AxdstryOpenFile;                  MessageString : AxdstSryOpenFile),
     (MessageNumber : AxdstryPrepXmodem;                MessageString : AxdstSryPrepXmodem),
     (MessageNumber : AxdstryReceiveXmodem;             MessageString : AxdstSryReceiveXmodem),
     (MessageNumber : AxdstryFinished;                  MessageString : AxdstSryFinished),
     (MessageNumber : AxdstryDone;                      MessageString : AxdstSryDone),
     (MessageNumber : AxdsttzInitial;                   MessageString : AxdstStzInitial),
     (MessageNumber : AxdsttzHandshake;                 MessageString : AxdstStzHandshake),
     (MessageNumber : AxdsttzGetFile;                   MessageString : AxdstStzGetFile),
     (MessageNumber : AxdsttzSendFile;                  MessageString : AxdstStzSendFile),
     (MessageNumber : AxdsttzCheckFile;                 MessageString : AxdstStzCheckFile),
     (MessageNumber : AxdsttzStartData;                 MessageString : AxdstStzStartData),
     (MessageNumber : AxdsttzEscapeData;                MessageString : AxdstStzEscapeData),
     (MessageNumber : AxdsttzSendData;                  MessageString : AxdstStzSendData),
     (MessageNumber : AxdsttzWaitAck;                   MessageString : AxdstStzWaitAck),
     (MessageNumber : AxdsttzSendEof;                   MessageString : AxdstStzSendEof),
     (MessageNumber : AxdsttzDrainEof;                  MessageString : AxdstStzDrainEof),
     (MessageNumber : AxdsttzCheckEof;                  MessageString : AxdstStzCheckEof),
     (MessageNumber : AxdsttzSendFinish;                MessageString : AxdstStzSendFinish),
     (MessageNumber : AxdsttzCheckFinish;               MessageString : AxdstStzCheckFinish),
     (MessageNumber : AxdsttzError;                     MessageString : AxdstStzError),
     (MessageNumber : AxdsttzCleanup;                   MessageString : AxdstStzCleanup),
     (MessageNumber : AxdsttzDone;                      MessageString : AxdstStzDone),
     (MessageNumber : AxdstrzRqstFile;                  MessageString : AxdstSrzRqstFile),
     (MessageNumber : AxdstrzDelay;                     MessageString : AxdstSrzDelay),
     (MessageNumber : AxdstrzWaitFile;                  MessageString : AxdstSrzWaitFile),
     (MessageNumber : AxdstrzCollectFile;               MessageString : AxdstSrzCollectFile),
     (MessageNumber : AxdstrzSendInit;                  MessageString : AxdstSrzSendInit),
     (MessageNumber : AxdstrzSendBlockPrep;             MessageString : AxdstSrzSendBlockPrep),
     (MessageNumber : AxdstrzSendBlock;                 MessageString : AxdstSrzSendBlock),
     (MessageNumber : AxdstrzSync;                      MessageString : AxdstSrzSync),
     (MessageNumber : AxdstrzStartFile;                 MessageString : AxdstSrzStartFile),
     (MessageNumber : AxdstrzStartData;                 MessageString : AxdstSrzStartData),
     (MessageNumber : AxdstrzCollectData;               MessageString : AxdstSrzCollectData),
     (MessageNumber : AxdstrzGotData;                   MessageString : AxdstSrzGotData),
     (MessageNumber : AxdstrzWaitEof;                   MessageString : AxdstSrzWaitEof),
     (MessageNumber : AxdstrzEndOfFile;                 MessageString : AxdstSrzEndOfFile),
     (MessageNumber : AxdstrzSendFinish;                MessageString : AxdstSrzSendFinish),
     (MessageNumber : AxdstrzCollectFinish;             MessageString : AxdstSrzCollectFinish),
     (MessageNumber : AxdstrzError;                     MessageString : AxdstSrzError),
     (MessageNumber : AxdstrzWaitCancel;                MessageString : AxdstSrzWaitCancel),
     (MessageNumber : AxdstrzCleanup;                   MessageString : AxdstSrzCleanup),
     (MessageNumber : AxdstrzDone;                      MessageString : AxdstSrzDone),
     (MessageNumber : AxdsttkInit;                      MessageString : AxdstStkInit),
     (MessageNumber : AxdsttkInitReply;                 MessageString : AxdstStkInitReply),
     (MessageNumber : AxdsttkCollectInit;               MessageString : AxdstStkCollectInit),
     (MessageNumber : AxdsttkOpenFile;                  MessageString : AxdstStkOpenFile),
     (MessageNumber : AxdsttkSendFile;                  MessageString : AxdstStkSendFile),
     (MessageNumber : AxdsttkFileReply;                 MessageString : AxdstStkFileReply),
     (MessageNumber : AxdsttkCollectFile;               MessageString : AxdstStkCollectFile),
     (MessageNumber : AxdsttkCheckTable;                MessageString : AxdstStkCheckTable),
     (MessageNumber : AxdsttkSendData;                  MessageString : AxdstStkSendData),
     (MessageNumber : AxdsttkBlockReply;                MessageString : AxdstStkBlockReply),
     (MessageNumber : AxdsttkCollectBlock;              MessageString : AxdstStkCollectBlock),
     (MessageNumber : AxdsttkSendEof;                   MessageString : AxdstStkSendEof),
     (MessageNumber : AxdsttkEofReply;                  MessageString : AxdstStkEofReply),
     (MessageNumber : AxdsttkCollectEof;                MessageString : AxdstStkCollectEof),
     (MessageNumber : AxdsttkSendBreak;                 MessageString : AxdstStkSendBreak),
     (MessageNumber : AxdsttkBreakReply;                MessageString : AxdstStkBreakReply),
     (MessageNumber : AxdsttkCollectBreak;              MessageString : AxdstStkCollectBreak),
     (MessageNumber : AxdsttkComplete;                  MessageString : AxdstStkComplete),
     (MessageNumber : AxdsttkWaitCancel;                MessageString : AxdstStkWaitCancel),
     (MessageNumber : AxdsttkError;                     MessageString : AxdstStkError),
     (MessageNumber : AxdsttkDone;                      MessageString : AxdstStkDone),
     (MessageNumber : AxdstrkInit;                      MessageString : AxdstSrkInit),
     (MessageNumber : AxdstrkGetInit;                   MessageString : AxdstSrkGetInit),
     (MessageNumber : AxdstrkCollectInit;               MessageString : AxdstSrkCollectInit),
     (MessageNumber : AxdstrkGetFile;                   MessageString : AxdstSrkGetFile),
     (MessageNumber : AxdstrkCollectFile;               MessageString : AxdstSrkCollectFile),
     (MessageNumber : AxdstrkGetData;                   MessageString : AxdstSrkGetData),
     (MessageNumber : AxdstrkCollectData;               MessageString : AxdstSrkCollectData),
     (MessageNumber : AxdstrkComplete;                  MessageString : AxdstSrkComplete),
     (MessageNumber : AxdstrkWaitCancel;                MessageString : AxdstSrkWaitCancel),
     (MessageNumber : AxdstrkError;                     MessageString : AxdstSrkError),
     (MessageNumber : AxdstrkDone;                      MessageString : AxdstSrkDone),
     (MessageNumber : AxdsttaInitial;                   MessageString : AxdstStaInitial),
     (MessageNumber : AxdsttaGetBlock;                  MessageString : AxdstStaGetBlock),
     (MessageNumber : AxdsttaWaitFreeSpace;             MessageString : AxdstStaWaitFreeSpace),
     (MessageNumber : AxdsttaSendBlock;                 MessageString : AxdstStaSendBlock),
     (MessageNumber : AxdsttaSendDelay;                 MessageString : AxdstStaSendDelay),
     (MessageNumber : AxdsttaFinishDrain;               MessageString : AxdstStaFinishDrain),
     (MessageNumber : AxdsttaFinished;                  MessageString : AxdstStaFinished),
     (MessageNumber : AxdsttaDone;                      MessageString : AxdstStaDone),
     (MessageNumber : AxdstraInitial;                   MessageString : AxdstSraInitial),
     (MessageNumber : AxdstraCollectBlock;              MessageString : AxdstSraCollectBlock),
     (MessageNumber : AxdstraProcessBlock;              MessageString : AxdstSraProcessBlock),
     (MessageNumber : AxdstraFinished;                  MessageString : AxdstSraFinished),
     (MessageNumber : AxdstraDone;                      MessageString : AxdstSraDone),
     (MessageNumber : AxdstEnable;                      MessageString : AxdstSEnable),
     (MessageNumber : AxdstDisable;                     MessageString : AxdstSDisable),
     (MessageNumber : AxdstStringPacket;                MessageString : AxdstSStringPacket),
     (MessageNumber : AxdstSizePacket;                  MessageString : AxdstSSizePacket),
     (MessageNumber : AxdstPacketTimeout;               MessageString : AxdstSPacketTimeout),
     (MessageNumber : AxdstStartStr;                    MessageString : AxdstSStartStr),
     (MessageNumber : AxdstEndStr;                      MessageString : AxdstSEndStr),
     (MessageNumber : AxdstIdle;                        MessageString : AxdstSIdle),
     (MessageNumber : AxdstWaiting;                     MessageString : AxdstSWaiting),
     (MessageNumber : AxdstCollecting;                  MessageString : AxdstSCollecting),

// Debug log entries for scripting

     (MessageNumber : AxLogScriptFileLoaded;            MessageString : AxSLogScriptFileLoaded),
     (MessageNumber : AxLogScriptEnterAllTriggers;      MessageString : AxSLogScriptEnterAllTriggers),
     (MessageNumber : AxLogScriptTimeoutTrigger;        MessageString : AxSLogScriptTimeoutTrigger),
     (MessageNumber : AxLogScriptDataTrigger;           MessageString : AxSLogScriptDataTrigger),
     (MessageNumber : AxLogScriptLeavingAllTriggers;    MessageString : AxSLogScriptLeavingAllTriggers),
     (MessageNumber : AxLogScriptCommand;               MessageString : AxSLogScriptCommand),
     (MessageNumber : AxLogScriptMatched;               MessageString : AxSLogScriptMatched),
     (MessageNumber : AxLogScriptNotMatched;            MessageString : AxSLogScriptNotMatched),
     (MessageNumber : AxLogScriptEnterProcessTillWait;  MessageString : AxSLogScriptEnterProcessTillWait),
     (MessageNumber : AxLogScriptScriptFinished;        MessageString : AxSLogScriptScriptFinished),
     (MessageNumber : AxLogScriptExitProcessTillWait;   MessageString : AxSLogScriptExitProcessTillWait),
     (MessageNumber : AxLogScriptEnterStartScript;      MessageString : AxSLogScriptEnterStartScript),
     (MessageNumber : AxLogScriptLeaveStartScript;      MessageString : AxSLogScriptLeaveStartScript),

//  headings
     (MessageNumber : AxHeader1;                        MessageString : AxSHeader1),
     (MessageNumber : AxHeader2;                        MessageString : AxSHeader2),

// modem tags

     (MessageNumber : AxMsTag1;                        MessageString : AxSMsTag1),
     (MessageNumber : AxMsTag2;                        MessageString : AxSMsTag2),
     (MessageNumber : AxMsTag3;                        MessageString : AxSMsTag3),
     (MessageNumber : AxMsTag4;                        MessageString : AxSMsTag4),
     (MessageNumber : AxMsTag5;                        MessageString : AxSMsTag6),
     (MessageNumber : AxMsTag6;                        MessageString : AxSMsTag6),
     (MessageNumber : AxMsTag7;                        MessageString : AxSMsTag7),
     (MessageNumber : AxMsTag8;                        MessageString : AxSMsTag8),

// Telnet tags
     (MessageNumber : AxTelent0;                       MessageString : AxSTelent0),
     (MessageNumber : AxTelent1;                       MessageString : AxSTelent1),
     (MessageNumber : AxTelent2;                       MessageString : AxSTelent2),
     (MessageNumber : AxTelent3;                       MessageString : AxSTelent3),
     (MessageNumber : AxTelent4;                       MessageString : AxSTelent4),
     (MessageNumber : AxTelent5;                       MessageString : AxSTelent5),
     (MessageNumber : AxTelent6;                       MessageString : AxSTelent6),
     (MessageNumber : AxTelent7;                       MessageString : AxSTelent7),
     (MessageNumber : AxTelent8;                       MessageString : AxSTelent8),
     (MessageNumber : AxTelent9;                       MessageString : AxSTelent9),
     (MessageNumber : AxTelent10;                      MessageString : AxSTelent11),
     (MessageNumber : AxTelent11;                      MessageString : AxSTelent11),
     (MessageNumber : AxTelent12;                      MessageString : AxSTelent12),
     (MessageNumber : AxTelent13;                      MessageString : AxSTelent13),
     (MessageNumber : AxTelent14;                      MessageString : AxSTelent15),
     (MessageNumber : AxTelent15;                      MessageString : AxSTelent15),
     (MessageNumber : AxTelent16;                      MessageString : AxSTelent16),
     (MessageNumber : AxTelent17;                      MessageString : AxSTelent17),
     (MessageNumber : AxTelent18;                      MessageString : AxSTelent18),
     (MessageNumber : AxTelent19;                      MessageString : AxSTelent19),
     (MessageNumber : AxTelent20;                      MessageString : AxSTelent20),
     (MessageNumber : AxTelent21;                      MessageString : AxSTelent21),
     (MessageNumber : AxTelent22;                      MessageString : AxSTelent22),
     (MessageNumber : AxTelent23;                      MessageString : AxSTelent23),
     (MessageNumber : AxTelent24;                      MessageString : AxSTelent24),
     (MessageNumber : AxTelent25;                      MessageString : AxSTelent25),
     (MessageNumber : AxTelent26;                      MessageString : AxSTelent26),
     (MessageNumber : AxTelent27;                      MessageString : AxSTelent27),
     (MessageNumber : AxTelent28;                      MessageString : AxSTelent28),
     (MessageNumber : AxTelent29;                      MessageString : AxSTelent29),
     (MessageNumber : AxTelent30;                      MessageString : AxSTelent30),
     (MessageNumber : AxTelent31;                      MessageString : AxSTelent31),
     (MessageNumber : AxTelent32;                      MessageString : AxSTelent32),
     (MessageNumber : AxTelent33;                      MessageString : AxSTelent33),
     (MessageNumber : AxTelent34;                      MessageString : AxSTelent34),
     (MessageNumber : AxTelent35;                      MessageString : AxSTelent35),
     (MessageNumber : AxTelent36;                      MessageString : AxSTelent36),
     (MessageNumber : AxTelent37;                      MessageString : AxSTelent37),
     (MessageNumber : AxTelent38;                      MessageString : AxSTelent38),
     (MessageNumber : AxTelent39;                      MessageString : AxSTelent39),
     (MessageNumber : AxTelent40;                      MessageString : AxSTelent40),
     (MessageNumber : AxTelent41;                      MessageString : AxSTelent41),
     (MessageNumber : AxTelent42;                      MessageString : AxSTelent42));

function MessageNumberToString (MessageNumber : integer) : string;

implementation

function MessageNumberToString (MessageNumber : integer) : string;
var
  Middle : integer;
  Min    : integer;
  Max    : integer;
  
begin
  result := '';

  Min := 0;
  Max := AxMaxMessages;

  while (Min <= Max) do begin
    Middle := Round ((Min + Max) / 2);
    if AxMessageNumberLookup[Middle].MessageNumber = MessageNumber then begin
      result := AxMessageNumberLookup[Middle].MessageString;
      exit;
    end else if MessageNumber < AxMessageNumberLookup[Middle].MessageNumber then
      Max := Middle - 1
    else
      Min := Middle + 1;
  end;
end;

end.
