(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{* XMLPartner: AxXExcpt.pas 2.5                          *}
{*********************************************************}
{* XMLPartner: XMLPartner's exception classes            *}
{*********************************************************}

{$I AxXDefin.inc}

unit AxXExcpt;

interface

uses
  SysUtils,
  AxXBase;

{Include error strings}
{$I AxXExcpt.inc}

type
  EApxException = class(Exception);

  EApxStreamError = class(EApxException)
  private
    seFilePos : Longint;
  public
    constructor CreateError(const FilePos : Longint;
                            const Reason  : DOMString);

    property FilePos : Longint
       read seFilePos;
  end;

  EApxFilterError = class(EApxStreamError)
  private
    feReason  : DOMString;
    feLine    : Longint;
    feLinePos : Longint;
  public
    constructor CreateError(const FilePos, Line, LinePos : Longint;
                            const Reason : DOMString);

    property Reason : DOMString
       read feReason;
    property Line : Longint
       read feLine;
    property LinePos : Longint
       read feLinePos;
  end;

  EApxParserError = class(EApxFilterError)
  protected
  public
    constructor CreateError({const FilePos,} Line, LinePos : Longint;
                            const Reason : DOMString); 
  end;

implementation

constructor EApxStreamError.CreateError(const FilePos : Longint;
                                       const Reason  : DOMString);
begin
  inherited Create(Reason);

  seFilePos := FilePos;
end;
{******************************************************************************}
constructor EApxFilterError.CreateError(const FilePos,
                                             Line,
                                             LinePos : Longint;
                                       const Reason  : DOMString);
begin
  inherited CreateError(FilePos, Reason);

  feLine := Line;
  feLinePos := LinePos;
  feReason := Reason;
end;
{******************************************************************************}
constructor EApxParserError.CreateError(Line,
                                       LinePos : Longint;
                                    const   Reason  : DOMString);
begin
  inherited CreateError(FilePos, Line, LinePos, Reason);
end;

end.
