(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                   AxXPort.pas 1.02                    *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F+}

unit AxXPort;

interface

uses
  SysUtils,
  Classes,
  QForms,
  QGraphics,
  QDialogs,
  AxPort,
  QStdCtrls,
  QExtCtrls,
  QControls,
  AxSelCom;

type
  TComPortOptions = class(TForm)
    FlowControlBox: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    HwFlow: TCheckBox;
    SoftwareXmit: TCheckBox;
    SoftwareRcv: TCheckBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Bauds: TRadioGroup;
    Paritys: TRadioGroup;
    Databits: TRadioGroup;
    Stopbits: TRadioGroup;
    Comports: TGroupBox;
    OK: TButton;
    Cancel: TButton;
    PortComboBox: TComboBox;
    procedure OKClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure PortComboBoxChange(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private
    FShowPorts       : Boolean;
    FComPort   : TApxComPort;
    Executed   : Boolean;

  protected
    function GetComPort : TApxComPort;
    procedure SetComPort(NewPort : TApxComPort);

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: Boolean;

    property ComPort : TApxComPort
      read GetComPort write SetComPort;
    property ShowPorts : Boolean
      read FShowPorts write FShowPorts;
  end;

var
  ComPortOptions: TComPortOptions;

implementation

{$R *.xfm}

const
  BaudValues : array[0..9] of Word =
    (30, 60, 120, 240, 480, 960, 1920, 3840, 5760, 11520);

constructor TComPortOptions.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FComPort := TApxComPort.Create(Self);
  Executed := False;
  FShowPorts       := True;
end;

destructor TComPortOptions.Destroy;
begin
  FComPort.Free;
  inherited Destroy;
end;

function TComPortOptions.Execute: Boolean;
var
  I : Word;
  CheckBaud : Word;
  E : TComSelectForm;
begin
  {Update dialog controls}
  Bauds.ItemIndex := 6;
  CheckBaud := FComPort.Baud div 10;
  for I := 0 to 9 do
    if CheckBaud = BaudValues[I] then begin
      Bauds.ItemIndex := I;
      break;
    end;
  Paritys.ItemIndex := Ord (FComPort.Parity);
  Databits.ItemIndex := 3 - Ord (FComPort.Databits);
  Stopbits.ItemIndex := Ord (FComPort.Stopbits);

  {Hardware flow}
  HwFlow.Checked := FComPort.HWFlowControl;

  {Software flow}
  SoftwareXmit.Checked := (FComPort.SWFlowControl = swfBoth) or
                          (FComPort.SWFlowControl = swfTransmit);
  SoftwareRcv.Checked := (FComPort.SWFlowControl = swfBoth) or
                         (FComPort.SWFlowControl = swfReceive);
  Edit1.Text := IntToStr (Ord (FComPort.XOnChar));
  Edit2.Text := IntToStr (Ord (FComPort.XOffChar));

  E := TComSelectForm.Create (Self);
  try
    PortComboBox.Items := E.PortsComboBox.Items; 

    ShowModal;
  finally
    E.Free;
  end;

  Result := ModalResult = mrOK;
  Executed := Result;
end;

function TComPortOptions.GetComPort : TApxComPort;
var
  SWOpts : TAxSWFlowControl;
  Temp   : Integer;
  Code   : Integer;
begin
  if Executed then begin
    {Update ComPort from dialog controls}
    FComPort.Baud := LongInt (BaudValues[Bauds.ItemIndex]) * 10;
    FComPort.Parity := TAxParity (Paritys.ItemIndex);
    FComPort.Databits := TAxDataBits (3 - Databits.ItemIndex);
    FComPort.Stopbits := TAxStopBits (Stopbits.ItemIndex);

    {Update HW flow}
    FComPort.HWFlowControl := HWFlow.Checked;

    {Update SW flow}
    if SoftwareXmit.Checked then
      if SoftwareRcv.Checked then
        SWOpts := swfBoth
      else
        SWOpts := swfTransmit
    else if SoftwareRcv.Checked then
      SWOpts := swfReceive
    else 
      SWOpts := swfNone;
    FComPort.SWFlowControl := SWOpts;

    Val(Edit1.Text, Temp, Code);
    if Code = 0 then
      FComPort.XOnChar := Char(Temp);
    Val(Edit2.Text, Temp, Code);
    if Code = 0 then
      FComPort.XOffChar := Char(Temp);
  end;
  Result := FComPort;
end;

procedure TComPortOptions.SetComPort(NewPort : TApxComPort);
begin
  if (NewPort <> FComPort) then
    FComPort.Assign(NewPort);
end;

procedure TComPortOptions.OKClick(Sender: TObject);
begin
  ModalResult := mrOK;
end;

procedure TComPortOptions.CancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TComPortOptions.PortComboBoxChange(Sender: TObject);
 var
  DeviceName : string; 
begin
  DeviceName := PortComboBox.Items[PortComboBox.ItemIndex];
  ComPort.DeviceName := DeviceName;
end;

procedure TComPortOptions.FormShow(Sender: TObject);
begin
 { Highlite the active device in the list }
  with PortComboBox do
    if Assigned(FComPort) then begin
      ItemIndex := Items.IndexOf (ComPort.DeviceName); 
    end;
end;

end.
