(***** BEGIN LICENSE BLOCK *****
 * This product is dual licensed.  Select the license that is most appropriate
 * for your situation.
 *
 * Version: LGPL 2.1
 *
 * The contents of this file are subject to the Lesser GNU Public License Version
 * 2.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.fsf.org/licenses/lgpl.txt
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)
{*********************************************************}
{*                    AxXUp.pas 1.02                     *}
{*********************************************************}

{Global defines potentially affecting this unit}
{$I AxDefine.inc}

{Options required for this unit}
{$G+,X+,F+}

unit AxXUp;

interface

uses
  SysUtils,
  Classes,
  QGraphics,
  QForms,
  QDialogs,
  AxProtcl,
  QStdCtrls,
  QControls,
  QExtCtrls;

type
  TUploadDialog = class(TForm)
    Protocols: TRadioGroup;
    Panel1: TPanel;
    Label1: TLabel;
    FileMask: TEdit;
    OK: TButton;
    Cancel: TButton;
    procedure OKClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
  public
    function GetProtocol : TApxProtocolType;
    procedure SetProtocol(NewProt : TApxProtocolType);
    function GetMask : String;
    procedure SetMask(NewMask : String);

    property Protocol : TApxProtocolType
      read GetProtocol write SetProtocol;
    property Mask : String
      read GetMask write SetMask;

    { Public declarations }
  end;

var
  UploadDialog: TUploadDialog;

implementation

{$R *.xfm}

function TUploadDialog.GetProtocol : TApxProtocolType;
begin
  Result := TApxProtocolType(Protocols.ItemIndex+1);
end;

procedure TUploadDialog.SetProtocol(NewProt : TApxProtocolType);
begin
  Protocols.ItemIndex := Ord(NewProt)-1;
end;

function TUploadDialog.GetMask : String;
begin
  Result := FileMask.Text;
end;

procedure TUploadDialog.SetMask(NewMask : String);
begin
  FileMask.Text := NewMask;
end;

procedure TUploadDialog.OKClick(Sender: TObject);
begin
  ModalResult := mrOK;
end;

procedure TUploadDialog.CancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
